/**************************************************************************************
 * @file         : LockoutRestrictionTypes.h
 * @addtogroup   : <AppHmi_Common>
 * @brief        : Contains user defined types.
 * @copyright    : (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/

#ifndef LOCKOUTRESTRICTIONTYPES_H_
#define LOCKOUTRESTRICTIONTYPES_H_

/**
 *  Struct stLockoutInfo is used to
 *  	- Hold the speedlock info for list.
*/
class stLockoutInfo
{
   public:
      stLockoutInfo(uint8_t category, uint8_t behaviour, uint8_t count) : Category(category)\
         , Behaviour(behaviour)\
         , Count(count)
      {
      }
      virtual ~stLockoutInfo()
      { }
      bool operator==(const stLockoutInfo& lockoutInfo)
      {
         return (lockoutInfo.Category == Category);
      }
      uint8_t Category; //eg: 27,17
      uint8_t Behaviour; // eg: P,O,N
      uint8_t Count; // 2,8,4
};


enum lockoutKDSConfig
{
   VIDEOPLAYINGRESTRICTION = 1,
   PICTURESLIDESHOWRESTRICTION,
   SMSTEXTINPUTRESTRICTION,
   FEATURESTUTORIALSRESTRICTION,
   SYSTEMUSERHANDBOOKRESTRICTION,
   TEXTINPUTRESTRICTION,
   PHONEDIALINPUTRESTRICTION,
   NAVIGATIONDESTINATIONINPUTRESTRICTION,
   MUSICRADIOCOVERDSPLAYRESTRICTION,
   GENERALHMIRESTRICTION,
   SEATSRESTRICTION,
   SERVICEACTIVATIONRESTRICTION,
   DISPLAYEDTEXTLENGHTRESTRICTION,
   HMIANIMATIONSRESTRICTION,
   TYREPRESSURERESETRESTRICTION,
   STATIONARYPICTUREINDICTIONRESTRICTION,
   ONEBYONELINEOPERATIONNONMUSICLISTSCROLLRESTRICTION,
   SMOOTHMAPSCROOLOPERATIONRESTRICTION,
   DRAGGINGOPERATIONRESTRICTION,
   PINCHINOUTOPERATIONRESTRICTION,
   USERPROFILERESTRICTION,
   HOMEMENUEDITIONRESTRICTION,
   CAMERASETTINGSRESTRICTION,
   MAPROTATIONRESTRICTION,
   PICTURETEXTBACKGROUNDDISPLAYRESTRICTION,
   NISSAN5OPERATIONCOUNTRESTRICTION,
   NISSAN8OPERATIONCOUNTRESTRICTION,
   RENAULT5OPERATIONCOUNTRESTRICTION,
   RENAULT8OPERATIONCOUNTRESTRICTION,
   AUDIOPLAYAUTOMATICALLYRESTRICTION,
   SYSTEMUPDATERESTRICTION,
   SXMSTOCK,
   ONEBYONELINEOPERATIONMUSICLISTSCROLLRESTRICTION
};


#endif /* LOCKOUTRESTRICTIONTYPES_H_ */
