/* ***************************************************************************************
* FILE:          ListRegistry.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListRegistry.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef ListRegistry_h
#define ListRegistry_h

#include "Widgets/2D/List/Data/ExpandableListViewModel.h"
//#include "AllWidgetMessages.h"
//#include "ListDataProviderBuilder.h"
#include "List/Data/ListDataProviderDistributor.h"

struct ListDataInfo
{
   uint32_t listId;
   uint32_t startIndex;
   uint32_t windowSize;
};


class ListImplementation
{
   public:
      ListImplementation();
      virtual ~ListImplementation();

      /* Creates a list data provider which should contain "reqItemCount" items starting with index "reqItemIndex". */
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg&)
      {
         return tSharedPtrDataProvider();
      }
      virtual tSharedPtrDataProvider getListDataProvider(uint32_t listId, int32_t reqItemIndex, uint32_t reqItemCount)
      {
         return getListDataProvider(ListDateProviderReqMsg(listId, reqItemIndex, reqItemCount, false, false));
      }

      ExpandableListViewModel* AddNewExpandableListViewModel(uint32_t expandableListId, uint32_t rawListId);

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);

      /******************************************************************************
      * This message is sent by the list widget when it requires new data.
      * This happens when the list is displayed or scrolled.
      ******************************************************************************/
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      virtual bool onCourierMessage(const ListDateProviderResMsg& oMsg);

      bool delegateCourierMessageToExpandableListViewModels(const Courier::Message& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_HMI_LISTPROVIDER)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ListDateProviderResMsg)
      COURIER_MSG_MAP_END();
   private:
      std::map<unsigned int, ExpandableListViewModel*> _expandableListViewModels;
};


class ListRegistry
{
   public:
      ListRegistry();
      virtual ~ListRegistry();
      ListRegistry(const ListRegistry&);

      void addListImplementation(uint32_t listid, ListImplementation* imp);
      void removeListImplementation(uint32_t listid);

      /* Updates the list widget identified by the specified listId.
      * A data provider will be requested from the registered list implementation which should contain "reqItemCount" items starting with index "reqItemIndex".
      * This data provider will be posted to the widget inside a ListDateProviderResMsg.
      */
      bool updateList(const ListDateProviderReqMsg& oMsg);
      bool updateList(uint32_t listId, int32_t reqItemIndex = 0, uint32_t reqItemCount = 0)
      {
         return updateList(ListDateProviderReqMsg(listId, reqItemIndex, reqItemCount, false, false));
      }

      static bool s_initialize();
      static void s_destroy();
      static ListRegistry& s_getInstance();

   private:
      ::std::map <uint32_t, ListImplementation*> _listCallbackMap;
      static ListRegistry* _theInstance;
};


#endif
