/* ***************************************************************************************
* FILE:          ListModel.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  ListModel.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "Common/DataModel/ListModel.h"

/******************************************************************************
*
******************************************************************************/
AbstractListModel::AbstractListModel(unsigned int listId, DataItemContext listItemTemplate)
   : Base(), _listId(listId), _listItemTemplate(listItemTemplate), _selectedItemIndex(0)
{
}


/******************************************************************************
*
******************************************************************************/
AbstractListModel::~AbstractListModel()
{
   _listItemTemplate = NULL;
}


/******************************************************************************
*
******************************************************************************/
unsigned int AbstractListModel::getListId() const
{
   return _listId;
}


/******************************************************************************
*
******************************************************************************/
size_t AbstractListModel::getSelectedItemIndex() const
{
   return _selectedItemIndex;
}


/******************************************************************************
*
******************************************************************************/
void AbstractListModel::setSelectedItemIndex(size_t index)
{
   if (index != _selectedItemIndex)
   {
      _selectedItemIndex = index;
      onSelectedItemChanged();
   }
}


/******************************************************************************
*
******************************************************************************/
void AbstractListModel::sendUpdate()
{
   ListRegistry::s_getInstance().updateList(_listId, 0, 0);
}


/******************************************************************************
*
******************************************************************************/
void AbstractListModel::onSelectedItemChanged()
{
   sendUpdate();
}


/******************************************************************************
*
******************************************************************************/
tSharedPtrDataProvider AbstractListModel::getListDataProvider(unsigned int listId, int reqItemIndex, unsigned int reqItemCount)
{
   return getListDataProvider(ListDateProviderReqMsg(listId, reqItemIndex, reqItemCount, false, false));
}


tSharedPtrDataProvider AbstractListModel::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   if (oMsg.GetListId() != _listId)
   {
      return tSharedPtrDataProvider();
   }

   //use a list builder to fill the list data
   ListDataProviderBuilder listBuilder(_listId, _listItemTemplate);

   unsigned int startIndex = oMsg.GetStartIndex();
   //Deleted comparision to zero as startIndex is unsigned value

   unsigned int lastItemIndex = oMsg.GetStartIndex() + static_cast<int>(oMsg.GetWindowElementSize());
   if ((lastItemIndex == 0) || (lastItemIndex > static_cast<unsigned int>(getItemCount())))
   {
      lastItemIndex = static_cast<int>(getItemCount());
   }

   for (unsigned int index = startIndex; index < lastItemIndex; ++index)
   {
      addListItem(listBuilder, index, _selectedItemIndex == index);                      //lint !e732 !e737
   }

   return listBuilder.CreateDataProvider(startIndex, getItemCount());
}


/******************************************************************************
*
******************************************************************************/
bool AbstractListModel::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   //when an item selection is perfomed by pressing the list item button we also update the list content
   if ((oMsg.GetListId() == _listId) && (oMsg.GetReaction() == enRelease))
   {
      setSelectedItemIndex(oMsg.GetHdl());
      sendUpdate();

      return true;
   }
   return false;
}
