/**************************************************************************************
 * @file        : CGIApplicationProject.hpp
 * @addtogroup  : AppHmi_Master
 * @brief       : Implementation of the Class CGIApplicationProject
 * @copyright   : (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/

#ifndef CGI_APPLICATION_PROJECT_H
#define CGI_APPLICATION_PROJECT_H

#include "AppBase/CgiApplication.hpp"
#include "DummyFManagerConfigurator.h"
#include <Common/CGIAppController/CGIAppControllerProject.h>


template<typename TStatemachine>
class CgiApplicationProject : public CgiApplication<TStatemachine>
{
   public:
      virtual ~CgiApplicationProject();
      CgiApplicationProject(const char* assetFile, hmibase::services::hmiappctrl::ProxyHandler& proxyHandler);

   protected:
      virtual Focus::FManagerConfigurator* createFocusManagerConfigurator();
};


template<typename TStatemachine>
CgiApplicationProject<TStatemachine>::CgiApplicationProject(const char* assetFile, hmibase::services::hmiappctrl::ProxyHandler& proxyHandler)
   : CgiApplication<TStatemachine>(assetFile, proxyHandler)
{}


template<typename TStatemachine>
CgiApplicationProject<TStatemachine>::~CgiApplicationProject()
{}


template<typename TStatemachine>
Focus::FManagerConfigurator* CgiApplicationProject<TStatemachine>::createFocusManagerConfigurator()
{
   return new DummyFManagerConfigurator(Focus::FManager::getInstance());
}


#endif /* CGI_APPLICATION_PROJECT_H */
