/* ***************************************************************************************
* FILE:          CGIAppControllerProject.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppControllerProject.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#ifndef CGIAPPCONTROLLERPROJECT_H
#define CGIAPPCONTROLLERPROJECT_H

//lint -esym(1712, CGIApp*)     default constructor not defined
#include "HMIAppCtrl/Proxy/ProxyHandler.h"
#include <AppBase/AppControllerBase.h>
#include "ProjectBaseMsgs.h"

namespace hmibase {
namespace services {
namespace hmiappctrl {
class ProxyHandler;
}//hmiappctrl
}//services
}//hmibase


class CGIAppControllerProject : public hmibase::app::base::AppControllerBase
{
   public:

      using CGIAppControllerBase::onCourierMessage;

      explicit CGIAppControllerProject(hmibase::services::hmiappctrl::ProxyHandler& proxyHandler): CGIAppControllerBase(proxyHandler)
      {
      }

      virtual ~CGIAppControllerProject() {};
      virtual bool onCourierMessage(const Courier::ActivationResMsg& msg);
      virtual bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);
      bool onCourierMessage(const ButtonReactionMsg& /*msg*/);

      COURIER_MSG_MAP_BEGIN(0)
      COURIER_CASE_DUMMY_ENTRY()
      ON_COURIER_MESSAGE(Courier::ActivationResMsg)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)

      COURIER_MSG_MAP_END_DELEGATE(CGIAppControllerBase)
};


#endif // CGIAPPCONTROLLERPROJECT_H
