/* ***************************************************************************************
* FILE:          CGIAppControllerProject.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppControllerProject.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */
#include "gui_std_if.h"
#include "CGIAppControllerProject.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_SBCLIENT
#define ETG_I_FILE_PREFIX                 CGIAppControllerProject
#include "trcGenProj/Header/CGIAppControllerProject.cpp.trc.h"
using namespace hmibase::services::hmiappctrl;
#endif


/**
* onCourierMessage - Courier message handler for ActivationResMsg
* @param[in] : Message
* @return : TRUE if consumed
*/
bool CGIAppControllerProject::onCourierMessage(const Courier::ActivationResMsg& msg)
{
   ETG_TRACE_FATAL(("CGIAppControllerProject ActivationResMsg"));
   //Fixed Coverity warning of structurally dead code Task 883163
   return false;//allow other handlers to also get this message
}


/**
* onCourierMessage - Courier message handler for GuiStartupFinishedUpdMsg
* @param[in] : Message
* @return : TRUE if consumed
*/
bool CGIAppControllerProject::onCourierMessage(const GuiStartupFinishedUpdMsg& msg)
{
   ETG_TRACE_FATAL(("CGIAppControllerProject GuiStartupFinishedUpdMsg"));
#if !defined(_MSC_VER)
   RequestExternalImageStatusGetPayload payload(&_hmiAppCtrlProxyHandler);
   _hmiAppCtrlProxyHandler.sendLocalMessageHMIAppCtrl(payload);
#endif
   return false;
}


/**
* onCourierMessage - Courier message handler for ButtonReactionMsg
* @param[in] : Message
* @return : TRUE if consumed
*/
bool CGIAppControllerProject::onCourierMessage(const ButtonReactionMsg& /*msg*/)
{
   return false;
}
