/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : ApplicationSwitchClientComponent.h
* COMPONENT Name      : ApplicationSwitchClientComponent
* DESCRIPTION         : DBus client for Application switch intrerface.
* AUTHOR              : Tejas B V
* Date                : 23.08.2017
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/

#ifndef APPLICATIONSWITCH_CLIENT_COMPONENT_HEADER
#define APPLICATIONSWITCH_CLIENT_COMPONENT_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "ApplicationSwitchConst.h"
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;    //Change this
#define APPLICATIONSWITCH_TYPES    ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch

class ApplicationSwitchClientComponent : public ServiceAvailableIF,
   public RequestApplcationSwitchCallbackIF,
   public RequestShowHideWaitSceneCallbackIF,
   public Sig_activate_deactivate_SpeechSessionCallbackIF,
   public SpeechSession_activated_deactivatedCallbackIF,
   public ActivateDeactivateRVCSceneCallbackIF,
   public ActiveRegionIdCallbackIF,
   public RequestContextSwitchCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public SendContextCallbackIF
   , public DisplayAppFlyInReqCallbackIF
   , public Sig_ControlPanelButtonPressCallbackIF
{
   public:

      virtual ~ApplicationSwitchClientComponent();

      static ApplicationSwitchClientComponent* poGetInstance();

      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      virtual void onRequestApplcationSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchError >& error);
      virtual void onRequestApplcationSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchResponse >& response);

      virtual void onDisplayAppFlyInReqError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< DisplayAppFlyInReqError >& error);
      virtual void onDisplayAppFlyInReqResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< DisplayAppFlyInReqResponse >& response);

      virtual void onRequestShowHideWaitSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneError >& error);

      virtual void onRequestShowHideWaitSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneResponse >& response);

      virtual void onSig_activate_deactivate_SpeechSessionError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionError >& error);

      virtual void onSig_activate_deactivate_SpeechSessionSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionSignal >& signal);

      virtual void onSpeechSession_activated_deactivatedError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SpeechSession_activated_deactivatedError >& error);

      virtual void onSpeechSession_activated_deactivatedResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SpeechSession_activated_deactivatedResponse >& response);

      virtual void onActivateDeactivateRVCSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneError >& error);

      virtual void onActivateDeactivateRVCSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneResponse >& response);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error);

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      virtual void onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchError >& error);

      virtual void onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchResponse >& response);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error);

      virtual void onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response);

      virtual void onSig_ControlPanelButtonPressError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressError >& error);

      virtual void onSig_ControlPanelButtonPressSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressSignal >& signal);

      void requestContextSwitchApplication(uint8  regionId,
                                           uint8  sourceAppId,
                                           APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId,
                                           uint8  targetAppId,
                                           APPLICATIONSWITCH_TYPES::enActivityIDs  targetActivityId);
      void requestSwitchApplication(uint32 appID);
      void requestSendContext(uint8  regionId, uint8  sourceAppId,
                              APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId);
      void requestShowHideWaitScene(bool showhide);//Function used to hide or show Wait Animation Scene
      void requestShowHideRVCScene(bool showhide);//Function used to hide or show RVC Scene
      void requestShowHideAppFlyInScene(bool showhide);

      inline void setApplicationID(const uint32 appID)
      {
         _appID = appID;
      }
   private:
      ApplicationSwitchClientComponent();
      static ApplicationSwitchClientComponent* m_poSelfAppSwitchClient;
      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchClient;
      uint32 _appID;
};


#endif
