/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2015
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : ApplicationSwitchClientComponent.cpp
* COMPONENT Name      : ApplicationSwitchClientComponent
* DESCRIPTION         : DBus client for Application switch intrerface.
* AUTHOR              : Tejas B V
* Date                : 23.08.2017
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "ApplicationSwitchClientComponent.h"
#include "../CommonTrace.h"
#include "hmi_trace_if.h"
#include "ProjectBaseMsgs.h"
#include "ProjectBaseTypes.h"
#include <string>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_COMMON
#include "trcGenProj/Header/ApplicationSwitchClientComponent.cpp.trc.h"
#endif /* VARIANT_S_FTR_ENABLE_TRC_GEN */

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define PORTNAME "applicationSwitchPort"

ApplicationSwitchClientComponent* ApplicationSwitchClientComponent::m_poSelfAppSwitchClient = NULL;

ApplicationSwitchClientComponent::ApplicationSwitchClientComponent()
   : m_poApplicationSwitchClient(ApplicationSwitchProxy::createProxy(PORTNAME, *this))
{
   _appID = APPID_APPHMI_UNKNOWN;
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent constructor"));
}


ApplicationSwitchClientComponent::~ApplicationSwitchClientComponent()
{
   if (NULL != m_poSelfAppSwitchClient)
   {
      delete m_poSelfAppSwitchClient;
      m_poSelfAppSwitchClient = NULL;
   }
}


ApplicationSwitchClientComponent* ApplicationSwitchClientComponent::poGetInstance()
{
   /* No more than one instance of ApplicationSwitchClientComponent should be created */
   if (NULL == m_poSelfAppSwitchClient)
   {
      m_poSelfAppSwitchClient =  new ApplicationSwitchClientComponent();
   }
   return m_poSelfAppSwitchClient;
}


void ApplicationSwitchClientComponent::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   m_poApplicationSwitchClient->sendActiveRegionIdRegister(*this);
   m_poApplicationSwitchClient->sendSig_ActivateContextRegister(*this);
}


void ApplicationSwitchClientComponent::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
}


//This function is called by the applications for requesting application switch to server
void ApplicationSwitchClientComponent::requestSwitchApplication(uint32 appID)
{
   // ETG_TRACE_USR1("requestSwitchApplication appID %d", appID);
   if (NULL != m_poApplicationSwitchClient)
   {
      m_poApplicationSwitchClient->sendRequestApplcationSwitchRequest(*this, appID);
   }
}


//Function used to hide or show Wait Animation Scene
void ApplicationSwitchClientComponent::requestShowHideWaitScene(bool showhide)
{
   // ETG_TRACE_USR1("requestSwitchApplication appID %d", appID);
   if (NULL != m_poApplicationSwitchClient)
   {
      m_poApplicationSwitchClient->sendRequestShowHideWaitSceneRequest(*this, showhide);
   }
}


//Function used to hide or show RVC Scene
void ApplicationSwitchClientComponent::requestShowHideRVCScene(bool showhide)
{
   // ETG_TRACE_USR1("requestSwitchApplication appID %d", appID);
   if (NULL != m_poApplicationSwitchClient)
   {
      m_poApplicationSwitchClient->sendActivateDeactivateRVCSceneRequest(*this, showhide);
   }
}


void ApplicationSwitchClientComponent::onActivateDeactivateRVCSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneError >& error)
{
}


void ApplicationSwitchClientComponent::onActivateDeactivateRVCSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneResponse >& response)
{
}


//callback for sendRequestApplcationSwitchRequest
void ApplicationSwitchClientComponent::onRequestApplcationSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchResponse >& response)
{
}


void ApplicationSwitchClientComponent::onRequestApplcationSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchError >& error)
{
}


void ApplicationSwitchClientComponent::onRequestShowHideWaitSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneError >& error)
{
}


void ApplicationSwitchClientComponent::onRequestShowHideWaitSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneResponse >& response)
{
}


/************************************************
Function 	: onSig_activate_deactivate_SpeechSessionError
Parameters 	: error data

SYSFL/SWFL : SYSFL-4379
************************************************/
void ApplicationSwitchClientComponent::onSig_activate_deactivate_SpeechSessionError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionError >& error)
{
}


/************************************************
Function 	: onSig_activate_deactivate_SpeechSessionSignal
Parameters 	: signal

SYSFL/SWFL : SYSFL-4379
************************************************/
void ApplicationSwitchClientComponent::onSig_activate_deactivate_SpeechSessionSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_activate_deactivate_SpeechSessionSignal >& signal)
{
}


/************************************************
Function 	: onSpeechSession_activated_deactivatedError
Parameters 	: error data

SYSFL/SWFL : SYSFL-4379
************************************************/
void ApplicationSwitchClientComponent::onSpeechSession_activated_deactivatedError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SpeechSession_activated_deactivatedError >& error)
{
}


/************************************************
Function 	: onSpeechSession_activated_deactivatedResponse
Parameters 	: response

SYSFL/SWFL : SYSFL-4379
************************************************/
void ApplicationSwitchClientComponent::onSpeechSession_activated_deactivatedResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SpeechSession_activated_deactivatedResponse >& response)
{
}


void ApplicationSwitchClientComponent::onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onActiveRegionIdError: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onActiveRegionIdUpdate: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchError >& error)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onRequestContextSwitchError: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestContextSwitchResponse >& response)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onRequestContextSwitchResponse: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::requestContextSwitchApplication(uint8  regionId,
      uint8  sourceAppId,
      APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId,
      uint8  targetAppId,
      APPLICATIONSWITCH_TYPES::enActivityIDs  targetActivityId)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: requestContextSwitchApplication: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
   m_poApplicationSwitchClient->sendRequestContextSwitchRequest(*this, regionId, sourceAppId, sourceActivityId, targetAppId, targetActivityId);
}


void ApplicationSwitchClientComponent::requestSendContext(uint8  regionId, uint8  sourceAppId, APPLICATIONSWITCH_TYPES::enActivityIDs  sourceActivityId)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent::requestSendContext appid %d, sourcecontext %d", sourceAppId, sourceActivityId));
   m_poApplicationSwitchClient->sendSendContextRequest(*this, regionId, sourceAppId, sourceActivityId);
}


void ApplicationSwitchClientComponent::onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onSig_ActivateContextError: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onSig_ActivateContextSignal: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextError >& error)
{
}


void ApplicationSwitchClientComponent::onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< SendContextResponse >& response)
{
}


void ApplicationSwitchClientComponent::onDisplayAppFlyInReqError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< DisplayAppFlyInReqError >& error)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onDisplayAppFlyInReqError: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onDisplayAppFlyInReqResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< DisplayAppFlyInReqResponse >& response)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onDisplayAppFlyInReqResponse: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::requestShowHideAppFlyInScene(bool showhide)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: requestShowHideAppFlyInScene: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
   //m_poApplicationSwitchClient->sendDisplayAppFlyInReqRequest(*this, showhide);
}


void ApplicationSwitchClientComponent::onSig_ControlPanelButtonPressError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressError >& error)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onSig_ControlPanelButtonPressError: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
}


void ApplicationSwitchClientComponent::onSig_ControlPanelButtonPressSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ControlPanelButtonPressSignal >& signal)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientComponent: onSig_ControlPanelButtonPressSignal: ApplicationID  %d", ETG_CENUM(enApplicationId, _appID)));
   if (signal->getReceiverAppID() == _appID)
   {
      ControlPanelButtonPressInfo* oMsg =  COURIER_MESSAGE_NEW(ControlPanelButtonPressInfo)(signal->getButtonId(), signal->getButtonState());
      if (NULL != oMsg)
      {
         oMsg->Post();
      }
   }
}
