/* ***************************************************************************************
* FILE:          HMIAppDefines.h
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(Screendef_h)
//#include "ccaservice.h"

//#include <linux/input.h> // Linux key codes

/* Macros to be defined for including the needed OSAL files */
#define OSAL_S_IMPORT_INTERFACE_GENERIC

/*****************************************************************
| includes
|----------------------------------------------------------------*/
//#include "osal_if.h" // For including the OSAL related files.

#define Screendef_h


#define HMI_APP_ID_INVALID 0x0000
#define HOMESCREEN_APP_ID		    1//CCA_C_U16_APP_TEST_CLIENT_C2
#define TUNER_APP_ID       			2//CCA_C_U16_APP_TEST_CLIENT_A1
#define MEDIA_APP_ID       			3//CCA_C_U16_APP_MULTIMEDIA
#define PHONE_APP_ID       			4//CCA_C_U16_APP_HMI_11
#define NAVI_APP_ID        			5//CCA_C_U16_APP_HMI_12
#define SECURITY_APP_ID    			6//CCA_C_U16_APP_TEST_CLIENT_C4
#define SETTINGS_APP_ID    			7//CCA_C_U16_APP_HMI_SYSTEM_SETTING
#define SPEECH_APP_ID				8//CCA_C_U16_APP_SPEECH_UI
#define SPI_APP_ID					9//CCA_C_U16_APP_TEST_CLIENT_C3
#define RVC_APP_ID                  10//CCA_C_U16_APP_HMI_15
#define DIAGNOSIS_APP_ID			11//CCA_C_U16_APP_HMI_13
#define RECEPTION_APP_ID 			12

#define KEY_SPEECH						762
#define KEY_SETTINGS                    500
#define KEY_VOICERECOGNITION            248
#define KEY_ONHOOK                      KEY_CANCEL
#define KEY_OFFHOOK                     KEY_PHONE
#define KEY_HOME_AND_POWER              501
#define KEY_SETTINGS_AND_POWER          502

#define KEY_VOLUMEUP_SLIDE				503
#define KEY_VOLUMEDOWN_SLIDE			504
#define KEY_VOLUMEUP_SLIDE_DISPLAY		505
#define KEY_VOLUMEDOWN_SLIDE_DISPLAY	506
#define KEY_SPI							507

#define NO_TUNER_MEDIA_SOURCE 0
#define TUNER_ENTERTAINMENT_SOURCE 1
#define MEDIA_ENTERTAINMENT_SOURCE 2
#define SPI_ENTERTAINMENT_SOURCE 3
#define AUX_ENTERTAINMENT_SOURCE 4
#define BT_ENTERTAINMENT_SOURCE 5

#define APP_MGR_INPUT_LAYER_ID 6000
#define APP_MGR_INPUT_SURFACE_ID 5200
#define LAYER_SURFACE_ID_NORMAL_WIDTH 1
#define LAYER_SURFACE_ID_NORMAL_HEIGHT 480
#define LAYER_SURFACE_ID_HMIOFF_WIDTH 800
#define LAYER_SURFACE_ID_HMIOFF_HEIGHT 480
#define SURFACE_ID_NORMAL 1
#define SURFACE_ID_HMIOFF 2


#ifndef APPMGR_SMACTIVITIES_H
#define APPMGR_SMACTIVITIES_H

#define APPMGR_C_ACTIVITY_ID_NONE 0x00
#define APPMGR_C_ACTIVITY_ID_NO_CHANGE 0xFF
#define APPMGR_C_ACTIVITY_ID_DEEPHISTORY 0xFE

#define APPMGR_C_ACTIVITY_ID_SECURITY_DEFAULT 0x10
#define APPMGR_C_ACTIVITY_ID_HOME_DEFAULT 0x20
#define APPMGR_C_ACTIVITY_ID_TUNER_DEFAULT 0x30
#define APPMGR_C_ACTIVITY_ID_MEDIA_DEFAULT 0x40
#define APPMGR_C_ACTIVITY_ID_PHONE_DEFAULT 0x50
#define APPMGR_C_ACTIVITY_ID_NAVI_DEFAULT 0x60
#define APPMGR_C_ACTIVITY_ID_SETTINGS_DEFAULT 0x70
#define APPMGR_C_ACTIVITY_ID_SPEECH_DEFAULT 0x80
#define APPMGR_C_ACTIVITY_ID_SPI_DEFAULT 0x90
#define APPMGR_C_ACTIVITY_ID_RVC_DEFAULT 0xA0
#define APPMGR_C_ACTIVITY_ID_DIAGNOSIS_DEFAULT 0xB0

#define APPMGR_C_ACTIVITY_COUNT_SECURITY 1
#define APPMGR_C_ACTIVITY_COUNT_HOME 2
#define APPMGR_C_ACTIVITY_COUNT_TUNER 12
#define APPMGR_C_ACTIVITY_COUNT_MEDIA 10
#define APPMGR_C_ACTIVITY_COUNT_PHONE 6
#define APPMGR_C_ACTIVITY_COUNT_NAVI 6
#define APPMGR_C_ACTIVITY_COUNT_SETTINGS 4
#define APPMGR_C_ACTIVITY_COUNT_SPEECH 1
#define APPMGR_C_ACTIVITY_COUNT_SPI 5
#define APPMGR_C_ACTIVITY_COUNT_RVC 2
#define APPMGR_C_ACTIVITY_COUNT_DIAGNOSIS 2

typedef enum
{
   EN_KEY_EVENT_RELEASE = 0,
   EN_KEY_EVENT_PRESS = 1,
   EN_KEY_EVENT_SHORTHOLD = 2,
   EN_KEY_EVENT_LONG = 3,
   EN_KEY_EVENT_REPEAT = 4,
   EN_KEY_EVENT_LONG_RELEASE = 5,
   EN_KEY_EVENT_EXTRA_LONG = 6
} tenKeyEvents;

static enum
{
   eTunerMedia_INVALID  =  0x00   ,
   eTunerBank_AM_MW1              ,
   eTunerBank_AM_AST              ,
   eTunerBank_FM1                 ,
   eTunerBank_FM2                 ,
   eTunerBank_FMAST               ,
   eTunerBank_DAB                 ,
   eTunerBank_DAB_AST             ,
   eTunerBank_DRM                 ,
   eTunerBank_DRM_AST             ,
   eMediaSource_USB               ,
   eMediaSource_SD                ,
   eMediaSource_IPOD              ,
   eMediaSource_IPHONE            ,
   eMediaSource_BLUETOOTH         ,
   eMediaSource_AUX             ,
   eMediaSource_EXT_DVD
} eTunerMediaCurrentSource;

static enum
{
   eAppCommandID_None = 0x00,
   eAppCommandID_SET_MEASUREMENT_UNITS,
   eAppCommandID_DISPLAY_VOLUME_POPUP,
   eAppCommandID_RESET_FACTORY_SETTINGS,
   eAppCommandID_END_CARPLAY_GUIDANCE,
   eAppCommandID_END_NAVI_GUIDANCE,
   eAppCommandID_SPI_CARPLAY_LAUNCH,
   eAppCommandID_HOMEWHEEL_TUNER_SEEK,
   eAppCommandID_HOMEWHEEL_MEDIA_SEEK,
   eAppCommandID_SPI_CONNECTION_STATUS,
   eAppCommandID_HMI_STATE_Broadcast,
   eAppCommandID_SYSTEM_STATE_Broadcast,
   eAppCommandID_NAVI_AVAILABLE_Broadcast,
   //eCommandID_NAVI_AVAILABLE_Broadcast, ---Removed the enum purposfully as NAVI APP is using Command eAppCommandID_NAVI_AVAILABLE_Broadcast to broadcast carrier status.
   eAppCommandID_RVC_STATUS_Broadcast,
   eAppCommandID_SPI_DEVICE_REMOVED,
   eAppCommandID_NAVI_MAP_FREEZE_REQUEST,
   eAppCommandID_TUNER_CURRENT_BANK,
   eAppCommandID_SPI_APPFLYIN_STATUS,
   eAppCommandID_NAVIAPP_DISPLAY_Broadcast,
   eAppCommandID_SETTINGS_GET_MEASUREMENT_UNIT,
   eAppCommandID_SECURITY_APP_STATUS,
   eAppCommandID_SPI_CHECKBOX_STATUS,
   eAppCommandID_SPI_PROJECTIONMODE_STATUS,
   eAppCommandID_AppFlyIn_Activate_SPI,
   eAppCommandID_AAP_Projection_STATUS,
   eAppCommandID_DRM_FREQ_SET_Broadcast,
   eAppCommandID_SPI_Category_Info,
   eAppCommandID_Media_SrcStatus_AUX,
   eAppCommandID_Media_SrcStatus_EXTDVD,
   eAppCommandID_LOCK_KEYBOARD_STATUS,
   eAppCommandID_GET_SPI_CONNECTION_STATUS, // Get for the eAppCommandID_SPI_CONNECTION_STATUS
   eAppCommandID_GET_NAVI_AVAILABLE_Broadcast,//get for eAppCommandID_NAVI_AVAILABLE_Broadcast
   eAppCommandID_GET_RVC_STATUS_Broadcast,//Get for eAppCommandID_RVC_STATUS_Broadcast
   eAppCommandID_GET_TUNER_CURRENT_BANK,// Get for eAppCommandID_TUNER_CURRENT_BANK
   eAppCommandID_GET_SPI_APPFLYIN_STATUS,//Get for eAppCommandID_SPI_APPFLYIN_STATUS
   eAppCommandID_GET_NAVIAPP_DISPLAY_Broadcast,//Get for eAppCommandID_NAVIAPP_DISPLAY_Broadcast
   eAppCommandID_GET_SECURITY_APP_STATUS, //get for eAppCommandID_SECURITY_APP_STATUS
   eAppCommandID_GET_SPI_CHECKBOX_STATUS, //get for eAppCommandID_SPI_CHECKBOX_STATUS
   eAppCommandID_DRM_FREQ_GET_Broadcast, // get for eAppCommandID_DRM_FREQ_SET_Broadcast
   eAppCommandID_GET_SPI_Category_Info,//get for eAppCommandID_SPI_Category_Info
   eAppCommandID_GET_LOCK_KEYBOARD_STATUS, //get for eAppCommandID_LOCK_KEYBOARD_STATUS
   eAppCommandID_VR_SYSTEMACTION_REQUESTED,
   eAppCommandID_DRM_SEEK_STATUS,
   eAppCommandID_NativeVR_StatusInfo,
   eAppCommandID_Max
} eAppCommandList;

typedef enum
{
   NATIVE_VR_LISTENING = 0UL,
   NATIVE_VR_SPEAKING = 1UL
} tenNativeVRWindowState;

typedef enum
{
   /* SR Status : Active Speech recognition dialog active */
   NATIVE_VRSTATUS_ACTIVE = 0UL,

   /* SR Status : Inactive Speech recognition dialog inactive */
   NATIVE_VRSTATUS_INACTIVE = 1UL,
} tenNativeVRStatus;

static enum
{
   eAppGlobalEvt_None = 0x00,
   eAppGlobalEvt_BEEP_REQUEST_STATUS,
   eAppGlobalEvt_AUX_SOURCE_SKIP_STATUS,
   eAppGlobalEvt_EXTDVD_SOURCE_SKIP_STATUS,
   eAppGlobalEvt_USB_SOURCE_UPDATE,
   eAppGlobalEvt_IPOD_SOURCE_UPDATE,
   eAppGlobalEvt_BT_SOURCE_UPDATE,
   eAppGlobalEvt_SD_SOURCE_UPDATE,
   eAppGlobalEvt_APPLE_SOURCE_UPDATE,
   eAppGlobalEvt_BTRC_VOLUME_REQUEST,
   eAppGlobalEvt_PHONE_CALL_STATUS,
   eAppGlobalEvt_NAVI_AVAILABLE_STATUS,
   eAppGlobalEvt_SIRI_STATUS,
   eAppGlobalEvt_CARPLAY_STATUS,
   eAppGlobalEvt_TUNER_CURRENT_BANK,
   eAppGlobalEvt_BTRC_POWER_KEY,
   eAppGlobalEvt_BTRC_MUTE_KEY,
   eAppGlobalEvt_BT_PHONE_VEHICLE_AUDIO_STATUS,
   eAppGlobalEvt_SPI_CONNECTION_STATUS,
   eAppGlobalEvt_ANDROIDAUTO_STATUS,
   eAppGlobalEvt_REQUEST_AUX_EXTDVD_STATUS,
   eAppGlobalEvt_SECURITY_APP_ID = SECURITY_APP_ID,
   eAppGlobalEvt_Max
} eAppGlobalEvtList;


#define TUNER_BANK_FM1		1
#define TUNER_BANK_FM2	    2
#define TUNER_BANK_FM_AST   3
#define TUNER_BANK_AM		4
#define TUNER_BANK_AM_AST	5
#define TUNER_BANK_DAB		6
#define TUNER_BANK_DAB_AST	7


#define HMI_STATE_ON 2
#define HMI_STATE_OFF 1

#define PHONE_CALL_STATUS_IDLE           0
#define PHONE_CALL_STATUS_DIALING        1
#define PHONE_CALL_STATUS_ACTIVE         2
#define PHONE_CALL_STATUS_RINGTONE       8

#define PHONE_VEHICLE_AUDIO_HANDSET       0
#define PHONE_VEHICLE_AUDIO_HANDSFREE 	  1

#define NAVI_MAP_FREEZE 1
#define NAVI_MAP_UNFREEZE 0

typedef enum
{
   APPMGR_EN_AUX = 0,
   APPMGR_EN_DVD,
   APPMGR_EN_SDCARD
} tenDeviceProperties;


/* Volume configurations */
#define C_ID_INVALID -1 // Press area Id
#define C_VOLUME_SLIDER_ID 8 // Volume slider Id
#define C_VOLUME_NO_CHANGE 0 // No change in volume level
#define C_VOLUME_INC 2 // Increment the volume level
#define C_VOLUME_DEC 3 // Decrement the volume level
#define C_VOLUME_TIMER_NONE 0 // No timer configured
#define C_VOLUME_TIMER_LONG 800 // Timeout duration in msecs for long timer
#define C_VOLUME_TIMER_REPEAT 125 // Timeout duration in msecs for repeat timer
#define C_VOLUME_RANGE_BEGIN 0 // Volume slider axis value range begin value
#define C_VOLUME_RANGE_END 11 // Volume slider axis value range end value
#define C_VOLUME_LEVELS 30 // Number of volume levels supported
#define C_VOLUME_ONE_STEP 1 // Change in volume level by 1 
#define C_VOLUME_SWIPE_MIN_DISTANCE 2 // Min distance to be covered for swipe
#define C_VOLUME_SWIPE_MIN_SPEED 0.00 // Min speed to be met for swipe
#define C_VOLUME_MAX_STEPS_PER_SWIPE 9
#define C_VOLUME_AXIS_CAPTURE_FOR_SWIPE 125

#define MUTE_STATE_MUTE 1
#define MUTE_STATE_UNMUTE 2

#define EVENT_SOURCE_VOLUME_SLIDER 1

#define MIN_ENT_VOLUME 0
#define MAX_ENT_VOLUME 30
#define MIN_TA_VOLUME 0
#define MAX_TA_VOLUME 30
#define MIN_NAVI_VOLUME 5
#define MAX_NAVI_VOLUME 30
#define MIN_PHONE_VOLUME 5
#define MAX_PHONE_VOLUME 30
#define MIN_SPEECH_VOLUME 5
#define MAX_SPEECH_VOLUME 30

static enum
{
   EN_SPM_SYSTEM_BACKGROUND                = 5UL,
   EN_SPM_SYSTEM_PREPARE_SHUTDOWN          = 16UL,
   EN_SPM_SYSTEM_SHUTDOWN                  = 17UL,
   EN_SPM_SYSTEM_SUSPEND                   = 0UL,
   EN_SPM_SYSTEM_STANDBY                   = 1UL,
   EN_SPM_SYSTEM_OFF                       = 2UL,
   EN_SPM_SYSTEM_DOWNLOAD                  = 3UL,
   EN_SPM_SYSTEM_ON                        = 4UL,
   EN_SPM_SYSTEM_DOOR_OPEN                 = 6UL,
   EN_SPM_SYSTEM_IGNITION                  = 7UL,
   EN_SPM_SYSTEM_DIAGNOSIS                 = 8UL,
   EN_SPM_SYSTEM_STATE_PROFILE             = 9UL,
   EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_1    = 32UL,
   EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE_2    = 33UL,
   EN_SPM_SYSTEM_MMI_STANDBY               = 34UL,
   EN_SPM_SYSTEM_MMI_ON                    = 35UL,
   EN_SPM_SYSTEM_MMI_STANDBY_RESTRICTED    = 36UL,
   EN_SPM_SYSTEM_MMI_ON_DIAG               = 37UL,
   EN_SPM_SYSTEM_MMI_ON_TEL                = 38UL,
   EN_SPM_SYSTEM_MMI_ON_SWDL               = 39UL,
   EN_SPM_SYSTEM_MMI_STANDBY_CUSTOMER_SWDL = 40UL,
   EN_SPM_SYSTEM_MMI_STANDBY_PWR_SAVE      = 41UL,
   EN_SPM_SYSTEM_STATE_MAX                 = 42UL
} enSystemStates;

//Enums for different regions targers
typedef enum
{
   EN_HW_TYPE_NA = 0,
   EN_HW_TYPE_GEX,
   EN_HW_TYPE_GEX_CN,
   EN_HW_TYPE_EU,
   EN_HW_TYPE_EU_DAB,
   EN_HW_TYPE_GEX_DRM
} enHWType;

//Enums for different destination regions
typedef enum
{
   EN_REGION_NA = 0,
   EN_REGION_AUSTRALIA,
   EN_REGION_CHINA,
   EN_REGION_EUROPE,
   EN_REGION_INDIA,
   EN_REGION_MEXICO,
   EN_REGION_NEWZEALAND,
   EN_REGION_RUSSIA,
   EN_REGION_THAILAND,
   EN_REGION_TURKEY
} enDestinationRegion;

typedef enum
{
   eActivityID_NONE = APPMGR_C_ACTIVITY_ID_NONE

                      /* Activity IDs for Security */
   , eActivityID_SECURITY = APPMGR_C_ACTIVITY_ID_SECURITY_DEFAULT

                            /* Activity IDs for Home */
   , eActivityID_HOME = APPMGR_C_ACTIVITY_ID_HOME_DEFAULT
   , eActivityID_SECURITY_APP

   /* Activity IDs for Tuner */
   , eActivityID_TUNER = APPMGR_C_ACTIVITY_ID_TUNER_DEFAULT
   , eActivityID_TUNER_SOURCE_SELECTION
   , eActivityID_TUNER_FM1
   , eActivityID_TUNER_FM2
   , eActivityID_TUNER_FM_AST
   , eActivityID_TUNER_AM
   , eActivityID_TUNER_AM_AST
   , eActivityID_TUNER_DAB
   , eActivityID_TUNER_DAB_AST
   , eActivityID_TUNER_DRM
   , eActivityID_TUNER_DRM_AST
   , eActivityID_TUNER_SETTINGS_VIEW

   /* Activity IDs for Media */
   , eActivityID_MEDIA_SOURCE_SELECTION = APPMGR_C_ACTIVITY_ID_MEDIA_DEFAULT
   , eActivityID_MEDIA_PLAY
   , eActivityID_MEDIA_AUX
   , eActivityID_MEDIA_DVD
   , eActivityID_MEDIA_USB
   , eActivityID_MEDIA_BTSTREAMING
   , eActivityID_MEDIA_SDCARD
   , eActivityID_MEDIA_IPOD
   , eActivityID_MEDIA_SETTINGS_VIEW
   , eActivityID_MEDIA_SOURCE_SWITCH

   /* Activity IDs for Phone */
   , eActivityID_PHONE_DEVICE_SELECTION = APPMGR_C_ACTIVITY_ID_PHONE_DEFAULT
   , eActivityID_PHONE_CALL_LIST
   , eActivityID_PHONE_CONTACT_LIST
   , eActivityID_PHONE_CALL_CONNECTING
   , eActivityID_PHONE_ON_CALL
   , eActivityID_PHONE_ON_MULTIPARTY_CALL

   /* Activity IDs for Navi */
   , eActivityID_NAVI_MAP = APPMGR_C_ACTIVITY_ID_NAVI_DEFAULT
   , eActivityID_NAVI_DESTINATIONS
   , eActivityID_NAVI_FAVOURITES
   , eActivityID_NAVI_TMC
   , eActivityID_NAVI_LAST_DESTINATIONS
   , eActivityID_NAVI_ACTIVERG

   /* Activity IDs for Settings */
   , eActivityID_SETTINGS = APPMGR_C_ACTIVITY_ID_SETTINGS_DEFAULT
   , eActivityID_SETTINGS_VOLUME
   , eActivityID_MEDIA_SOUND_SETTINGS
   , eActivityID_TUNER_SOUND_SETTINGS

   /* Activity IDs for Speech */
   , eActivityID_SPEECH = APPMGR_C_ACTIVITY_ID_SPEECH_DEFAULT

                          /* Activity IDs for SPI */
   , eActivityID_SPI_APPLICATION_LIST = APPMGR_C_ACTIVITY_ID_SPI_DEFAULT
   , eActivityID_SPI_NOPHONECONNECTED
   , eActivityID_SPI_FULL_SCREEN
   , eActivityID_SPI_PHONE_SELECTION
   , eActivityID_SPI_SIRI

   /* Activity IDs for RVC */
   , eActivityID_RVC = APPMGR_C_ACTIVITY_ID_RVC_DEFAULT
   , eActivityID_RVC_SETTINGS

   /* Activity IDs for Customer Diagnosis */
   , eActivityID_DIAGNOSIS = APPMGR_C_ACTIVITY_ID_DIAGNOSIS_DEFAULT
   , eActivityID_ENGINEERING_DIAGNOSIS

   , eActivityID_DEEPHISTORY = APPMGR_C_ACTIVITY_ID_DEEPHISTORY

   , eActivityID_NO_CHANGE = APPMGR_C_ACTIVITY_ID_NO_CHANGE
} enActivityIDs;

#define BROADCAST_TO_ALL_APP 0xFFFF
/*********** Defined in linux/input.h ************
KEY_H                35 // Home
KEY_P                25 // Phone
KEY_N                49 // Navigation
KEY_T                20 // Tuner
KEY_M						50 // Media
KEY_E						18 // Security
KEY_L						38 // Settings
KEY_S						31 // Speech
KEY_I						23 // SPI
*************************************************/
#endif

#endif
