/************************************************************************
*FILE: 			TunerViewDefines.h
*SW-COMPONENT: 	Tuner
*DESCRIPTION: 	Macros and Datatypes required by View components
*AUTHOR: 		Shrivani
*COPYRIGHT: 	(c) 2018-2020 Robert Bosch Car Multimedia GmbH
*HISTORY:
*05.03.13 Rev. 1.0 Shrivani
* 	      Initial Revision.
************************************************************************/

#ifndef TUNERVIEWDEFINES_HEADER
#define TUNERVIEWDEFINES_HEADER

/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

//defines arranged according to the query -NameTableUsageRecord Library="Scene2D" NameTableEntry="DocumentView" LibraryItemCanderaName=


#define C_PFO_PTY31_NAME                "TunerModule#SysPopupScene#Pfo_PTY31"
#define C_PFO_TA_NAME                   "TunerModule#SysPopupScene#Pfo_TA"
#define C_PFO_WB_NAME                   "TunerModule#SysPopupScene#Pfo_WB"
#define C_PFO_CANNOTSTORE               "TunerModule#TunerPopupScene#Pfo_CannotStore"
#define C_PFO_STOREPRESET_NAME          "TunerModule#TunerPopupScene#Pfo_StorePreset"
#define C_PFO_UPDATEDAB_SL              "TunerModule#TunerPopupScene#Pfo_UpdateDAB_SL"
#define C_PFO_UPDATEFM_SL              "TunerModule#TunerPopupScene#Pfo_UpdateFM_SL"
#define C_R_AF_L                        "TunerModule#TunerScenes#R_AF_L"
#define C_R_AM_AST_S_NAME               "TunerModule#TunerScenes#R_AM_AST_S"
#define C_R_AM_MONITOR_TESTMODE         "TunerModule#TunerScenes#R_AM_MonitorTestMode"
#define C_R_AM_S_NAME                   "TunerModule#TunerScenes#R_AM_S"
#define C_R_AM_TESTMODE                 "TunerModule#TunerScenes#R_AM_TestMode"
#define C_R_DAB                         "TunerModule#TunerScenes#R_DAB"
#define C_R_DAB_AST                     "TunerModule#TunerScenes#R_DAB_AST"
#define C_R_DAB_EXPERT_API_TESTMODE     "TunerModule#TunerScenes#R_DAB_Expert_API_TestMode"
#define C_R_DAB_MONITOR                 "TunerModule#TunerScenes#R_DAB_Monitor"
#define C_R_DAB_QUALITY_TESTMODE        "TunerModule#TunerScenes#R_DAB_Quality_TestMode"
#define C_R_DAB_SL                      "TunerModule#TunerScenes#R_DAB_SL"
#define C_R_DAB_SERVICE_INFO_TESTMODE   "TunerModule#TunerScenes#R_DAB_Service_Info_TestMode"
#define C_R_DAB_SETUP_MONITOR           "TunerModule#TunerScenes#R_DAB_Setup_Monitor"
#define C_R_DRM                         "TunerModule#TunerScenes#R_DRM"
#define C_R_DRM_AST                     "TunerModule#TunerScenes#R_DRM_AST"
#define C_R_DRM_SL                      "TunerModule#TunerScenes#R_DRM_SL"
#define C_R_DRM_TESTMODE                "TunerModule#TunerScenes#R_DRM_TestMode"
#define C_R_DRM_TESTMODESCREEN          "TunerModule#TunerScenes#R_DRM_TestModeScreen"
#define C_R_FM1_S_NAME                  "TunerModule#TunerScenes#R_FM1_S"
#define C_R_FM2_S_NAME                  "TunerModule#TunerScenes#R_FM2_S"
#define C_R_FM_AST_S_NAME               "TunerModule#TunerScenes#R_FM_AST_S"
#define C_R_FM_MONITOR_TESTMODE         "TunerModule#TunerScenes#R_FM_MonitorTestMode"
#define C_R_FM_SL                       "TunerModule#TunerScenes#R_FM_SL"
#define C_R_FM_TESTMODE                 "TunerModule#TunerScenes#R_FM_TestMode"
#define C_R_FM_TRIPLE_TUNER_MONITOR1     "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor"
#define C_R_FM_TRIPLE_TUNER_MONITOR2    "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor2"
#define C_R_FM_TRIPLE_TUNER_MONITOR3    "TunerModule#TunerScenes#R_FM_Triple_Tuner_Monitor3"
#define C_R_OPT_DABPTY                  "TunerModule#TunerScenes#R_OPT_DABPTY"
#define C_R_OPT_DRMPTY                  "TunerModule#TunerScenes#R_OPT_DRMPTY"
#define C_R_OPT_FMAM_NAME               "TunerModule#TunerScenes#R_OPT_FMAM"
#define C_R_SourceSelection_Radio_NAME  "TunerModule#TunerScenes#R_SourceSelection_Radio"
#define C_R_SOURCESELECTION_WONAVI      "TunerModule#TunerScenes#R_SourceSelection_Radio_woNav"
#define C_R_WEATHERBAND                 "TunerModule#TunerScenes#R_WeatherBand"
#define C_R_FM_INFO                     "TunerModule#TunerScenes#R_FM_INFO"
#define C_R_AM_INFO                     "TunerModule#TunerScenes#R_AM_INFO"
#define C_R_HDDTM_TESTMODE              "TunerModule#TunerScenes#R_HDDTM_TestMode"
#define C_R_HDPARAMTUNING_TESTMODE      "TunerModule#TunerScenes#R_HDPARAMTUNING_TESTMODE"


#define C_R_TMC                         "TunerModule#TunerScenes#R_TMC"
#define C_R_TMC_L                       "TunerModule#TunerScenes#R_TMC_L"
#define C_R_TMC_INFO                    "TunerModule#TunerScenes#R_TMC_INFO"
#define C_R_TMC_STN_INFO                "TunerModule#TunerScenes#R_TMC_STN_INFO"
#define C_R_TestModeScreens             "TunerModule#TunerScenes#R_TestModeScreens"
#endif // TUNERVIEWDEFINES_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
