/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_TunerMessages.h"
// the views
#include "CGIAppViewController_Tuner.h"


SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AM_S),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM1_S),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM2_S),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AM_AST_S),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_AST_S),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_AST),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_SL),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_OPT_DABPTY),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_SourceSelection_Radio),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_SourceSelection_Radio_woNav),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_OPT_FMAM),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_SL),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_MonitorTestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AM_MonitorTestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_Triple_Tuner_Monitor3),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Setup_Monitor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Quality_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Service_Info_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Expert_API_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AF_L),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TMC),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TMC_L),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TMC_INFO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TMC_STN_INFO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_TestModeScreens),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DRM),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DRM_AST),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_WeatherBand),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DRM_SL),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_OPT_DRMPTY),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DRM_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DRM_TestModeScreen),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AM_TestMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_DAB_Monitor),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_StorePreset),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_UpdateDAB_SL),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_UpdateFM_SL),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_CannotStore),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_PTY31),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_TA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_WB),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER_GADGET_TUNER),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER_GADGET_TUNER_FREQUENCY),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER_GADGET_TUNER_MUTE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER_GADGET_TUNER_SEEKMENU),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_FM_INFO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_AM_INFO),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_HDDTM_TESTMODE),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_R_HDPARAMTUNING_TESTMODE),

// simple view controller from AppHmi_Tuner_SimpleViewController.h have not to be added here
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}
