/* ***************************************************************************************
* FILE:          CGIAppViewController_Tuner.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_Tuner.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_TUNER_H)
#define _CGIAPPVIEWCONTROLLER_TUNER_H

#include "CgiExtensions/ViewControllerBase.h"
//#include "AppHmi_Tuner_SimpleViewController.h"

// #define SIMPLE_CONTROLLER(tController)
// class tController : public ViewControllerBase
// {
// private:
// courier_messages:
// COURIER_MSG_MAP_BEGIN(0)
// ON_COURIER_MESSAGE(Courier::TouchMsg)
// COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
// COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
// COURIER_MSG_MAP_ENDS()
// public:
// tController() {}
// virtual ~tController() {}
// static const char* _name;\
// static Courier::ViewController* createInstance()
// {
// return COURIER_NEW(tController)();
// }

// //   virtual bool onCourierMessage(const Courier::TouchMsg& msg);
// };

#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
								{\
		private:\
				courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
		tController() {}\
		virtual ~tController() {}\
		static const char* _name;\
		static Courier::ViewController* createInstance()\
								{\
			return COURIER_NEW(tController)();\
								}\
								};

SIMPLE_CONTROLLER(CGIAppViewController_R_AM_S)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM1_S)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM2_S)
SIMPLE_CONTROLLER(CGIAppViewController_R_AM_AST_S)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_AST_S)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_AST)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_SL)
SIMPLE_CONTROLLER(CGIAppViewController_R_OPT_DABPTY)
SIMPLE_CONTROLLER(CGIAppViewController_R_SourceSelection_Radio)
SIMPLE_CONTROLLER(CGIAppViewController_R_SourceSelection_Radio_woNav)
SIMPLE_CONTROLLER(CGIAppViewController_R_OPT_FMAM)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_SL)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_MonitorTestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_AM_MonitorTestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor2)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor3)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Setup_Monitor)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Quality_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Service_Info_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Expert_API_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_AF_L)
SIMPLE_CONTROLLER(CGIAppViewController_R_TMC)
SIMPLE_CONTROLLER(CGIAppViewController_R_TMC_L)
SIMPLE_CONTROLLER(CGIAppViewController_R_TMC_INFO)
SIMPLE_CONTROLLER(CGIAppViewController_R_TMC_STN_INFO)
SIMPLE_CONTROLLER(CGIAppViewController_R_TestModeScreens)
SIMPLE_CONTROLLER(CGIAppViewController_R_DRM)
SIMPLE_CONTROLLER(CGIAppViewController_R_DRM_AST)
SIMPLE_CONTROLLER(CGIAppViewController_R_WeatherBand)
SIMPLE_CONTROLLER(CGIAppViewController_R_DRM_SL)
SIMPLE_CONTROLLER(CGIAppViewController_R_OPT_DRMPTY)
SIMPLE_CONTROLLER(CGIAppViewController_R_DRM_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_DRM_TestModeScreen)
SIMPLE_CONTROLLER(CGIAppViewController_R_AM_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Monitor)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_StorePreset)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_UpdateDAB_SL)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_UpdateFM_SL)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_CannotStore)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_AutoStore)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_PTY31)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_TA)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_WB)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER_GADGET_TUNER)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER_GADGET_TUNER_CABIN_ONLY)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER_GADGET_TUNER_FREQUENCY)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER_GADGET_TUNER_MUTE)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER_GADGET_TUNER_SEEKMENU)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_INFO)
SIMPLE_CONTROLLER(CGIAppViewController_R_AM_INFO)
SIMPLE_CONTROLLER(CGIAppViewController_R_HDDTM_TESTMODE)
SIMPLE_CONTROLLER(CGIAppViewController_R_HDPARAMTUNING_TESTMODE)


#endif // _CGIAPPVIEWCONTROLLER_TUNER_H
