/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "AppHmi_TunerStateMachine.h"
#include "CGIAppController.h"
#include "AppBase/ScreenBrokerClient/ScreenBrokerClient.h"

#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TUNER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TUNER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_TUNER_"
#define ETG_I_FILE_PREFIX                 CGIAppController::
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif
bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& msg)
{
   //ETG_TRACE_FATAL(("RenderingCompleteMsg : Surface id,  viewname %d, %s", msg.GetSurfaceId, msg.GetViewName));
   POST_MSG((COURIER_MESSAGE_NEW(ActiveRenderedView)(msg.GetSurfaceId(), msg.GetViewName())));
   CGIAppControllerProject::onCourierMessage(msg);
   return false;
}


bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg ACCEPT HKCode: %d %d", msg.GetHKCode(), msg.GetHKState()));
   POST_MSG((COURIER_MESSAGE_NEW(onHardKeyPress)(msg.GetHKCode(), msg.GetHKState())));
   CGIAppControllerProject::onCourierMessage(msg);
   return false;
}
