/**
 * @file        : TunerUtilsSingleton.h
 * @addtogroup  : AppHmi_Tuner
 * @brief       : Singleton interface
 * @copyright   : (c) 2017-2017 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 */

#ifndef TUNERUTILSSINGLETON_H_
#define TUNERUTILSSINGLETON_H_

/*
 * template for Singleton-pattern
 */
template <typename C>
class TunerUtilsSingleton
{
   public:
      static C* instance()
      {
         if (!_instance)
         {
            _instance = new C;
         }
         return _instance;
      }

      virtual
      ~TunerUtilsSingleton()
      {
         _instance = 0;
      }
   private:
      TunerUtilsSingleton(const TunerUtilsSingleton<C>&);
      TunerUtilsSingleton& operator=(const TunerUtilsSingleton<C>&);
      static C* _instance;
   protected:
      TunerUtilsSingleton() { }
};


template <typename C> C* TunerUtilsSingleton <C>::_instance = 0;


#endif /* TUNERUTILSSINGLETON_H_ */
