/**************************************************************************************
* @file         : TunerCommonHandler.h
* @author       : ECV2-Rohini SR
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to TunerCommonHandler  data.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TUNERCOMMONHANDLER_H_
#define TUNERCOMMONHANDLER_H_

#include "App/Core/Utility/TunerUtilsSingleton.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "App/Core/Utility/TunerUtility.h"
#include "AppHmi_TunerStateMachine.h"
#include "asf/core/Types.h"
//#include "Common/ListHandler/ListRegistry.h"
//#include "CgiExtensions/DataBindingItem.hpp" //wst4kor
#include <AppHmi_TunerMessages.h>

struct Category
{
   uint ptyTextId;
};


namespace App {
namespace Core {

/* class TunerCommonHandler
 * TunerCommonHandler are implemented by this class.
 */
class TunerCommonHandler
   : public TunerUtilsSingleton<TunerCommonHandler>
{
   public:
      virtual ~TunerCommonHandler();
      bool isHDFeatureEnabled();
      bool isNARVariant();
      //bool isScanFeatureEnabled();
      void updateAudioPopupData(std::string& scanText, std::string psName, std::string& freqService, uint8 Band , std::string HDprogramNumber);
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
      bool onCourierMessage(const FocusChangedUpdMsg& oMsg);
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const TunerFooterListIdReqMsg& oMsg);
#endif
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      void setSimulCastStatus(bool bSimulCast);
      bool getSimulCastStatus();
      bool getAmStatus();
      void setAmAvailability();
      bool getAmAvailability();
#endif

      /*   DataBindingItem<AudioPopupInfoDataBindingSource> _audioPopupInfo;*/

   private:
      TunerCommonHandler();
      friend class TunerUtilsSingleton<TunerCommonHandler>;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(FocusChangedUpdMsg)
      ON_COURIER_MESSAGE(TunerFooterListIdReqMsg)
#endif
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      void initaliseHDKDSValue();
      void getHDHWConfigurationData();
      void getFMHDConfigurationSwitchData();
      void getAMHDConfigurationSwitchData();

      bool _isHDMounted;
      bool _isFMHDSwitchEnabled;
      bool _isAMHDSwitchEnabled;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
      void updateFooterInfo(int32);
      uint8 isDTVModuleMounted();

      //Member Variables
      uint32 _totalListSize;
      uint32 _currentRequestedListID;
      int32 _focusedIndex;
      int32 _CurrentStartIndex;
      uint8 _u8DtvMountStatus;
#endif

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      bool _bIsSimulCastEnabled;
      bool _isAmAvailable;
#endif

      std::string getCategoryName(uint8 ptyIndex);  //Added for HD (to display category name)
};


} // namespace Core
} // namespace App


#endif /* TUNERCOMMONHANDLER_H_ */
