/**************************************************************************************
* @file         : Tuner_defines.h
* @author       : ECV - Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Header file contains necessary defines required to for Tuner updates.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef TunerDefines_H
#define TunerDefines_H

namespace App {
namespace Core {

#define M_FREQ_BUFFER_SIZE 7    // frequency array size
#define M_FREQ_STR_BUFFER_SIZE 11    // frequency with its unit(preset list element's field) array size
#define M_PSNAME_STR_BUFFER_SIZE 40// PSName with its unit(preset list element's field) array size 5*8
#define M_DEFAULT_INIT_VALUE -1
#define M_CONVERSION_KHZ_TO_MHZ 1000
#define M_DIVIDE_BY_HUNDRED 100
#define M_TP_TEXT "TP"
#define M_TMC_TEXT "TMC"
#define M_SERIAL_NUM_SIZE 2    // Preset list serial number array size
#define M_PRESET_TP_TMC_INFO_BIT_ONE 2    // Actual decimal value with bit 1 enabled
#define M_PRESET_TP_TMC_INFO_BIT_ZERO 1    // Actual decimal value with bit 0 enabled
#define M_NUM_OF_PRESET_STRING_FIELDS 2    // Number of FM preset list element string fields
#define M_NUM_OF_STATION_STRING_FIELDS 2    // Number of AM-MW preset list element string fields
#define M_NUM_OF_LIST_INTEGER_FIELDS 0    // Number of preset list element integer fields
#define M_LIST_START_INDEX 1    // PresetListData sent by tuner service starts with index 1
#define M_PRESET_FM_DEFAULT_FREQUENCY	96200	// Default Frequency set for FM Preset list
#define M_PRESET_AM_DEFAULT_FREQUENCY	540    // Default Frequency set for AM Preset list
#define M_NUM_OF_PRESET_LIST	2    // Number of Preset lists supported
#define M_NUM_OF_PRESET_ENTRIES    5    // Number of Preset entries in the list
#define M_NUM_OF_STATION_ENTRIES    6    // Number of Preset entries in the list
#define ZERO_RECEPTION_QUALITY "0 dBuV"	//	Value to be shown for '0' reception quality
#define ORIGINAL_FREQ "Original"	//	Text to be displayed for the original AF (identical PI)
#define NEIGHBOUR_FREQ "Neighbour"	//	Text to be displayed for the neighbouring PI for AF
#define DABTMFREQSEARCH 3
#define	PTY31_POPUP 5
#define	TA_POPUP 6

#define	AUD_FM 0
#define	AUD_AM 1
#define	AUD_DAB 2
#define	AUD_WX 9
//Defines for List indices

#define FREQ_INDEX 3
#define RECEPTION_QUAL_INDEX 3
#define FREQ_AF_INDEX 1
#define BIT_INFO_INDEX 2
#define STATION_NAME 1
#define SERIAL_NUM_INDEX 0

//	List widget workaround
#define INVALID_TPTMC_INFO 4	//	Used for the list workaround - bit 0 and 1 are 0 and hence, no info will be displayed
#define TUNER_ZERO_VALUE   0		//	Used for the list workaround - bit 0 and 1 are 0 and hence, no info will be displayed
#define TUNER_NULL_STRING  ""

#define DAB_SEEK_TYPE_SERVICE  0
#define DAB_SEEK_TYPE_ENSEMBLE 1
/*
* Up/down will be used from tuner defines below enSeekMode
*/

/*FM slider range */
#define FM_SLIDER_RANGE_HIGHER                 (207)
#define FM_STEP_FREQUENCY                      (100)   /*Interms of MHz (i.e: 0.1MHz)*/

/* Frequency Units */
#define C_FM_FREQ_UNIT "MHz"
#define C_AM_FREQ_UNIT "kHz"

#define AM_SOURCE     0
#define FM_SOURCE     1
#define DAB_SOURCE    2
#define SPI_SOURCE    3
#define OTHER_SOURCE  4

#define TUNER_SRC_PLAY			1
#define TUNER_SRC_SELECTION     2
#define TUNER_TOGGLE			3

#define ACTIVITYID_TUNER_DEFAULT		100
#define ACTIVITYID_TUNER_SRC_SELECT     101
#define ACTIVITYID_TUNER_FM				102
#define ACTIVITYID_TUNER_SXM			103			//tobe modified in fidil file
#define ACTIVITYID_TUNER_WX				115         //tobe modified in fidil file
#define ACTIVITYID_TUNER_AM				105
#define ACTIVITYID_TUNER_DAB			107
#define ACTIVITYID_TUNER_SETTINGS       111
#define ACTIVITYID_TUNER_HOMESCREEN		112
#define ACTIVITYID_MEDIA_HOMESCREEN		130
#define ACTIVITYID_MEDIA_SRC_SELECT		120

#define TUN_INC 0
#define TUN_DEC 1

#define SEEK_NEXT 0
#define SEEK_PREVIOUS 1

#define STATION_LIST_ITEMS 150
#define LISTID_FM 350
#define LISTID_DAB 351
#define LIST_ID_DTM_HD_MONITOR 352
#define LIST_ID_DTM_HD_PARAM_TUNING 353
#define LIST_ID_HD_INFO_LIST 354
#define HD_STATION_LOGO_TIMER    5000

#define SCENE_ENTRY 1
#define SCENE_EXIT  0


#define APPSTATUS_BACKGROUND 1
#define APPSTATUS_FOREGROUND 2

#define HI_CUT 1
#define SHARX 2
#define INCREMENT 1
#define DECREMENT 0

#define PTY_FILTER_NEWS_MASK     0x0001000A
#define PTY_FILTER_SPORTS_MASK   0x00000010
#define PTY_FILTER_CULTURE_MASK  0x201601A0
#define PTY_FILTER_MUSIC_MASK    0x1F00FC00
#define PTY_FILTER_SPECIAL_MASK  0x00E80244
#define PTY_FILTER_ENABLE_MASK   0x00000001
#define PTY_FILTER_EN_ALL_TO_MIDW 0x3FFFFFFF

enum IsVisible
{
   IS_VISIBLE_FALSE = 0,
   IS_VISIBLE_TRUE = 1
};


enum enArtistAlbumSwitch
{
   TUNER_HD_DATA_NONE = 0,
   TUNER_HD_DATA_ARTIST,
   TUNER_HD_DATA_ALBUM,
   TUNER_HD_DATA_ARTIST_ALBUM
};


enum AMLWActivation
{
   AMFMActivated = 0,
   Reserved,
   LWDeactivatedMWActivated,
   AMFMDeactivated
};


enum ListButtonType
{
   LIST_BUTTON_TYPE_BUTTON = 0,
   LIST_BUTTON_TYPE_TOGGLE = 1,
   LIST_BUTTON_TYPE_BUTTON_IMAGE = 2
};


enum enRadioSetting
{
   SOUNDSETTINGS = 0,
   RADIOTEXT = 1,
   TRAFFICANNOUNCEMENT = 2,
   RDS = 3,
   ALTERNATEFREQUENCY = 4,
   DABPTYFILTER = 5,
   DABDYNAMICCONTENT = 6,
   DAMFMLINKING = 7,
   DABDABLINKING = 8,
   WEATHERALERT = 9
};


enum enRadioSettingDABPTY
{
   DABPTY1 = 0,
   DABPTY2 = 1,
   DABPTY3 = 2,
   DABPTY4 = 3,
   DABPTY5 = 4,
   DABPTY6 = 5
};


/***********************************************************************
* 						ENUMS
***********************************************************************/
//description : Indicates start/stop/pause the scan of stations
enum enMode
{
   SCAN_OFF = 0,
   SCAN_ON = 1,
   SCAN_PAUSE = 2
};


typedef enum
{
   EN_SEEK = 1,
   EN_SCAN,
   EN_AST,
   EN_PRESET
} tenFunction;

//description : Indicates the different Tuner Types supported by Broadcast Serivce
enum enTunerType
{
   TUN_TYPE_AMFM = 0,
   TUN_TYPE_SRC_DAB = 1,
   TUN_TYPE_SRC_UNDEF = 2
};


//description : Indicates what type of scan is required
enum enScanType
{
   SCAN_AIR_FREQUENCY_UP = 3,
   SCAN_ACTIVE_PRESETLIST_UP = 2,
   SCAN_AIR_FREQUENCY_DOWN = 9,
   SCAN_ACTIVE_PRESETLIST_DOWN = 8,
   SCAN_PI_UP = 27,
   SCAN_PI_DOWN = 28
};


//description : Indicates whta type of the Station is available
enum enStationNameInfo
{
   STN_INFO_NON_RDS_STATION = 0,
   STN_INFO_STN_NAMEFIRST_RX_FREEZED = 1,
   STN_INFO_STN_NAMELAST_RX_SCROLLING = 2,
   STN_INFO_NAME_ASSIGNED_BY_CUSTOMER = 3
};


//description : Indicates the Announcement Information of the station
enum enStationAnnouncementInfo
{
   STN_INFO_TPSTATUS_UNKNOWN = 0,
   STN_INFO_TPSTATUS_NO_TP = 1,
   STN_INFO_TPSTATUS_SELF_TP = 2,
   STN_INFO_TPSTATUS_EON_TP = 3,
   STN_INFO_TPSTATUS_TP_STATION_TPSYNC_LOST = 4
};


//description : Indicates the Traffic Information of the station
enum enStationTrafficInfo
{
   STN_INFO_UNKNOWN = 0,
   STN_INFO_NO_TMC = 1,
   STN_INFO_TMC = 2
};


//description : Band levels in different tuner_types
enum enBand
{
   BAND_FM = 0,
   BAND_LW = 1,
   BAND_MW = 2,
   BAND_DAB_BAND_III = 3,
   BAND_DAB_BAND_L = 4
};


enum enBandCAN
{
   CAN_OFF = 0,
   CAN_FM = 1,
   CAN_MW = 7,
   CAN_WB = 11,
   CAN_XM = 12,
   CAN_DAB = 15,
   CAN_SNA = 63
};


enum enCANSrcIdSignal
{
   CAN_SOURCE_FM = 1,
   CAN_SOURCE_XM = 14,
   CAN_SOURCE_DAB = 16,
   CAN_SOURCE_AM = 17,
   CAN_SOURCE_WX = 18
};


enum enRegionID
{
   REGION_CABIN_A,
   REGION_CABIN_B,
   REGION_COCKPIT,
   REGION_INVALID
};


enum enTunerLongDataInfo
{
   TUNER_MAINLINE = 1,
   TUNER_FILENAME = 2,
   TUNER_TITLE = 3,
   TUNER_FOLDER = 4,
   TUNER_ARTIST = 5,
   TUNER_ALBUM = 6
};


//description : Program Types
enum enProgramType
{
   PTY_NO_PTY = 0x01,
   PTY_NEWS = 0x02,
   PTY_CURRENT_AFFAIRS = 0x04,
   PTY_INFORMATION = 0x08,
   PTY_SPORT = 0x10,
   PTY_EDUCATION = 0x20,
   PTY_DRAMA = 0x40,
   PTY_CULTURE = 0x80,
   PTY_SCIENCE = 0x100,
   PTY_VARIED = 0x200,
   PTY_POP_MUSIC = 0x400,
   PTY_ROCK_MUSIC = 0x800,
   PTY_EASY_LISTENING = 0x1000,
   PTY_LIGHT_CLASSICAL = 0x2000,
   PTY_SERIOUS_CLASSICAL = 0x4000,
   PTY_OTHER_MUSIC = 0x8000,
   PTY_WEATHER = 0x10000,
   PTY_FINANCE = 0x20000,
   PTY_FOR_CHILDREN = 0x40000,
   PTY_SOCIAL_AFFAIRS = 0x80000,
   PTY_RELIGION = 0x100000,
   PTY_PHONEIN = 0x200000,
   PTY_TRAVEL = 0x400000,
   PTY_LEISURE = 0x800000,
   PTY_JAZZ_MUSIC = 0x1000000,
   PTY_COUNTRY_MUSIC = 0x2000000,
   PTY_NATIONAL_MUSIC = 0x4000000,
   PTY_OLDIES_MUSIC = 0x8000000,
   PTY_FOLK_MUSIC = 0x10000000,
   PTY_DOCUMENTARY = 0x20000000,
   PTY_ALARM_TEST = 0x30000000,
   PTY_ALARM = 0x80000000
};


//description : Program Types
enum enStationType
{
   STN_TYPE_PRIMARY = 1,
   STN_TYPE_SECONDARY = 2,
   STN_TYPE_ENSEMBLE = 3
};


//description : Station Info Bits
enum enSortingType
{
   SORTING_PS_ASCENDING = 0,
   SORTING_PI_ASCENDING = 1,
   SORTING_FIELDSTRENGTH_ASCENDING = 2,
   SORTING_FREQ_ASCENDING = 3,
   SORTING_PS_DESCENDING = 4,
   SORTING_PI_DESCENDING = 5,
   SORTING_FIELDSTRENGTH_DESCENDING = 6,
   SORTING_FREQ_DESCENDING = 7
};


//description : Station Info Bits
enum enStationInfoBits
{
   //description :  -> Mono, 1-> Stereo
   STN_INFO_BIT0 = 0,
   //description :  Speech is signalled, 1-> Music is signalled
   STN_INFO_BIT1 = 1,
   //description :  RadioText Not Possible, 1-> RadioText is Possible
   STN_INFO_BIT2 = 2,
   //description :  Freq is Not AF, 1-> Freq is AF
   STN_INFO_BIT3 = 3,
   //description :  Un-used
   STN_INFO_BIT4 = 4
};


//description : Indicates the result of the Method from the Client
enum enResult
{
   RESULT_REQUESTACCEPTED = 0,
   RESULT_REQUESTNOTACCEPTED = 1
};


//description : Indicates the Error type if the method is not accepted
enum enError
{
   ERR_PARAMETER_NO_ERROR = 0,
   ERR_PARAMETER_OUTOFRANGE = 1,
   ERR_PARAMETER_MISSING = 2,
   ERR_PARAMETER_TEMP_NOT_AVAILABLE = 3,
   ERR_PARAMETER_TEMP_UNDEF = 255
};


//description : enum defination for Seek mode
enum enSeekMode
{
   SEEK_OFF = 0,
   SEEK_UPAUTO = 1,
   SEEK_UPSCANCURRENTPRESETLIST = 2,
   SEEK_UPSCANFREQUENCY = 3,
   SEEK_UPCONTINUOUSMANUALSTEP = 4,
   SEEK_UPPRESET = 5,
   SEEK_UPCURRENTSTATIONLIST = 6,
   SEEK_DOWNAUTO = 7,
   SEEK_DOWNSCANCURRENTPRESETLIST = 8,
   SEEK_DOWNSCANFREQUENCY = 9,
   SEEK_DOWNCONTINUOUSMANUALSTEP = 10,
   SEEK_DOWNPRESET = 11,
   SEEK_DOWNCURRENTSTATIONLIST = 12,
   SEEK_UPAUTORDSONLY = 13,
   SEEK_DOWNAUTORDSONLY = 14,
   SEEK_UPAUTORDSONLYPTYMASK = 15,
   SEEK_DOWNAUTORDSONLYPTYMASK = 16,
   SEEK_TP_UP_BOTH_EON_SELF_TP = 17,
   SEEK_TP_DOWN_BOTH_EON_SELF_TP = 18,
   SEEK_SELF_TP_UP = 19,
   SEEK_SELF_TP_DOWN = 20,
   SEEK_TPUP_BOTH_EON_SELF_TP_WITH_PTY_MASK = 21,
   SEEK_TPDOWN_BOTH_EON_SELFTP_WITH_PTYMASK = 22,
   SEEK_SELF_TP_UPWITHPTYMASK = 23,
   SEEK_SELF_TP_DOWNWITHPTYMASK = 24,
   SEEK_UP_CONTINUOUS_MANUAL_STEP_MUTED = 25,
   SEEK_DOWN_CONTINUOUS_MANUAL_STEP_MUTED = 26,
   SEEK_UP_SCAN_PI = 27,
   SEEK_DOWN_SCAN_PI = 28
};


//description: Indicates to deactivate or activate the Source
enum enOnOff
{
   DEACTIVATE = 0,
   ACTIVATE = 1
};


//description: Indicates the different sources supported by Broadcast Service
enum enSource
{
   SRC_TYPE_FM = 1,
   SRC_TYPE_AM = 2,
   SRC_TYPE_DAB = 4
};


enum enDABTMSeekMode
{
   SEEK_DAB_TM_SERVICE_NEXT,
   SEEK_DAB_TM_SERVICE_PREVIOUS,
   SEEK_DAB_TM_ENSEMBLE_NEXT,
   SEEK_DAB_TM_ENSEMBLE_PREVIOUS
};


//description: Indicates the different switches to switch ON or OFF
enum enFeatureSwitch
{
   //description: Bit 0 indicates AF
   FEATURESWITCH_AF = 1,
   //description: Bit 1 indicates REG
   FEATURESWITCH_REG = 2,
   //description: Bit 2 indicates TA
   FEATURESWITCH_TA = 4,
   //description: Bit 3 indicates DDASwitch
   FEATURESWITCH_DDA = 8,
   //description: Bit 4 indicates MONO-STEREO Switch. If TRUE then STEREO is ON, else MONO is ON
   FEATURESWITCH_MONOSTEREO = 16
};


//description : enum for Sorting Criteria used for Autostore
enum enSortingCriteria
{
   //description: Indicates sorting to be done based on Fieldstrength
   FIELDSTRENGTH = 0,
   //description: Indicates sorting to be done based on Quality
   QUALITY = 1,
   //description: Indicates sorting to be done based on Frequency
   FREQUENCY = 2,
   //description: Indicates sorting to be done based on PI
   PICHAIN_FREQUENCY = 3
};


//description : enum for BehaviourialSwitches used for Autostore
enum enBehaviourSwitches
{
   //description: Indicates the behaviour to Allow in Tunnel
   ALLOW_AUTOSTORE_IN_TUNNEL = 0,
   //description: Indicates the behaviour to Avoid in Tunnel
   AVOID_AUTOSTORE_IN_TUNNEL = 1
};


// description : enum for Autostore deactivate status
enum enAutoStoreDeactivate
{
   AUTOSTORE_DEACTIVATED = 0,
   AUTOSTORE_DEACTIVATE = 1
};


//description : Types of List required
enum enListType
{
   //Indicates the AMFM StationList contains all stations available in the air
   ALLAUDIOSTATIONLIST = 1,
   //Indicates the TMC StationList contains all TMC stations available in the air
   TMCSTATIONLIST = 2,
   //Indicates the AF List of the tuned station
   AFSTATIONLIST = 4,
   //Indicates the Preset List of the Current Band
   PRESETLIST = 8,
   //Indicates the Primary stationlist of DAB
   PRIMARYSTATIONLIST = 10,
   //Indicates the secondary stationlist of DAB
   SECONDARYSTATIONLIST = 20
};


//description : The Reception Parameters.
enum enReceptionParameter
{
   // Indicates Shrax and the Value to be (0-> Automatic) else (1->6)
   SHRAX = 1,
   // Indicates HiCut and the Value to be (0-> OFF) else (1->7)
   HICUT = 2
};


typedef enum
{
   EV_INVALID = 0,
   EV_SRCSEL_BACK /*=1*/,
   EV_ENGMODE_START /*=2*/,
   EV_ENGMODE_STOP /*=3*/,
   EV_ENGMODE_PARM  /*=4*/,
   EV_ENGMODE_AF_ONOFF  /*=5*/,
   EV_ENGMODE_BAND_SCAN  /*=6*/,
   EV_CLOSE_TA  /*=7*/,
   EV_ENGMENU_AMFM  /*=8*/,
   EV_SOUND_SETTING/*=9*/,
   EV_ENGMODE_MEASURE_MODE  /*=10*/,
   EV_TUNER_OPTION /*=11*/,
   EV_AUTOSTORE_SCAN/*=12*/,
   EV_ENGMODE_LINAUDIO/*=13*/,
   EV_LIST_LEARN/*=14*//*https://hi-cmts.apps.intranet.bosch.com:8443/browse/SUZUKI-22059*/,
   EV_HDDTM_START = 86,
   EV_HDDTM_STOP = 87,
   EV_CLOSE_WB = 88
} ev_TunerBLEventType;

typedef enum
{
   EV_INVALIDPARM = 0,
   EV_HIGHCUT_DEC /*=1*/,
   EV_HIGHCUT_INC /*=2*/,
   EV_SHARX_DEC/*=3*/,
   EV_SHARX_INC
} ev_TunerBLFirstArgType;


enum enTunerTestModeReq
{
   TUN_TM_REQ_ACTIVE_TUNER_0 = 0,
   TUN_TM_REQ_ACTIVE_TUNER_1 = 1,
   TUN_TM_REQ_ACTIVE_TUNER_2 = 2,
   TUN_TM_REQ_ACTIVE_TUNER_3 = 3,
   TUN_TM_REQ_AUTO_MODE = 4,
   TUN_TM_REQ_BAND_CHANGE_TUNER_0 = 5,
   TUN_TM_REQ_BAND_CHANGE_TUNER_1 = 6,
   TUN_TM_REQ_BAND_CHANGE_TUNER_2 = 7,
   TUN_TM_REQ_BAND_CHANGE_TUNER_3 = 8
};


enum enServiceLinkingValue
{
   SL_DAB = 1,
   SL_DAB_FM,
   SL_FM,
   SL_OFF
};


enum enTunerCmd
{
//	Nothing = 0,
   Auto_Seek_Up = 1,
   Auto_Seek_Down = 2,
   Manual_Step_Up = 3,
   Manual_Step_Down = 4,
   Manual_Seek_Up = 5,
   Manual_Seek_Down = 6,
   Preset_Up = 7,
   Preset_Down = 8,
   Error = 14,
   Dont_CareCmd = 15
};


enum enTACmd
{
   //	Nothing = 0,
   Switch_TA_On = 1,
   Switch_TA_Off = 2,
   Dont_CareTA = 3
};


enum enRDSCmd
{
   //	Nothing = 0,
   Switch_RDS_On = 1,
   Switch_RDS_Off = 2,
   Dont_CareRDS = 3
};


enum TunerTrackCommandTypes
{
   TrackCommand_Next = 3,
   TrackCommand_Previous = 4
};


//From here all defines are from AIVI. this will be deleted

#define BANK_DAB1          1
#define BANK_DAB2          2
#define BANK_FM1           1
#define BANK_FM2           2
#define PI_REG_CODE        0x00000F00
#define INVALID_BAND       0xffffff
#define BANK1              "1-6"
#define BANK2              "7-12"
#define PRESET_SIZE        12
#define MIXED_PRESET_SIZE  27
#define AM_PRESET_SIZE     6
#define PRESET_INDEX0      0
#define PRESET_INDEX1      1
#define PRESET_INDEX2      2
#define PRESET_INDEX3      3
#define PRESET_INDEX4      4
#define PRESET_INDEX5      5
#define PRESET_INDEX6      6
#define PRESET_INDEX7      7
#define PRESET_INDEX8      8
#define PRESET_INDEX9      9
#define PRESET_INDEX10     10
#define PRESET_INDEX11     11
#define ARRAY_SIZE         20
#define BEEPTYPE_ROGER     2
#define RELATIVE_PI_NSTEP  1
#define CONNECTED_TO_SINK  2
#define DISCONNECT         4
#define MET_PREV_STOP      3

#define TARGET_SEEK_UP     25
#define TARGET_SEEK_DOWN   26
#define FREQ1620        1620
#define FREQ1629        1629

enum ANNOTYPE
{
   ANNOTYPE_PTY = 0,
   ANNOTYPE_TA,
   ANNOTYPE_OTHER,
   ANNOTYPE_INVALID,
   ANNOTYPE_WB = 12
};


#define CONCEAL_MIN         0
#define CONCEAL_MAX         7
#define HDSTATION          0
#define NONHDSTATION       1
#define ADVISORIES       2   //wst4kor-->changed for hd
#define RADIOSWITCHTEXT    0  //ADDED FOR COMPILER,COVERITY MAY 11
#define DABADVISORIES      1
#define HDLOGO_INVISIBLE   0
#define HDLOGO_VISIBLE     1
#define PRESET_INVISIBLE   0
#define PRESET_VISIBLE     1
#define STATION_LIST_UPDATED  100
#define NAM_REGION         0x00
#define CAN_REGION         0x01
#define MEX_REGION         0x02
#define EUR_REGION         0x06
#define GCC_REGION         0x0A
#define LAC_REGION         0x0F
#define OTHER_REGION       0xFF
#define JPN_REGION         0x19
#define EMPTY_STRING       ""
#define HD_AUDIOPROGRAM_MPS   "1"
#define HD_AUDIOPROGRAM_SPS1	"2"
#define HD_AUDIOPROGRAM_SPS2	"3"
#define HD_AUDIOPROGRAM_SPS3	"4"
#define HD_AUDIOPROGRAM_SPS4	"5"
#define HD_AUDIOPROGRAM_SPS5	"6"
#define HD_AUDIOPROGRAM_SPS6	"7"
#define HD_AUDIOPROGRAM_SPS7	"8"
#define BANDSCAN           0
#define MOUNTED            1
#define UNMOUNTED          0
#define REFRESH            1
#define DISABLED           0
#define ENABLED            1
#define DTM_HD_AUDIO_PRGM_SIZE   8
#define TESTMODEBITACTIVE        0x01
#define PHYSICAL_TUNER_TWO       2
#define PHYSICAL_TUNER_THREE     3
#define MAIN_VOICE               0
#define SUB_VOICE                1
#define MIXED_VOICE              2
#define NODISPLAY                0
#define FIRSTLANGUAGE            1
#define SECONDLANGUAGE           2
#define AUTO                     0
#define SEG12                    1
#define SEG1                     2
#define OFF                      0
#define Relay                    1
#define AFFILIATED_RELAY         3
#define Layout10key              0
#define LayoutControl            1
#define HomeAreaInitialization   0
#define TravelAreaIntialization  1
#define AllSettingsInitialization   2
#define AllDataIntialization        3
#define INDEXCHECK              999
#define GADGET_NONHD              0
#define GADGET_HD_ACQUIRING       1
#define GADGET_HD_ACTIVE          2
#define TAPOPUP                   0
#define PTY31POPUP                1
#define OPEN                      0
#define CLOSE                     1
#define HDPROGACTIVE             -1.0f
#define HDPROGINACTIVE            0.0f
#define MAX_HD_AUDIO_PROGRAMS     8
#define HD_AUDIO_PROGRAM_BLANK    0
#define HD_AUDIO_PROGRAM_GREY     1
#define HD_AUDIO_PROGRAM_ACTIVE   2
#define HD_AUDIO_PROGRAM_UNAVAIABLE 99
#define HD_INFOSCREEN_GENRE_SIZE  125
#define HD_MAINSCREEN_GENRE_SIZE  76
#define PTYRDS_RBDS_SIZE          32 //Update the Size when PTY RDS/RBDS is extended
#define PI_STEPPING               0x00
#define PS_STEPPING               0x02
#define DIRECTCHANNEL              0
#define ZIPCODE                    1
#define ANTENNA_NORMAL             0
#define ANTENNA_OPEN               1
#define ANTENNA_SHORT              2
#define NORMAL_MODE                0
#define TESTMODE_LR                1
#define TESTMODE_L                 2
#define TESTMODE_R                 3
#define HD_INFOSCREEN_GENRE_SIZE  125 //For HD wst4kor

enum BANKINDEX
{
   BANK_FM_AM = 0,
   BANK_FM_AST,
   BANK_AM_AST
};


#define INC 1
#define DEC -1

#define LIST_ID_FM_LIST 1
#define LIST_ID_AM_LIST 2

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R

#define NO_OF_IANNOUNCEMENTS          9

enum SETTINGS_SWITCHES_AMFM
{
   RADIO_SETTINGS_NUM_AM = 0
   , RADIO_SETTINGS_NUM_TA_ELEMENT
   , RADIO_SETTINGS_RADIO_TEXT
   , RADIO_SETTINGS_REG
   , RADIO_SETTINGS_HDR
   , SETTINGS_INVALID
};


enum SETTINGS_SWITCHES_DR
{
   DR_SETTINGS_RADIO_TEXT = 0
   , DR_SETTINGS_SIMULCAST_ELEMENT
   , DR_SETTINGS_NUM_TA_ELEMENT
};


enum IANNO
{
   IANNOUNCEMENT_TRANSPORT = 0,
   IANNOUNCEMENT_WARNING,
   IANNOUNCEMENT_NEWS,
   IANNOUNCEMENT_WEATHER,
   IANNOUNCEMENT_EVENT,
   IANNOUNCEMENT_MUSICAL_EVENT,
   IANNOUNCEMENT_RADIO_INFO,
   IANNOUNCEMENT_SPORT,
   IANNOUNCEMENT_FINANCE,
   IANNOUNCEMENT_TA
};


#endif

#define MW_LIST_INSTANCE_OPEN                   0
#define MW_LIST_INSTANCE_CLOSE                  1
#define MW_LIST_INSTANCE_CLOSE_TO_UPDATE        2
#define PRESET_FULL                             99
#define FM_INDEX                                0
#define AM_INDEX                                1
#define DR_INDEX                                2
#define DAB_INDEX                               3

#define DTV_BANK_1                 0
#define DTV_BANK_2                 1

#define EPG_BTN_UP                  0
#define EPG_BTN_DOWN                1
#define EPG_BTN_LEFT                2
#define EPG_BTN_RIGHT               3

#define NO_DISPLAY                 0x00
#define SHOW_EPG_LIST_FULL_SEG     0x01
#define SHOW_EPG_INFO_FULL_SEG     0x02
#define SHOW_EPG_LIST_1_SEG        0x03
#define SHOW_EPG_INFO_1_SEG        0x04

#define CN_FRACTION 100;
#define PER_FRACTION 1000;

#define MAX_PHYCHANNEL_NUM  0x34
#define MIN_PHYCHANNEL_NUM     0x0D

#define HIDE    0
#define SHOW    1

#define TUNER_DTV_DTM              2
}


}

#endif
