/* ***************************************************************************************
* FILE:          TunerHall.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TunerHall.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef TunerHall_h
#define TunerHall_h

#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "AppBase/HallComponentBase.h"
#include "VehicleSrvClient/VehicleSrvClient.h"
#include "AppHmi_TunerMessages.h"
#include "AMFMInfo.h"
#include "RadioSetting.h"
#include "PresetListHandling.h"
#include "SrcChangeHandler.h"
#include "TunerDataBindingHandler.h"
#include "WeatherBand/WeatherBandMain.h"
#include "App/datapool/TunerDataPoolConfig.h"
#include "AnnoHandler.h"
#include "AMFMTestMode.h"
#include "Common/DefSetServiceBase/DefSetServiceBase.h"
#include "App/Core/DiagnosticsClient/DiagnosticsClientHandler.h"


//applicationSwitch changes
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "Common/DataModel/NavigationModeDBHandler.h"

#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "App/Core/DABInfo/DABStationList.h"
#include "App/Core/DABInfo/DabInfo.h"
//applicationSwitch changes
#include <Adapter/LanguageHandlerAdapter.h>


namespace App {
namespace Core {

class TunerHall
   : public HallComponentBase
   , public iDefSetServiceBase   // for factory reset
   , public ::languageHandler::LanguageHandlerAdapter
{
   public:
      TunerHall();
      virtual ~TunerHall();

      // TimerCallbackIF
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);
      static void TraceCmd_onTestTraceCommand(uint8 u8Value);
   protected:

      virtual bool onCourierMessage(const SwitchApplicationReq& oMsg);
      bool onCourierMessage(const NavigationCarModeInfo& msg);
      virtual uint8 readLanguageOnStartUp();

      // for factory reset
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&);
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&);
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(SwitchApplicationReq)
      ON_COURIER_MESSAGE(NavigationCarModeInfo)

      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_DiagnosticsClientHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_AmFmInfo)
      COURIER_MSG_DELEGATE_TO_OBJ(_ATStationInfo)
      COURIER_MSG_DELEGATE_TO_OBJ(_AMFMStationList)
      COURIER_MSG_DELEGATE_TO_OBJ(_WeatherBandMain)
      COURIER_MSG_DELEGATE_TO_OBJ(_presetList)
      COURIER_MSG_DELEGATE_TO_OBJ(_srcChg)
      COURIER_MSG_DELEGATE_TO_OBJ(_tunerDataBindingHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_AnnouncementHandler)
      COURIER_MSG_DELEGATE_TO_OBJ(_AMFMTestMode)
      COURIER_MSG_DELEGATE_TO_OBJ(_RadioSetting)
      COURIER_MSG_DELEGATE_TO_OBJ(_DABStationList)
      COURIER_MSG_DELEGATE_TO_OBJ(_DabInfo)
      COURIER_MSG_DELEGATE_TO_OBJ(_VehicleSrvClient)
      COURIER_MSG_DELEGATE_TO_CLASS(::languageHandler::LanguageHandlerAdapter)
      COURIER_MSG_DELEGATE_TO_CLASS(HallComponentBase)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      //added for coverity may 4
      TunerHall(const TunerHall&);
      TunerHall& operator =(const TunerHall&);
      /** Instance of AMFMInfo */
      AMFMInfo* _AmFmInfo;
      /** Instance of PresetListHandling */
      PresetListHandling* _presetList;

      /** Instance of SrcChangeHandler */
      SrcChangeHandler* _srcChg;

      /** Instance for the ATStationInfo */
      ATStationInfo* _ATStationInfo;

      /** Instance for the AMFMStationList */
      AMFMStationList* _AMFMStationList;

      DABStationList*  _DABStationList;

      WeatherBandMain* _WeatherBandMain;

      DabInfo* _DabInfo;

      TunerDataBindingHandler* _tunerDataBindingHandler;

      AnnoHandler* _AnnouncementHandler;

      AMFMTestMode* _AMFMTestMode;

      VehicleSrvClient* _VehicleSrvClient;

      DiagnosticsClientHandler* _DiagnosticsClientHandler;

      /** Instance for the DefSetServiceBase */
      DefSetServiceBase* _mdefSetServiceBase;

      RadioSetting* _RadioSetting;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch

      bool OnAppModeChange(hmibase::app::base::lcm::ShutdownType newState, hmibase::app::base::lcm::ShutdownType oldState);

      DECLARE_CLASS_LOGGER();

      DataBindingItem<CarModeVisibilityDataBindingSource> _carModeVisibilityStatus;
};


} // namespace Core
} // namespace App


#endif
