/* ***************************************************************************************
* FILE:          TunerGui.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TunerGui.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2017 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef TunerGui_h
#define TunerGui_h

#include "AppBase/GuiComponentBase.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"
#include "ProjectBaseMsgs.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


// datapool for persistent data
//#define DP_S_IMPORT_INTERFACE_FI
//#include "dp_hmi_01_if.h"

namespace App {
namespace Core {


class TunerGui : public GuiComponentBase
{
   public:
      TunerGui();
      virtual ~TunerGui();

      virtual void preRun();
      virtual void postRun();

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);

      virtual unsigned int getDefaultTraceClass();
      virtual void setupCgiInstance();

   private:

      void PersistentValuesRead();
      void PersistentValuesWrite();
      //HmiAppTuner::PersMemVars _mvar;

      hmibase::services::hmiappctrl::ProxyHandler _hmiAppCtrlProxyHandler;
};


} // namespace Core
} // namespace App


#endif
