/**************************************************************************************
* @file         : RadioSetting.h
* @author       : Bharanidharan S
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef RADIO_SETTING_H
#define RADIO_SETTING_H


#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_TunerDatabinding.h"
#include "AppHmi_TunerStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "App/datapool/TunerDataPoolConfig.h"
#include "SrcChangeHandler.h"


#include "MIDW_TUNER_FIProxy.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "AppBase/ServiceAvailableIF.h"

#include "MIDW_TUNERMASTER_FIProxy.h"
#include "Tuner_Defines.h"

#include "MIDW_EXT_DABTUNER_FIProxy.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {


const unsigned int g_cau32DabPtyFilterMask[] =
{
   PTY_FILTER_ENABLE_MASK,
   PTY_FILTER_NEWS_MASK,
   PTY_FILTER_CULTURE_MASK,
   PTY_FILTER_SPORTS_MASK,
   PTY_FILTER_MUSIC_MASK,
   PTY_FILTER_SPECIAL_MASK
};


typedef enum
{
   EN_PTY_FILTER_ENABLED = 0,
   EN_PTY_TYPE_NEWS,
   EN_PTY_TYPE_CULTURE,
   EN_PTY_TYPE_SPORTS,
   EN_PTY_TYPE_MUSIC,
   EN_PTY_TYPE_SPECIAL
} tenPtyFilter;

template <typename T>
struct ListItemBase
{
   ListItemBase(Candera::String text, IsVisible isVisible, ListButtonType listButtonType, int order)
      : _text(text)
      , _isVisible(isVisible)
      , _listButtonType(listButtonType)
      , _order(order)
   {}

   Candera::String _text;
   IsVisible _isVisible;
   ListButtonType _listButtonType;
   int _order;
};


class RadioSetting: public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_AFCallbackIF,
//public ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATURECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSCallbackIF
{
   public:

      virtual ~RadioSetting();

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onFID_TUN_G_SET_AFError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_AFError >& /*error*/);
      virtual void onFID_TUN_G_SET_AFStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_AFStatus >& status);

      virtual void onFID_TUN_S_SET_FEATUREError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATUREError >& /*error*/);
      virtual void onFID_TUN_S_SET_FEATUREResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATUREResult >& /*result*/);

      virtual void onFID_TUN_G_SET_RDSREGError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGError >& /*error*/);
      virtual void onFID_TUN_G_SET_RDSREGStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGStatus >& status);

      virtual void onFID_TUN_S_SETUP_DDADDSError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSError >& /*error*/);
      virtual void onFID_TUN_S_SETUP_DDADDSResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSResult >& /*result*/);

      // virtual void onFID_TUN_G_SET_MEASUREMODEError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODEError >& /*error*/);
      // virtual void onFID_TUN_G_SET_MEASUREMODEStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODEStatus >& status);

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      virtual bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      //Singleton class implementation
      static RadioSetting* m_poRadioSetting;
      static RadioSetting* poGetInstance()
      {
         if (NULL == m_poRadioSetting)
         {
            m_poRadioSetting = new RadioSetting();
         }
         return m_poRadioSetting;
      }

      void setREGstatus(bool regStatus);
      bool isREGActive();
      void onToggleREG();
      bool getTAStatus();
      void onSelectAFFollowing();
      void vUpdateTAButtonInSettings(bool TA);
      void vUpdateWBButtonInSettings(bool WB);
      void InitDABPTYDisableForFirstTime(); //this method will be removed once DAB PTY is completed
      void vUpdate_Settings_Options(bool status);
      void setHMI_REGstatus();
      void onSelectHMI_AFFollowing();
      void vSetDpDABPtyFilter(unsigned int u32Mask);

   private:

      RadioSetting(); //Singleton design :Making constructor as private

      unsigned int m_ui32ListId;
      bool m_baCheckBoxStatus[10]; //added for coverity may 4
      unsigned int m_ui32DABPTYCheckBoxStatus[6];
      bool m_bRadioSettingListUpdateRequired;
      bool m_bDABPTYLlistUpdateRequired;
      bool dabptyforfirsttime;

      //Databinding used to enable disable DAB PTY options
      unsigned int m_u32DabPtyMask;
      unsigned int m_u32DabPtyFilterToClient;
      DataBindingItem<CheckBoxListItemDataBindingSource> odabptyCheckBoxData;
      DataBindingItem<DABOptionsDataBindingSource> oDabOptionsData;

      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;
      ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > _dabFiProxy;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getListDataProviderMainList(::Courier::UInt32);

      void HandleRadiosettingButtonListItemUpdMsg(unsigned int rowIdx);
      void HandleDABPTYButtonListItemUpdMsg(unsigned int rowIdx);
      void HandleDABPTYOptionsEnableDisable(bool optenabledis);

      void vSetDABPtyFilter(unsigned int u32Option);
      void vSendPTYFilter(void);

      void updateSettingsList();  //added new method to check for listregistry and update

      typedef ListItemBase<enRadioSetting> RadioSettingsListItem;
      std::vector<RadioSettingsListItem> _radioSettingsList;

      typedef ListItemBase<enRadioSetting> dabRadioSettingsListItem;
      std::vector<dabRadioSettingsListItem> _dabradioSettingsList;

      void ReadRadioSettingKDS();
      void onRegisterRDSREGFI(const ::boost::shared_ptr< asf::core::Proxy >& proxy);

      /** Boolean Member Variable is true if RDS is active */
      bool _isRegActive;

      /** Member Variable to hold audible tuner mode */
      //::midw_tuner_fi_types::T_e8_DDADDS_Mode _mode; removed for coverity may 4

      /** Member Variable to hold TA status */
      //removed for coverity
      //Candera::String _taStatus;
      /** Member Variable to hold measurement mode value */
      std::string _measureMode;
      /** Member Variable to hold measure Index value */
      bool _measureIndex;
      bool _afIndex;
      bool m_bOptRadioText;
      bool m_bOptDABDynamicText;
      tBool m_bOptDabFmFollowing;
      bool m_u8KDSConfigAF_Enable;
      bool m_u8KDSConfigREG_Enable;
      bool m_u8KDSConfigTA_Enable;
      bool _isCabinOnly;
};


}
}


#endif
