/***************************************************************************
* Copyright(c) 2017-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/

#ifndef PresetListHandling_h
#define PresetListHandling_h
//Add include files here
#include "PresetListHandlingIF.h"
#include "TunerDataBindingHandler.h"
#include "midw_tuner_fi_types.h"
#include "midw_tunermaster_fi_types.h"
#include "MIDW_TUNER_FIProxy.h"
#include "AMFMInfoIF.h"
#include "../DABInfo/DabInfo.h"

/* Defines for including the needed interface header files */
#define MAX_BANK_PRESET_LIST   (6+1)

using namespace ::asf::core;
using namespace ::MIDW_TUNERMASTER_FI;
using namespace ::midw_tunermaster_fi_types;
//using namespace ::tunermaster_main_fi;


struct PresetList_Elem
{
   std::string _preset_Freq;
   std::string _hdAudioPrg;
   std::string _preset_PSName;
   std::string _band;
   bool _ishdStatus;

   PresetList_Elem() : _preset_Freq("")
      , _hdAudioPrg("")
      , _preset_PSName("")
      , _band("")
      , _ishdStatus(false)
   {
   }
};


class StartupSync;
namespace App {
namespace Core {

using namespace ::midw_tuner_fi_types;
using namespace ::midw_tunermaster_fi_types;

class PresetListHandling :
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_PRESET_HANDLINGCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_AUTOSTORECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_ACTIVE_PRESETLISTCallbackIF,
   public MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_BAND_INFOCallbackIF,
   public MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_BAND_CHANGECallbackIF,
   public PresetListHandlingIF
{
   private:
      PresetListHandling();
      static PresetListHandling* m_PresetListHandling;

   public:

      static PresetListHandling* poGetInstance()
      {
         if (NULL == m_PresetListHandling)
         {
            m_PresetListHandling = new PresetListHandling();
         }
         return m_PresetListHandling;
      }

      virtual ~PresetListHandling();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation  void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& /*stateChange*/);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      // class FID_TUNMSTR_S_PRESET_HANDLINGCallbackIF implementation
      virtual void onFID_TUNMSTR_G_PRESET_LISTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTError >& /*error*/);
      virtual void onFID_TUNMSTR_G_PRESET_LISTStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTStatus >& status);

      virtual void onFID_TUNMSTR_S_PRESET_HANDLINGError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_PRESET_HANDLINGError >& /*error*/);
      virtual void onFID_TUNMSTR_S_PRESET_HANDLINGResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_PRESET_HANDLINGResult >& result);

      // class FID_TUNMSTR_S_AUTOSTORECallbackIF implementation
      virtual void onFID_TUNMSTR_G_GET_AUTOSTORE_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus >& status);
      //void vAutostore_Start(tBool bIsAutoStoreStart, midw_tuner_fi_types::midw_fi_tcl_e8_List::tenType enPresetType);

      virtual void onFID_TUNMSTR_S_AUTOSTOREError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& proxy, const ::boost::shared_ptr< FID_TUNMSTR_S_AUTOSTOREError >& error);
      virtual void onFID_TUNMSTR_S_AUTOSTOREResult(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& proxy, const ::boost::shared_ptr< FID_TUNMSTR_S_AUTOSTOREResult >& /*result*/);

      virtual void onFID_TUN_S_SET_ACTIVE_PRESETLISTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& proxy, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_ACTIVE_PRESETLISTError >& /*error*/);
      virtual void onFID_TUN_S_SET_ACTIVE_PRESETLISTResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& proxy, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_ACTIVE_PRESETLISTResult >& /*result*/);

      //onFID_TUNMSTR_S_BAND_CHANGE CallbackIF Implementation
      virtual void onFID_TUNMSTR_S_BAND_CHANGEError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_BAND_CHANGEError >& /*error*/);
      virtual	void onFID_TUNMSTR_S_BAND_CHANGEResult(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_S_BAND_CHANGEResult >& /*result*/);
      virtual void onFID_TUNMSTR_G_BAND_INFOError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_BAND_INFOError >& /*error*/);
      virtual	void onFID_TUNMSTR_G_BAND_INFOStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< FID_TUNMSTR_G_BAND_INFOStatus >& status);

      //virtual void vPreset_Handling_Start(tU8  u8PresetNr, midw_tuner_fi_types::midw_fi_tcl_e8_List::tenType enPresetType, midw_fi_tcl_e8_Band::tenType u8Band, midw_fi_tcl_e8_Preset_Action::tenType enPresetAction);
      virtual void vPreset_Handling_Start(tU8  u8PresetNr, T_e8_List enPresetType, T_e8_Band u8Band, T_e8_Preset_Action enPresetAction);
      void fillDabPresetList(const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_PRESET_LISTStatus >& status);
      //void vUpdatePresetFocused(tU16 sPresetNumber);
      virtual void setActiveSeekStatus(bool seekStatus);
      virtual void vAutostore();
      tVoid vAutostore_Start(tBool  bIsAutoStoreStart, T_e8_List enPresetType);
      tVoid vAutostore_Stop();
      virtual void vSelectPreset(tU16 u8PresetNumber);
      virtual void vStorePreset(tU16 u8PresetNumber);
      void vSelectPresetList(int iViewId);
      uint8 getbandInfo();
      bool IsBandFM();

      /** Member Variable to hold FM HD Demod switch status */
      bool _FMHDActive;
      bool _AMHDActive;
      void setFMHDActiveStatus(bool& isActive);
      void setAMHDActiveStatus(bool& isActive);
      //bool IsBandAM();
      bool IsBandDAB();
      uint8 _bandinfo;
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      /** Vector to store FM Presets */
      ::std::vector<PresetList_Elem> _fmPresetList;

      /** Vector to store AM Presets */
      ::std::vector<PresetList_Elem> _amPresetList;

      void fillPresetItemAt(const ::midw_tunermaster_fi_types::T_PresetList& presetItem, PresetList_Elem& destination);
      void vUpdateFreqConversion(uint32 freq, std::string& strFreq, tU8 band);
   private:
      /** Instance of MIDW_TUNERMASTER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      TunerDataBindingHandler* _TunerDataBindingHandler;

      T_e8_List  m_enCurrentTunBankID;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App
#endif
