/**************************************************************************************
* @file         : DiagnosticsClientHandler.h
* @author       : ECH2 Swarna Trivedi
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (C) 2022 Robert Bosch GmbH
*                 (C) 2022 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DIAGNOSTICS_CLIENT_HANDLER_H
#define DIAGNOSTICS_CLIENT_HANDLER_H

#include "Midw_Diagnostics_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"

using namespace Midw_Diagnostics_FI;
static const ::std::string DIAGNOSTICS_FI_PORT = "diagnosticsFiPort";

namespace App {
namespace Core {

class DiagnosticsClientHandler:
   public hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public Midw_Diagnostics_FI::SetRunTimeSourceDataCallbackIF
{
   public:

      static DiagnosticsClientHandler* poGetInstance()
      {
         if (NULL == m_poDiagnosticsClientHandler)
         {
            m_poDiagnosticsClientHandler = new DiagnosticsClientHandler(DIAGNOSTICS_FI_PORT);
         }
         return m_poDiagnosticsClientHandler;
      }

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onSetRunTimeSourceDataError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataError >& error);
      void onSetRunTimeSourceDataResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetRunTimeSourceDataResult >& result);

      void updateFMRuntimeInfo(uint32_t seconds);
      void updateAMRuntimeInfo(uint32_t seconds);
      void updateDABRuntimeInfo(uint32_t seconds);
      void updateWXRuntimeInfo(uint32_t seconds);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_END()

   private:
      DiagnosticsClientHandler();
      DiagnosticsClientHandler(const std::string& diagnosticsFiPort);
      static DiagnosticsClientHandler* m_poDiagnosticsClientHandler;

      ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > _diagnosticProxy;
};


}
}


#endif // DIAGNOSTICS_CLIENT_HANDLER_H
