/**************************************************************************************
* @file         : DabInfoCourierMsgHandler.h
* @author       : ECV2-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Class contains utility functions to handle courier messages required for DAB data.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_DabInfoCourierMsgHandler_H)
#define _DabInfoCourierMsgHandler_H

//#include "Common/ListHandler/ListRegistry.h"
#include <AppHmi_TunerMessages.h>
#include "asf/core/Types.h"
#include "TunerStdSpecTypes.h"
#include "AppHmi_TunerMessages.h"
#define DABTESTMODEREG                         22
#define ACTIVATE_DAB_TESTMODE                  1
#define DEACTIVATE_DAB_TESTMODE                0
#define SERVICELINKINGMAX                      3
#define CLEVELMAX                              7
#define SERVICEANDCLVLMIN                      0

namespace App {
namespace Core {

class DabInfo;
class DABStationList;

/* class DabInfoCourierMsgHandler
* This class handles the courier messages received as "subscriber = Model".
*/

class DabInfoCourierMsgHandler
{
   public:

      DabInfoCourierMsgHandler(DabInfo* dabInfo, DABStationList* dabStationList);
      virtual ~DabInfoCourierMsgHandler();

      bool onCourierMessage(const Courier::StartupMsg&);
      bool onCourierMessage(const DABServiceReqMsg& corfoMsg);
      bool onCourierMessage(const DABServiceLinkReqMsg& corfoMsg);
      bool onCourierMessage(const DABCLevelReqMsg& corfoMsg);
      bool onCourierMessage(const DABTMSeekReqMsg& corfoMsg);

      //COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(DABServiceReqMsg)
      ON_COURIER_MESSAGE(DABServiceLinkReqMsg)
      ON_COURIER_MESSAGE(DABCLevelReqMsg)
      ON_COURIER_MESSAGE(DABTMSeekReqMsg)
      COURIER_MSG_MAP_END()

      /** Instance of DabInfo */
      DabInfo* _dabInfo;

      /** Instance of TunerList */
      DABStationList* _dabList;
   private:
      tU8 m_u8ServiceLinkingValue;
};


} // namespace Core
} // namespace App

#endif // _DabInfoCourierMsgHandler_H
