/**************************************************************************************
* @file         : DabInfo.h
* @author       : ECV2-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle DAB data.
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DabInfo_H
#define DabInfo_H

#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_TunerStateMachine.h"
#include "DABStationList.h"
#include "DabInfoCourierMsgHandler.h"
#include "TunerDataBindingHandler.h"
#include "App/Core/LanguageDefines.h"
#include "TunerStdSpecTypes.h"


namespace midw_ext_dabtuner_fi_types {
class T_DAB_PresetListElement;
}


class StartupSync;
using namespace ::MIDW_EXT_DABTUNER_FI;
using namespace ::midw_ext_dabtuner_fi_types;

namespace App {
namespace Core {

class TunerDataBindingHandler;
//class DabDataBindingHandler;

class DabInfo :
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_PRESET_LISTCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMCallbackIF
{
   private:
      DabInfo();
      //added for coverity may 4
      DabInfo(const DabInfo&);
      DabInfo& operator =(const DabInfo&);
      static DabInfo* m_poDabInfo;
   public:

      static DabInfo* poGetInstance()
      {
         if (NULL == m_poDabInfo)
         {
            m_poDabInfo = new DabInfo();
         }
         return m_poDabInfo;
      }

      tenDabStatus enDabStatus;
      std::string m_servicename;
      std::string getstationvalue();
      virtual ~DabInfo();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      void onAvailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      //Properties
      virtual void onFID_DAB_G_ACTIVE_SERVICE_INFOError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOError >& /*error*/);
      virtual void onFID_DAB_G_ACTIVE_SERVICE_INFOStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOStatus >& /*status*/);

      virtual void onFID_DAB_G_CHANNEL_INFOError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOError >& /*error*/);
      virtual void onFID_DAB_G_CHANNEL_INFOStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status);

      virtual void onFID_DAB_G_ACTIVE_ENSEMBLE_INFOError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOError >& /*error*/);
      virtual void onFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus >& status);

      virtual void onFID_DAB_G_PRESET_LISTError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_PRESET_LISTError >& /*error*/);
      virtual void onFID_DAB_G_PRESET_LISTStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_PRESET_LISTStatus >& status);

      virtual void onFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMError >& /*error*/);
      virtual void onFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_ACTIVATE_PRESET_LIST_ELEMResult >& /*result*/);

      void setDLSelements(const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status);
      std::string getServiceLabel(bool isServiceFollowActive, std::string servLabel, std::string ShortserviceLabel);
      void clearDABPresetList();
      void updateDabPresetData();
      void onTunerTrackCommandReq(uint32 u8tunertrackCmd);

      //std::string getCategory(const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status);
      //void presetUpDown(uint8 dabDirection);
      //void ensembleSeek(uint8 dabDirection);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_OBJ(_dabInfoCourierMsg)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      /** Instance of MIDW_EXT_DABTUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > _dabFiProxy;

      /** Current active bank id **/
      uint8 _bankId;

      /**Instance of current active dab preset list id **/
      uint8 _presetID;
      uint8 _dabPresetID;

      ::std::vector<std::string> _aDAB_Presets;
      /** TO get The ptyState on or off **/
      bool _isPTYSignalOff;

      TunerDataBindingHandler* _DabInfoDataBinder;

      /** Instance of DABStationList */
      //DABStationList* _dabList;  //commented FOR COVERITY MAY 4

      /** Instance of DabInfoCourierMsgHandler */
      DabInfoCourierMsgHandler* _dabInfoCourierMsg;

      /** Instance for the TTFIs Trace command. */
      static DabInfo* _dabInfoInst;

      /** Vector to store DAB preset elements **/
      ::std::vector< midw_ext_dabtuner_fi_types::T_DAB_PresetListElement > _dabPresetList;

      void updateChannelData(std::string serviceLabel, std::string shortServLabel, uint8 presetNum)const;

      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App

#endif
