/**************************************************************************************
* @file         : DABStationList.h
* @author       : ECV2-Avinash B Guledagudda
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle DAB List data.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DABStationList_h
#define DABStationList_h


#include "MIDW_TUNERMASTER_FIProxy.h"
#include "MIDW_EXT_DABTUNER_FIProxy.h"
#include "AppHmi_TunerStateMachine.h"
#include "AppHmi_TunerMessages.h"
#include "AppBase/ServiceAvailableIF.h"
//#include "App/Core/Tuner_Defines.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "Common/DataModel/ListRegistry.h"
#include "asf/core/Timer.h"
//#include "org/bosch/cm/DataServicesProxy.h"
#include "App/Core/PresetListHandler/PresetListHandlingIF.h"
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "Tuner_Defines.h"

#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


struct DabServiceList_Elem
{
      std::string _psName;
      bool _serviceSelected;
      uint32 _isPreset;
      uint8 _isEPGsupported;
      uint32 _servID;
      uint16 _secondaryServiceId;
      uint32 _isPTYFilter;
      FeatStd::String _categoryname;
      std::string _catName;
      //uint8 _isPrestListElementId;
      std::string _isPrestListElementId;
   public:
      DabServiceList_Elem(std::string PSName, bool ServiceSelected, uint32 preset, uint8 isEPGsupported, uint32 servID, uint16 scid, uint32 PTYFilter, FeatStd::String Category, std::string DABCat, std::string Presetelementid)
         : _psName(PSName)
         , _serviceSelected(ServiceSelected)
         , _isPreset(preset)
         , _isEPGsupported(isEPGsupported)
         , _servID(servID)
         , _secondaryServiceId(scid)
         , _isPTYFilter(PTYFilter)
         , _categoryname(Category)
         , _catName(DABCat)
         , _isPrestListElementId(Presetelementid)
      {
      }
};


namespace App {
namespace Core {
class AnnoHandlerIF;
class DabInfoDataBindingHandler;
/* class DABStationList
 * The properties and methods of MIDW_TUNERMASTER_FIProxy required for list handling are implemented by this class.
 */
class DABStationList
   : public ListImplementation
   , public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_SRV_LISTCallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SRV_SELECTCallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_SERVICECallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_ENSEMBLECallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSCallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_TEST_OPERATIONCallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_SETUP_STATUSCallbackIF
   , public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPCallbackIF
   , public ::asf::core::TimerCallbackIF
{
   public:
      // DABStationList();
      virtual ~DABStationList();
      static DABStationList* poGetInstance()
      {
         if (NULL == m_poDABStationList)
         {
            m_poDABStationList = new DABStationList();
         }
         return m_poDABStationList;
      }

      ::std::vector <std::string> stationnamearray;
      virtual bool onCourierMessage(const DABStationListReqMsg& oMsg);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onFID_DAB_G_SETUP_STATUSError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_SETUP_STATUSError >& /*error*/);
      virtual void onFID_DAB_G_SETUP_STATUSStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_SETUP_STATUSStatus >& /*status*/);

      virtual void onFID_DAB_G_TUNER_STATUSError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSError >& /*error*/);
      virtual void onFID_DAB_G_TUNER_STATUSStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSStatus >& /*status*/);

      virtual void onFID_DAB_S_SET_SRV_LISTError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_SRV_LISTError >& /*error*/);
      virtual void onFID_DAB_S_SET_SRV_LISTResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_SRV_LISTResult >& /*result*/);

      virtual void onFID_DAB_S_SRV_SELECTError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SRV_SELECTError >& /*error*/);
      virtual void onFID_DAB_S_SRV_SELECTResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SRV_SELECTResult >& /*result*/);

      virtual void onFID_DAB_S_SETUPError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPError >& /*error*/);
      virtual void onFID_DAB_S_SETUPResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPResult >& result);

      virtual void onFID_DAB_S_TEST_OPERATIONError(const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI:: MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI:: FID_DAB_S_TEST_OPERATIONError >& /*error*/);
      virtual void onFID_DAB_S_TEST_OPERATIONResult(const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI:: MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI:: FID_DAB_S_TEST_OPERATIONResult >& /*result*/);

      virtual void onFID_DAB_S_SEEK_SERVICEError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_SERVICEError >& /*error*/);
      virtual void onFID_DAB_S_SEEK_SERVICEResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_SERVICEResult >& result);

      virtual void onFID_DAB_S_SEEK_ENSEMBLEResult(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_ENSEMBLEResult >& result);
      virtual void onFID_DAB_S_SEEK_ENSEMBLEError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr<  ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SEEK_ENSEMBLEError >& /*error*/);

      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      void onDabServiceSelect(uint8 rowID);
      void onSeekService(uint8 dabDirection);
      void dabListoperation(uint8 status);

      void onSeekEnsemble(uint32 dabDirection);
      void onSeekReqService(uint8 SeekDirection);

      void onDabserviceLinking();
      void clearDabList();
      void updateList(const uint32& listID);
      void dabServiceListHighlight(uint16 serviceElementID);

      void setListStartIndex();
      void showPopUpData();
      tSharedPtrDataProvider getTunerDABServiceList();
      void hidePopUpData();
      void setTunerAppStatus(uint8& appStatus);
      void setEntMuteStatus(bool& entMuteStatus);
      tVoid vRequestServiceFollowing(tBool bFmFollowingStatus, tBool bDabLinkingStatus);

      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      virtual void onExpired(asf::core::Timer& timer, boost::shared_ptr<asf::core::TimerPayload> data);

      void setDABPTYFilterToMW(uint32 filter);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ListDateProviderReqMsg)

      ON_COURIER_MESSAGE(DABStationListReqMsg)
      //COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

   private:

      DABStationList();

      /** Instance of MIDW_EXT_DABTUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > _dabFiProxy;

      static DABStationList* m_poDABStationList;

      uint32 m_u32DABPTYFilter;

      bool _dab_FmStatus;

      /** Member Variable to hold List item index */
      uint32 _selectedElemID;

      /** Instance for the timer */
      // asf::core::Timer _seekPopUpTimer;

      /** Instance for the timer for Unmute Audio popup */
      // asf::core::Timer _seekAudioPopUpTimer;

      /** status to chk whether tuner is in background or foreground **/
      uint8 _tunerStatus;

      /** status to chk if the audio popup is shown or hidden **/
      bool _audioPopUpStatus;

      /** status to chk whether the seek operation is active or not **/
      bool _seekActiveStatus;

      bool _dabListStatus;

      /** status to check if Dab linking is toggled or not **/
      bool _dabLinkingToggled;

      bool bReception;

      /** member variable to hold the current ensemble seek direction, 1 for UP, 2 for DOWN **/
      uint32 _ensSeekDirection;

      /* The MW maintains a copy of list sent to us
       * The list has to be closed everytime we exit the list screen
       * The list has to be closed before updating the list also
       * _MWlistStatus tells the current state of the mw list*/

      uint8 _MWlistStatus;

      ::std::vector<DabServiceList_Elem> _dabServiceList;
      // PresetListHandlingIF* _mPresetListHandlingIF; //removed for coverity may 4
};


} // namespace Core
} // namespace App


#endif
