/**************************************************************************************
* @file         : AnnoHandlerHandling.h
* @author       : ECV2-Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle Traffic Announcement data.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AnnoHandler_H
#define AnnoHandler_H

#include "MIDW_TUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FIProxy.h"
#include "MIDW_EXT_DABTUNER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/DataModel/ListRegistry.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "RadioSetting.h"
#include "TunerDataBindingHandler.h"
//#include "AnnoCourierMsgHandler.h"
#include "App/Core/Tuner_Defines.h"


class StartupSync;

namespace App {
namespace Core {
//Forward Declarations
//class AnnoDataBindingHandler;
//class AnnoType;

/* class AnnoHandler
 * The properties and methods of MIDW_TUNER_FI, MIDW_TUNERMASTER_FI and MIDW_EXT_DABTUNER_FI required to handle TA are implemented by this class
 */
class AnnoHandler : public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSCallbackIF
{
      class AnnoType
      {
         public:
            bool status;
            const char* popIdentifier;
            uint8 annoType;

            AnnoType(bool s, const char* popupId, uint8 type)
               : status(s),
                 popIdentifier(popupId),
                 annoType(type)
            {
            }
      };

   private:
      AnnoHandler();
      static AnnoHandler* m_poAnnouncementHandler;

   public:
      static AnnoHandler* poGetInstance()
      {
         if (NULL == m_poAnnouncementHandler)
         {
            m_poAnnouncementHandler = new AnnoHandler();
         }

         return m_poAnnouncementHandler;
      }
      void setPSName(std::string& psName, uint32& currentFreq);
      std::string _psName;
      uint32 _CurrentFreq;

      uint8 m_popupstatus;
      virtual ~AnnoHandler();
      uint8 GetPopupStatus();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus >& status);

      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus >& status);

      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError >& /*error*/);
      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult >& /*result*/);

      virtual void onFID_TUNMSTR_S_STOP_ANNOUNCEMENTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTError >& /*error*/);
      virtual void onFID_TUNMSTR_S_STOP_ANNOUNCEMENTResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult >& /*result*/);

      virtual void onFID_TUN_G_ANNOUNCEMENT_INFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOError >& /*error*/);
      virtual void onFID_TUN_G_ANNOUNCEMENT_INFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOStatus >& status);

      virtual void onFID_DAB_G_ANNO_STATUSError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSError >& /*error*/);
      virtual void onFID_DAB_G_ANNO_STATUSStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSStatus >& status);

      //Methods
      virtual void onToggleTA();
      virtual void setTAflag(bool tastatus);
      virtual void onToggleWB();
      virtual void setWBflag(bool wbstatus);
      virtual bool isWbActive();
      virtual bool isTaActive();
      void showTAPopUp() ;
      void enableDabPTY();
      virtual void onCancelAnnouncement();
      void updateListInfo(uint32& listID);
      void showHideAnnouncement(bool status, uint8 annoType);
      void closeAllAnnouncementPopUps();
      bool checkAnnoStatus();
      bool _annoStatus;
      void setHMI_TAflag();

      App::Core::AnnoHandler::AnnoType& getAnnouncementObject(uint8 type);
      uint8 getAnnoType(::midw_tunermaster_fi_types::T_e8_AnnoTypes type);

      //std::string getAnnoText(::midw_tunermaster_fi_types::T_e8_AnnoTypes annoType, std::string annoText);

      virtual ::midw_tunermaster_fi_types::T_e8_Source getTASource();

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      virtual void onDabOtherAnnouncements(uint8 hdlRow);
      virtual bool getDabOtherAnnouncementStatus(uint8 annoRow);
      virtual void setDabOtherAnnouncements(bool otherAnnoStatus);
      void initOtherAnnoArray(bool otherAnnoStatus);
      void sendOtherAnnouncementSettingsToMW();
#endif
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      // COURIER_MSG_DELEGATE_TO_OBJ(_annoCourierMsgHandler)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      /** Instance of MIDW_TUNERMASTER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;

      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      /** Instance of MIDW_EXT_DABTUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > _dabFiProxy;

      /** Instance for the AnnoDataBindingHandler */
      // AnnoDataBindingHandler* _annoDataBinder;

      /** Instance for the AnnoCourierMsgHandler */
      // AnnoCourierMsgHandler* _annoCourierMsgHandler;

      /** Boolean Member Variable is true if TA is active */
      bool _taActive;

      bool _wbActive;

      /** Member variable to check if pty for DAB is enabled **/
      uint8 _isPTYEnabled;

      /** Member variable to hold FM Anno Station Name */
      ::midw_tunermaster_fi_types::T_e8_Source _CurrentActiveSrc;

      /** Member variable to hold FM Anno Station Name */
      ::midw_tunermaster_fi_types::T_e8_AnnoTypes _CurrentAnnoType;

      std::vector<AnnoType> _Announcements;

      bool _isCabinOnly;

#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2_1_R
      /** Member variables to hold DAB other announcements */
      bool _dabOtherAnno[NO_OF_IANNOUNCEMENTS];
#endif
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
