/**************************************************************************************
* @file         : AMFMStationList.h
* @author       : ECV2-Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM List data.
* @copyright    : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMStationList_h
#define AMFMStationList_h
#include "TunerDataBindingHandler.h"
#include "MIDW_TUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FIProxy.h"
#include "AppHmi_TunerStateMachine.h"
#include "App/Core/Tuner_Defines.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "AMFMStationIF.h"
#include "AMFMInfoIF.h"
#include "midw_tuner_fi_types.h"
#include "midw_tunermaster_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"


#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif


using namespace ::MIDW_TUNER_FI;
using namespace ::midw_tuner_fi_types;
using namespace ::MIDW_TUNERMASTER_FI;
using namespace ::midw_tunermaster_fi_types;


struct FM_StationList_Elem
{
      std::string _psName;
      uint32 _frequency;
      std::string _preset;
      uint16 _PI;
      std::string _Reg;
      bool _elementSelected;
      std::string _hdFMAudioPrg;
      bool _ishdFMStatus;
      bool _tpStatus;
      std::string _TPName;
      ::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram _hdProgramNumber;
   public :
      FM_StationList_Elem() : _psName(""), _frequency(0), _preset(""), _PI(0), _Reg(""), _elementSelected(false), _hdFMAudioPrg(""), _tpStatus(false), _TPName(""), _ishdFMStatus(false), _hdProgramNumber(::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram__TUN_AUDIO_PROGRAM_ONE)
      {
      }

      //for simulating large lists
      FM_StationList_Elem(std::string psname, uint32 freq, std::string preset) : _psName(psname), _frequency(freq), _preset(""), _PI(0), _Reg(""), _elementSelected(false), _hdFMAudioPrg(""), _tpStatus(false), _ishdFMStatus(false), _hdProgramNumber(::midw_tuner_fi_types::T_e8_Tun_HDAudioProgram__TUN_AUDIO_PROGRAM_ONE)
      {
      }
};


struct AM_StationList_Elem
{
      std::string _psName;
      uint16 _PI;
      std::string _hdAMAudioPrg;
      uint32 _AMFreq;
      bool _ishdAMStatus;
      bool _elementSelected;
   public :
      AM_StationList_Elem() : _psName(""), _PI(0), _hdAMAudioPrg(""), _AMFreq(0), _ishdAMStatus(false), _elementSelected(false)
      {
      }
};


class StartupSync;

namespace App {
namespace Core {

class TunerDataBindingHandler;


class AMFMStationList:
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_GET_CONFIG_LISTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_GET_CONFIG_LISTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_STATIONLIST_EXITCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SEL_LIST_ELEMCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_CONFIGLIST_UPDATECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SELECT_HD_AUDIOPRGMCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STATION_SELECTIONCallbackIF,
   public ListImplementation,
   public AMFMStationIF
{
      class AreaSelectionList
      {
         public:
            Candera::String TextID;
            uint8 RegionStatus;

            AreaSelectionList(Candera::String TextIDs, uint8 Status)
               : TextID(TextIDs),
                 RegionStatus(Status)
            {
            }
      };//class AreaSelectionList
      ::std::vector <std::string> frequencyarray;

      AMFMStationList();
      static AMFMStationList* m_poAMFMStationList;
   public:

      static AMFMStationList* poGetInstance()
      {
         if (NULL == m_poAMFMStationList)
         {
            m_poAMFMStationList = new AMFMStationList();
         }
         return m_poAMFMStationList;
      }
      void ListExitMsg();
      virtual ~AMFMStationList();
      virtual bool onCourierMessage(const StationListReqMsg& oMsg);
      virtual bool onCourierMessage(const BrowseListExitMsg& oMsg);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onFID_TUN_G_GET_CONFIG_LISTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_CONFIG_LISTError >& /*error*/);
      virtual void onFID_TUN_G_GET_CONFIG_LISTStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_CONFIG_LISTStatus >& status);

      virtual void onFID_TUN_S_GET_CONFIG_LISTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_GET_CONFIG_LISTError >& /*error*/);
      virtual void onFID_TUN_S_GET_CONFIG_LISTResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_GET_CONFIG_LISTResult >& /*result*/);

      virtual void onFID_TUN_S_STATIONLIST_EXITError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_STATIONLIST_EXITError >& /*error*/);
      virtual void onFID_TUN_S_STATIONLIST_EXITResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_STATIONLIST_EXITResult >& /*result*/);

      virtual void onFID_TUN_S_SEL_LIST_ELEMError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SEL_LIST_ELEMError >& /*error*/);
      virtual void onFID_TUN_S_SEL_LIST_ELEMResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SEL_LIST_ELEMResult >& /*result*/);

      virtual void onFID_TUN_S_DIRECT_FREQUENCYError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYError >& /*error*/) ;
      virtual void onFID_TUN_S_DIRECT_FREQUENCYResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYResult >& /*result*/);

      virtual void onFID_TUN_G_ATSEEKError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKError >& /*error*/);
      virtual void onFID_TUN_G_ATSEEKStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSEEKStatus >& status);

      virtual void onFID_TUN_S_ATSEEK_WITH_TUNERHEADERError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERError >& /*error*/);
      virtual void onFID_TUN_S_ATSEEK_WITH_TUNERHEADERResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_ATSEEK_WITH_TUNERHEADERResult >& /*result*/);

      virtual void onFID_TUN_S_CONFIGLIST_UPDATEError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_CONFIGLIST_UPDATEError >& /*proxy*/);
      virtual void onFID_TUN_S_CONFIGLIST_UPDATEResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_CONFIGLIST_UPDATEResult >& /*result*/);

      //======For HD==========wst4kor
      virtual void onFID_TUN_S_SELECT_HD_AUDIOPRGMError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SELECT_HD_AUDIOPRGMError >& /*error*/);
      virtual void onFID_TUN_S_SELECT_HD_AUDIOPRGMResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SELECT_HD_AUDIOPRGMResult >& /*result*/);

      virtual void onFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >&, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTError >&);
      virtual void onFID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >&, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SEL_HD_AUDIOPRGMDIRECTResult >&);

      virtual void onFID_TUNMSTR_S_STATION_SELECTIONError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STATION_SELECTIONError >& /*error*/);
      virtual void onFID_TUNMSTR_S_STATION_SELECTIONResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STATION_SELECTIONResult >& /*result*/);

      void createFMList(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_CONFIG_LISTStatus >& status);
      void clearFMList();
      void calcRegVal(const uint8& i);

      void updateList(const uint32& listID);

      void setStartIndex();
      uint getListIDfromBand(uint8 band);
      virtual void setAtStationInfoDataToAMFMStationList(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);

      void updateStationList();
      uint8 getConfigListID(uint8& band);
      void fmStationListHighlight(uint32& listCount, uint32& configListElemID, std::string& psName, uint16& pi);
      void simulateFMlist();
      uint8 getSelectedElementId();

      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);

      //wst4kor
      virtual void setFMHDActiveStatus(bool& FMHDActiveStatus);
      virtual void setAMHDActiveStatus(bool& AMHDActiveStatus);
      virtual void setHDDecodingData(bool& HDDataDecoding, bool& HDAudioDecoding);
      virtual void setAtStationInfoHDdataToAMFMSTationList(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);
      void setHDProgramList(bool HdProgramsAvailable[]);
      void updateHDAudioProg(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_CONFIG_LISTStatus >& status);
      virtual void setHDTimerStatus(bool HDTimerStatus);
      void getRegionType();
      bool bIsHDActive();
      virtual void setradioMainData(NARRadioMainData& radioMainData);
      tSharedPtrDataProvider getTunerHDInfoList();
      tSharedPtrDataProvider getTunerFMStationList();
      uint32 getCoverFlowStartIndex(uint8 selectedItemID);
      void fmListSelectedIndex(uint32& selectedIndex);

      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(StationListReqMsg)
      ON_COURIER_MESSAGE(BrowseListExitMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;

      /** Member Variable to hold Station List Element Count */
      uint32 _stationListElemCount;

      /** Member Variable to hold List item index */
      uint32 _selectedElemID;

      /** Member Variable to hold status of List entry/exit */
      bool _listEnter;

      /** Member Variable to confirm list button pressed */
      bool _isListDataRequested;

      /** Member Variable to confirm list button pressed */
      bool _isFMStationListOpened;

      /** Member Variable to hold AM Station List Element Count */
      uint32 _AMStationListElemCount;

      /** Member Variable to hold scan on-off status */
      bool _scanStatus;

      /** Member Variable to hold AM list size */
      uint8 _AMListSize;

      /** Member Variable to hold FM list size */
      uint8 _FMListSize;

      /** Member Variable to hold Frequency value from at station info*/
      uint32 _AtStationFreq;

      /** Vector to store Station List Elements */
      ::std::vector<FM_StationList_Elem> _fmStationList;

      /** Member Variable to hold current band */
      uint8 _band;

      //wst4kor
      /** Member variable to get the region type*/
      uint8 _regionType;

      /** Member variable to highlight active HD Audio Program  */
      uint8 _activeHDAudioPrg;

      /** Member Variable to hold HD Data decoding status */
      bool _HDDataDecodingStatus;

      /** Member Variable to hold HD Data Audio decoding status */
      bool _HDAudioDecodingStatus;

      /** Member Variable to hold HD Data decoding bit status */
      bool _HDDataDecodingBit;

      /** Member Variable to hold HD Audio decoding bit status */
      bool _HDAudioDecodingBit;

      /** Member Variable to hold AM HD Demod switch status */
      bool _AMHDActiveStatus;

      /** Member Variable to hold FM HD Demod switch status */
      bool _FMHDActiveStatus;

      /** Member Variable to hold the details of HD Audio Programs Available*/
      bool _HdProgramsAvailable[MAX_HD_AUDIO_PROGRAMS];

      /** Member Variable to hold HD Station ID */
      uint32 _HDStationID;

      /** Instance for the Radio Main Data */
      NARRadioMainData _radioMainData;

      /** Instance of TunerDataBindingHandler */
      TunerDataBindingHandler* _tunInfoDataBinder;  // removed for coverity may 4  //wst4kor uncommented for HD as this instance is needed
};


} // namespace Core
} // namespace App


#endif
