/**************************************************************************************
* @file         : AMFMInfoCourierMsgHandler.h
* @author       : ECV2-Rohini S R
* @addtogroup   : Tuner HALL
* @brief        : Class contains utility functions to handle courier messages required for AM FM Info.
* @copyright    : (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_AMFMInfoCourierMsgHandler_H)
#define _AMFMInfoCourierMsgHandler_H
#define TESTMODE_ENABLE 1

#include <AppHmi_TunerMessages.h>
#include "CgiExtensions/DataBindingItem.hpp"
#include "asf/core/Types.h"
#include "TunerStdSpecTypes.h"
#include "TunerDataBindingHandler.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
namespace App {
namespace Core {

//Forward Declarations
class AMFMStationIF;
class AMFMInfoIF;
class PresetListHandlingIF;
class TunerDataBindingHandler;
/* class AMFMInfoCourierMsgHandler
 * This class handles the courier messages received as "subscriber = Model".
 */

class AMFMInfoCourierMsgHandler
{
   public:
      /*   AMFMInfoCourierMsgHandler();*/
      AMFMInfoCourierMsgHandler(AMFMInfoIF* _mCourierIF, PresetListHandlingIF* _mPresetListHandlingIF);//, AMFMStationIF* _mStationListIF);
      virtual ~AMFMInfoCourierMsgHandler();
      // Incoming events ...

      bool Init();
      bool bAllocateAudioSouce(int iViewId);

      bool onCourierMessage(const PresetSelectMsg& corfoMsg);
      bool onCourierMessage(const PresetStoreMsg& corfoMsg);
      bool onCourierMessage(const TuneFrequencyReqMsg& corfoMsg);
      bool onCourierMessage(const AutoStoreReqMsg& corfoMsg);
      bool onCourierMessage(const SeekReqMsg& corfoMsg);
      bool onCourierMessage(const ScanReqMsg& corfoMsg);
      bool onCourierMessage(const Slider_TunerFrequencyMsg& corfoMsg);
      bool onCourierMessage(const TunerReqMsg& corfoMsg);
      bool onCourierMessage(const TunerViewReqMsg& corfoMsg);
      bool onCourierMessage(const Tuner_TestmodeViewReqMsg& corfoMsg);
      bool onCourierMessage(const TunerBLMsg& corfoMsg);
      bool onCourierMessage(const MediaChangeMsg& corfoMsg);
      bool onCourierMessage(const AppStatusUpdateMsg& corfoMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
      virtual bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const ButtonMainSrcActivate& oMsg);
      bool onCourierMessage(const ContextToMaster& oMsg);
      //HD Button visibility wst4kor
      bool onCourierMessage(const HdOnOffReqMsg& oMsg);
      bool onCourierMessage(const DtmSplitAudioReqMsg& /*oMsg*/);
      bool onCourierMessage(const DtmResetTransitionsReqMsg& /*oMsg*/);
      bool onCourierMessage(const HdParameterTuningMsg& oMsg);
      bool onCourierMessage(const HdParameterListUpdate& oMsg);
      bool onCourierMessage(const HdAudioProgSelectMsg& oMsg);
      bool onCourierMessage(const HdListAccessUpdateMsg& oMsg);

      bool onCourierMessage(const CloseNextPrev& oMsg);
      //SXM
      bool onCourierMessage(const SXMContextMsg& /*oMsg*/);
      bool onCourierMessage(const TestmodeBlockContextMsg& /*oMsg*/);
      bool onCourierMessage(const SXMMonitorContextMsg& /*oMsg*/);
      bool onCourierMessage(const SXMSettingsTestmodeContextMsg& /*oMsg*/);
      bool onCourierMessage(const FMAMBackContextMsg& /*oMsg*/);
      bool onCourierMessage(const ViewPreviousMsg& /*oMsg*/);
      bool onCourierMessage(const ActiveRenderedView& msg);
      virtual bool onCourierMessage(const onHardKeyPress& msg);
      //bool onCourierMessage(const Courier::UpdateModelMsg& corfoMsg);
      COURIER_MSG_MAP_BEGIN(0)

      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(PresetSelectMsg)
      ON_COURIER_MESSAGE(PresetStoreMsg)
      ON_COURIER_MESSAGE(TuneFrequencyReqMsg)
      ON_COURIER_MESSAGE(AutoStoreReqMsg)
      ON_COURIER_MESSAGE(SeekReqMsg)
      ON_COURIER_MESSAGE(ScanReqMsg)
      ON_COURIER_MESSAGE(Slider_TunerFrequencyMsg)
      ON_COURIER_MESSAGE(TunerReqMsg)
      ON_COURIER_MESSAGE(TunerViewReqMsg)
      ON_COURIER_MESSAGE(Tuner_TestmodeViewReqMsg)
      ON_COURIER_MESSAGE(AppStatusUpdateMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(TunerBLMsg)
      ON_COURIER_MESSAGE(ButtonMainSrcActivate)
      ON_COURIER_MESSAGE(ContextToMaster)
      ON_COURIER_MESSAGE(HdOnOffReqMsg)
      ON_COURIER_MESSAGE(DtmSplitAudioReqMsg)
      ON_COURIER_MESSAGE(DtmResetTransitionsReqMsg)
      ON_COURIER_MESSAGE(HdParameterTuningMsg)
      ON_COURIER_MESSAGE(HdParameterListUpdate)
      ON_COURIER_MESSAGE(HdAudioProgSelectMsg)
      ON_COURIER_MESSAGE(HdListAccessUpdateMsg)
      ON_COURIER_MESSAGE(SXMContextMsg)
      //ON_COURIER_MESSAGE(Courier::UpdateModelMsg)
      ON_COURIER_MESSAGE(CloseNextPrev)
      ON_COURIER_MESSAGE(TestmodeBlockContextMsg)
      ON_COURIER_MESSAGE(SXMMonitorContextMsg)
      ON_COURIER_MESSAGE(SXMSettingsTestmodeContextMsg)
      ON_COURIER_MESSAGE(FMAMBackContextMsg)

      ON_COURIER_MESSAGE(MediaChangeMsg)
      ON_COURIER_MESSAGE(ViewPreviousMsg)
      ON_COURIER_MESSAGE(ActiveRenderedView)
      ON_COURIER_MESSAGE(onHardKeyPress)
      COURIER_MSG_MAP_END()

      /** Instance of CourierMsgIF */
      AMFMInfoIF* _AmFmInfoIF;

      /** Instance of Station list IF */
      //commeneted for coverity
      //  AMFMStationIF* _AMFMStationIF;

      /** Instance of PresetListHandlingIF IF */
      PresetListHandlingIF* _PresetListHandlingIF;

      TunerDataBindingHandler* _tunerDataBindingHandler;
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;//applicationSwitch
      bool m_EnggModeActive;
      bool m_HdDTMActive; //wst4kor For HD
      tU8 m_u8timerCount;
      tU8 m_u8popupState;
      void vSwitchToTunerPlayView();
      void vTriggerView(tenViewID enRequestedView);
      tU8 m_hddtmsceneStatus;
      tU8 m_sceneStatus;
      void vRequestView(tenViewID enRequestedView);
      int m_lastActiveScreen;
      uint8 activeSource;
      uint16 activityID;
      uint8 enPreviousView;
      uint16 getTunerActivityID(std::string viewid);
      void sendStoreContextRequest(uint16 activityID);
      bool vRequestRemoteCommands(uint32 hardkeyPress, uint32 hardKeyValue);
   private:
      bool _isCabinOnly;
};


} // namespace Core
} // namespace App

#endif // _AMFMInfoCourierMsgHandler_H
