/**
 * @file        :  CGIAppViewController_Testmode.h
 * @addtogroup  :  AppHmi_Testmode
 * @brief       :  Receive messages subscribed with 'View' here, when it has not been consumed by any widget
 * @copyright   :  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#if !defined (_CGIAPPVIEWCONTROLLER_TESTMODE_H)
#define _CGIAPPVIEWCONTROLLER_TESTMODE_H
#include "CgiExtensions/CourierMessageMapper.h"
/**
* tController is the template for the classes
* to be created for the newly added scene. Each
*.new scene added will have to add new declaration
* as shown below.
*/
#define SIMPLE_CONTROLLER(tController)\
class tController : public ViewControllerBase\
{\
   private:\
   courier_messages:\
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_CTRL_COMP)\
      COURIER_DUMMY_CASE(0)\
      COURIER_MSG_MAP_END()\
   public:\
      tController() {}\
      virtual ~tController() {}\
      static const char* _name;\
      static Courier::ViewController* createInstance()\
      {\
         return COURIER_NEW(tController)();\
      }\
};


#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
#define SIMPLE_DUALDISPLAY_CONTROLLER(tController)\
class tController : public ViewControllerBase\
{\
   private:\
      courier_messages:\
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_CTRL_COMP)\
      ON_COURIER_MESSAGE(ShowViewOnCameraReqMsg)\
	  ON_COURIER_MESSAGE(HideViewOnCameraReqMsg)\
      COURIER_MSG_MAP_END()\
   public:\
      tController() {}\
      virtual ~tController() {}\
      static const char* _name;\
      std::map <Candera::UInt32,bool> cameraMap;\
      virtual bool onCourierMessage(const ShowViewOnCameraReqMsg& msg)\
      {\
         Courier::ViewScene2D* view2D = static_cast<Courier::ViewScene2D*>(GetView()); \
         if ((NULL != view2D) && (msg.GetViewId() == view2D->GetId()))\
         {\
            ::Candera::UInt32 index                       = 0;\
            ::Candera::UInt32 cameraId                    = msg.GetCameraId();\
            Courier::ViewScene2D::CameraPtrVector cameras = view2D->GetCameraPtrVector();\
			view2D->EnableRendering(true);\
			for (Courier::ViewScene2D::CameraPtrVector::Iterator itr = cameras.Begin(); (itr != cameras.End() && cameras.Size() >= cameraId); ++itr,++index)\
			{\
				::Candera::Camera2D* camera = (*itr);\
				if (NULL != camera)\
				{\
					if(index == (cameraId - 1))\
					{\
						camera->SetRenderingEnabled(true);\
						cameraMap[index] = true;\
					}\
					else \
					{\
                       if((!(cameraMap.count(index) > 0)) && (camera->IsRenderingEnabled()))\
				       {\
					      camera->SetRenderingEnabled(false);\
				       }\
					}\
				}\
			}\
            view2D->Invalidate(FeatStd::Optional<Candera::Rectangle>());\
            return true;\
         }\
         return false;\
      }\
	  virtual bool onCourierMessage(const HideViewOnCameraReqMsg& msg)\
      {\
         Courier::ViewScene2D* view2D = static_cast<Courier::ViewScene2D*>(GetView()); \
         if ((NULL != view2D) && (msg.GetViewId() == view2D->GetId()))\
         {\
            bool isModified                               = false;\
            bool bDeleteScene                             = true;\
            ::Candera::UInt32 index                       = 0;\
            ::Candera::UInt32 cameraId                    = msg.GetCameraId();\
            Courier::ViewId viewId                        = view2D->GetId();\
            Courier::ViewScene2D::CameraPtrVector cameras = view2D->GetCameraPtrVector();\
            for (Courier::ViewScene2D::CameraPtrVector::Iterator itr = cameras.Begin(); (itr != cameras.End() && cameras.Size() >= cameraId); ++itr,++index)\
            {\
               ::Candera::Camera2D* camera = (*itr);\
               if (NULL != camera)\
               {\
            	   if(index == (cameraId - 1)) \
				   {\
            		   isModified = true;\
            		   cameraMap.erase(index);\
            		   camera->SetRenderingEnabled(false);\
            		   break;\
                   }\
               }\
            }\
			if (isModified)\
			{\
				view2D->Invalidate(FeatStd::Optional<Candera::Rectangle>());\
				if (cameraMap.empty())\
				{\
				    view2D->Activate(false);\
                    view2D->EnableRendering(false);\
                    view2D->Invalidate(FeatStd::Optional<Candera::Rectangle>());\
                    POST_MSG((COURIER_MESSAGE_NEW(Courier::ActivationResMsg)(viewId,true,Courier::ViewScene2D::GetLastLoadError())));\
					view2D->GetViewHandler()->ExecuteViewAction(Courier::ViewAction::Destroy,viewId,false,false);\
					POST_MSG((COURIER_MESSAGE_NEW(Courier::ViewResMsg)(Courier::ViewAction::Destroy,viewId,true,Courier::ViewScene2D::GetLastLoadError())));\
				}\
			}\
			return true;\
         }\
         return false;\
      }\
      static Courier::ViewController* createInstance()\
      {\
         return COURIER_NEW(tController)();\
      }\
};


#endif


//Scenes
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_1_BLACK)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_2_WHITE)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_3_RED)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_4_GREEN)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_5_BLUE)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_6_FLICKER_1)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_7_FLICKER_2)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_8_MURA1)
SIMPLE_CONTROLLER(CGIAppViewController_DEV__SYSTEM_DISPLAY_TEST_9_MURA2)
SIMPLE_CONTROLLER(CGIAppViewController_TESTMODE__MAIN)
SIMPLE_CONTROLLER(CGIAppViewController_R_TestModeScreens)
SIMPLE_CONTROLLER(CGIAppViewController_R_TestmodeSourceSelection)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_MonitorTestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_TestMode)
SIMPLE_CONTROLLER(CGIAppViewController_SystemSettingTestMode)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor2)
SIMPLE_CONTROLLER(CGIAppViewController_R_FM_Triple_Tuner_Monitor3)
SIMPLE_CONTROLLER(CGIAppViewController_R_DAB_Monitor)
SIMPLE_CONTROLLER(CGIAppViewController_RVC_TESTMODE)
SIMPLE_CONTROLLER(CGIAppViewController_R_TestMode_SXM_Monitor_List)
SIMPLE_CONTROLLER(CGIAppViewController_R_SXM)
SIMPLE_CONTROLLER(CGIAppViewController_R_SXM_Channel_List)
SIMPLE_CONTROLLER(CGIAppViewController_R_Pfo_HealthCareMntr_DiagCtnrlTrouble)
#endif // _CGIAPPVIEWCONTROLLER_TESTMODE_H
