/**************************************************************************************
* @file         : TunerInfo.h
* @author       : ECV-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle utility functions.
* @copyright    : (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TunerUtility_H
#define TunerUtility_H

#include "asf/core/Types.h"
#include <string>
#include "CanderaWidget/String/String.h"

namespace App {
namespace Core {

/* class TunerInfo
 * All the logical calculations required for AMFM and DAB are implemented by this class
 */
class TunerUtility
{
   public:
      TunerUtility();
      virtual ~TunerUtility();

      //Methods
      static std::string formatFrequency(const uint32& frequency);
      static std::string formatTestmodeFrequency(const uint32& frequency, std::string band);
      static std::string u8ConversionToString(uint8 u8Value);
      static std::string u16ConversionToString(uint16 u16Value);
      static std::string u16ConversionToHexString(uint16 u16Value);
      static std::string u32ConversionToString(uint32 u32Value);
      static std::string u32ConversionToHexString(uint32 u32Value);
      static std::string quadConcatenate(const uint8& u8Val1, const uint8& u8Val2);
      static uint32 formatFMDirectFreq(const float& currentFreq);
      static uint32 formatAMDirectFreq(const float& currentFreq);
      static void setAMFMStepSizeFromKDS(const uint8& KDSAMStepSize, const uint8& KDSFMStepSize);
      static uint32 getListStartIndex(const uint8& listSize, const uint32& _selectedElemID);
      static std::string getSecureString(const Candera::String& string);

      static std::string formatFreqwithBand(const uint32& frequency);
      static std::string formatGadgetFrequency(const uint32& frequency);

      static void setFMFreqMinMax(const uint32& FMLowFrequency, const uint32& FMHighFrequency);
      static void setAMFreqMinMax(const uint32& AMLowFrequency, const uint32& AMHighFrequency);

      static std::string formatDTVCNdata(const uint16& value);
      static std::string formatDTVPERdata(const uint16& value, char layer);

      static uint8 _AMStepSize;
      static uint8 _FMStepSize;
      static uint32 _FMLowFrequency;
      static uint32 _FMHighFrequency;
      static uint32 _AMLowFrequency;
      static uint32 _AMHighFrequency;
};


} // namespace Core
} // namespace App


#endif
