/**************************************************************************************
* @file         : TunerTestmode_defines.h
* @author       : ECG-Deepak
* @addtogroup   : TunerTestmode HALL
* @brief        : Header file contains necessary defines required to for Tunertestmode updates.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef TunertestmodeDefines_H
#define TunertestmodeDefines_H

namespace App {
namespace Core {

//MACROS
#define TESTMODEBITACTIVE  0x01
#define PHYSICAL_TUNER_TWO 2
#define PHYSICAL_TUNER_THREE 3
#define SCENE_ENTRY 1
#define SCENE_EXIT 0
#define SHARX 2
#define HI_CUT 1
#define ARRAY_SIZE 20
#define NAM_REGION         0x00
#define CAN_REGION         0x01
#define MEX_REGION         0x02
#define EUR_REGION         0x06
#define GCC_REGION         0x0A
#define LAC_REGION         0x0F
#define OTHER_REGION       0xFF
#define JPN_REGION         0x19
#define DIVIDE_BY_THOUSAND     1000

#define TUN_BAND_WB 18


//ENUMSDefinition
enum enTunerTestModeReq
{
   TUN_TM_REQ_ACTIVE_TUNER_0 = 0,
   TUN_TM_REQ_ACTIVE_TUNER_1 = 1,
   TUN_TM_REQ_ACTIVE_TUNER_2 = 2,
   TUN_TM_REQ_ACTIVE_TUNER_3 = 3,
   TUN_TM_REQ_AUTO_MODE = 4,
   TUN_TM_REQ_BAND_CHANGE_TUNER_0 = 5,
   TUN_TM_REQ_BAND_CHANGE_TUNER_1 = 6,
   TUN_TM_REQ_BAND_CHANGE_TUNER_2 = 7
};


typedef enum
{
   EV_INVALID = 0,
   EV_SRCSEL_BACK /*=1*/,
   EV_ENGMODE_START /*=2*/,
   EV_ENGMODE_STOP /*=3*/,
   EV_ENGMODE_PARM  /*=4*/,
   EV_ENGMODE_AF_ONOFF  /*=5*/,
   EV_ENGMODE_BAND_SCAN  /*=6*/,
   EV_CLOSE_TA  /*=7*/,
   EV_ENGMENU_AMFM  /*=8*/,
   EV_SOUND_SETTING/*=9*/,
   EV_ENGMODE_MEASURE_MODE  /*=10*/,
   EV_TUNER_OPTION /*=11*/,
   EV_AUTOSTORE_SCAN/*=12*/,
   EV_ENGMODE_LINAUDIO/*=13*/,
   EV_LIST_LEARN/*=14*//*https://hi-cmts.apps.intranet.bosch.com:8443/browse/SUZUKI-22059*/
} ev_TunerBLEventType;

enum
{
   EV_MSG_TO_PL_TA = 1,
   EV_MSG_TO_PL_RADIO_TEXT,
   EV_MSG_TO_PL_REGPGM,
   EV_MSG_TO_PL_ALT_FREQ,
   EV_MSG_TO_PL_TP,
   EV_MSG_TO_PL_PTY31,
   EV_MSG_TO_PL_HICUTABS_STATUS,
   EV_MSG_TO_PL_SHARXABS_STATUS,
   EV_MSG_TO_PL_MEASUREMODE_STATUS,
   EV_MSG_TO_PL_OPT_TA ,
   EV_MSG_TO_PL_PHASEDIVERSITY,
   EV_MSG_TO_PL_OPT_REGPGM,
   EV_MSG_TO_PL_OPT_ALT_FREQ,
   EV_MSG_TO_PL_MUTE,
   EV_MSG_TO_PL_RDS_CONFIG,
   EV_MSG_TO_PL_AF_CONFIG,
   EV_MSG_TO_PL_REG_CONFIG,
   EV_MSG_TO_PL_TA_CONFIG,
   EV_MSG_TO_PL_NAVI_CONFIG,
   EV_MSG_TO_PL_AM_SLIDER_RANGE,
   EV_MSG_TO_PL_AM_SLIDER_STEPSIZE,
   EV_MSG_TO_PL_AM_SLIDERNOOFSTEPS,
   EV_MSG_TO_PL_AM_SLIDER_MAXVALUE,
   EV_MSG_TO_PL_AM_SLIDER_MINVALUE,
   EV_MSG_TO_PL_FM_SLIDER_STEPSIZE,
   EV_MSG_TO_PL_FM_SLIDERNOOFSTEPS,
   EV_MSG_TO_PL_FM_SLIDER_MAXVALUE,
   EV_MSG_TO_PL_TA_ICON,
   EV_MSG_TO_PL_VARIANT_TYPE,
   EV_MSG_TO_PL_SEL_ELEM,
   EV_MSG_TO_PL_DABUPDATE_POPUP,
   EV_MSG_TO_PL_TA_PSNAME,
   EV_MSG_TO_PL_SOURCE_SEL_ICON,
   EV_MSG_TO_PL_AUTOSTORE,
   EV_MSG_TO_PL_OPT_DAB_DYNCONTENT,
   EV_MSG_TO_PL_OPT_DAB_FM_LINKING,
   EV_MSG_TO_PL_OPT_DAB_DAB_LINKING,
   EV_MSG_TO_PL_DABPTY_FILTER_SETTINGS,
   EV_MSG_TO_PL_LINEAR_AUDIO,
   EV_MSG_TO_PL_AUTOSTORE_POPUP,
   EV_MSG_TO_PL_SPI_ICON,
   EV_MSG_TO_PL_TP_CURRENT_STATION,
   EV_MSG_TO_PL_TA_ICON_TYPE
};


}
}


#endif
