/**************************************************************************************
* @file         : AMFMTestMode.h
* @author       : ECV2-Priyanka B
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM Testmode data.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AMFMTestMode_H
#define AMFMTestMode_H

#include "MIDW_TUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FIProxy.h"
#include "MIDW_EXT_DABTUNER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/StartupSync/StartupSync.h"
#include <AppHmi_TestmodeMessages.h>
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TestmodeStateMachine.h"
#include "TunerTestModeDefines.h"

namespace App {
namespace Core {
//Forward Declarations
//@ded6kor: commented below for testing.
class TestModeDataBindingHandler;
//class SrcChangeIF;

/* class AMFMTestMode
 * The properties and methods of MIDW_TUNER_FI and MIDW_TUNERMASTER_FI required for TestMode data are implemented by this class
 */
class AMFMTestMode :
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_RF_ANTENNA_TESTCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_SRCCHG_TESTMODECallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_CALIBRATION_DATACallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_CALIBRATION_DATACallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODECallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_SHARXLEVELCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_SHARXLEVELCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_HICUTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_HICUTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_GET_DATA_TESTMODE_DDADDSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATURECallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_TEST_MODECallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_AFCallbackIF,
   public ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_SET_DDACallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_TESTMODE_DATACallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_TESTMODECallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_COMPONENT_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_BG_TESTMODE_DATACallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_GET_EXP_API_INFOCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_DB_QUERYCallbackIF,
   public ::MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPCallbackIF

{
   public:
      static AMFMTestMode* poGetInstance()
      {
         if (NULL == _AMFMTestModeInst)
         {
            _AMFMTestModeInst = new AMFMTestMode();
         }

         return _AMFMTestModeInst;
      }

      virtual ~AMFMTestMode();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      ////////////////////////

      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus >& status);
      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus >& status);
      virtual void onFID_TUN_S_SETUP_DDADDSError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSError >& /*error*/);
      virtual void onFID_TUN_S_SETUP_DDADDSResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SETUP_DDADDSResult >& /*result*/);
      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTError >& /*error*/);
      virtual void onFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTResult >& /*result*/);

      virtual void onFID_TUN_G_SET_DDAError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_DDAError >& /*error*/);
      virtual void onFID_TUN_G_SET_DDAStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_DDAStatus >& status);

      virtual void onFID_TUN_G_SET_RDSREGError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGError >& /*error*/);
      virtual void onFID_TUN_G_SET_RDSREGStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_RDSREGStatus >& status);

      virtual void onFID_TUNMSTR_S_STOP_ANNOUNCEMENTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTError >& /*error*/);
      virtual void onFID_TUNMSTR_S_STOP_ANNOUNCEMENTResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_STOP_ANNOUNCEMENTResult >& /*result*/);

      virtual void onFID_TUN_G_ANNOUNCEMENT_INFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOError >& /*error*/);
      virtual void onFID_TUN_G_ANNOUNCEMENT_INFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ANNOUNCEMENT_INFOStatus >& status);

      virtual void onFID_DAB_G_ANNO_STATUSError(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSError >& /*error*/);
      virtual void onFID_DAB_G_ANNO_STATUSStatus(const ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_ANNO_STATUSStatus >& status);
/////////////////////////////////////
      virtual void onFID_DAB_G_BG_TESTMODE_DATAError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_BG_TESTMODE_DATAError >& /*error*/);
      virtual void onFID_DAB_G_BG_TESTMODE_DATAStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_BG_TESTMODE_DATAStatus >& status);

      virtual void onFID_DAB_G_TESTMODE_DATAError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_TESTMODE_DATAError >& /*error*/);
      virtual void onFID_DAB_G_TESTMODE_DATAStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_TESTMODE_DATAStatus >& status);

      virtual void onFID_DAB_S_SET_TESTMODEError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_TESTMODEError >& /*error*/);
      virtual void onFID_DAB_S_SET_TESTMODEResult(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_SET_TESTMODEResult >& /*result*/);

      virtual void onFID_TUNMSTR_G_RF_ANTENNA_TESTError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_RF_ANTENNA_TESTError >& /*error*/);
      virtual void onFID_TUNMSTR_G_RF_ANTENNA_TESTStatus(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_RF_ANTENNA_TESTStatus >& status);

      virtual void onFID_TUNMSTR_S_SRCCHG_TESTMODEError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_SRCCHG_TESTMODEError >& /*error*/);
      virtual void onFID_TUNMSTR_S_SRCCHG_TESTMODEResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_SRCCHG_TESTMODEResult >& /*result*/);

      virtual void onFID_TUNMSTR_G_TP_STATUSError(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSError >& /*error*/);
      virtual void onFID_TUNMSTR_G_TP_STATUSStatus(const ::boost::shared_ptr< MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const boost::shared_ptr< MIDW_TUNERMASTER_FI::FID_TUNMSTR_G_TP_STATUSStatus >& status);

      virtual void onFID_TUN_G_SET_AFError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_AFError >& /*error*/);
      virtual void onFID_TUN_G_SET_AFStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_AFStatus >& status);
      //TunermasterFI methods
      virtual void onFID_TUNMSTR_S_TEST_MODEError(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_TEST_MODEError >& /*error*/);
      virtual void onFID_TUNMSTR_S_TEST_MODEResult(const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::FID_TUNMSTR_S_TEST_MODEResult >& /*result*/);

      virtual void onFID_TUN_S_CALIBRATION_DATAError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_CALIBRATION_DATAError >& /*error*/);
      virtual void onFID_TUN_S_CALIBRATION_DATAResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_CALIBRATION_DATAResult >& /*result*/);

      virtual void onFID_TUN_G_CALIBRATION_DATAError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_CALIBRATION_DATAError >& /*error*/);
      virtual void onFID_TUN_G_CALIBRATION_DATAStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_CALIBRATION_DATAStatus >& status);

      virtual void onFID_TUN_G_SET_MEASUREMODEError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODEError >& /*error*/);
      virtual void onFID_TUN_G_SET_MEASUREMODEStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_MEASUREMODEStatus >& status);

      virtual void onFID_TUN_S_SET_FEATUREError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATUREError >& /*error*/);
      virtual void onFID_TUN_S_SET_FEATUREResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_FEATUREResult >& /*result*/);

      virtual void onFID_TUN_S_SET_SHARXLEVELError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_SHARXLEVELError >& /*error*/);
      virtual void onFID_TUN_S_SET_SHARXLEVELResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_SHARXLEVELResult >& /*result*/);

      virtual void onFID_TUN_G_SET_SHARXLEVELError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_SHARXLEVELError >& /*error*/);
      virtual void onFID_TUN_G_SET_SHARXLEVELStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_SHARXLEVELStatus >& status);

      virtual void onFID_TUN_G_SET_HICUTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_HICUTError >& /*error*/);
      virtual void onFID_TUN_G_SET_HICUTStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_SET_HICUTStatus >& status);

      virtual void onFID_TUN_S_SET_HICUTError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& proxy, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_HICUTError >& /*error*/);
      virtual void onFID_TUN_S_SET_HICUTResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& proxy, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_SET_HICUTResult >& /*result*/);

      virtual void onFID_TUN_G_GET_DATA_TESTMODE_DDADDSError(const ::boost::shared_ptr< MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_TUNER_FI::FID_TUN_G_GET_DATA_TESTMODE_DDADDSError >& /*error*/);
      virtual void onFID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus(const ::boost::shared_ptr< MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_TUNER_FI::FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus >& status);
      //added from dab
      virtual void onFID_DAB_G_TUNER_STATUSError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSError >& /*error*/);
      virtual void onFID_DAB_G_TUNER_STATUSStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_TUNER_STATUSStatus >& status);
      virtual void onFID_DAB_G_ACTIVE_SERVICE_INFOError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOError >& /*error*/);
      virtual void onFID_DAB_G_ACTIVE_SERVICE_INFOStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_SERVICE_INFOStatus >& status);
      virtual void onFID_DAB_G_ACTIVE_ENSEMBLE_INFOError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOError >& /*error*/);
      virtual void onFID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_ENSEMBLE_INFOStatus >& status);
      virtual void onFID_DAB_G_ACTIVE_COMPONENT_INFOError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_COMPONENT_INFOError >& /*error*/);
      virtual void onFID_DAB_G_ACTIVE_COMPONENT_INFOStatus(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_G_ACTIVE_COMPONENT_INFOStatus >& /*status*/);
      virtual void onFID_DAB_S_GET_EXP_API_INFOError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_GET_EXP_API_INFOError >& /*error*/);
      virtual void onFID_DAB_S_GET_EXP_API_INFOResult(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_GET_EXP_API_INFOResult >& result);
      virtual void onFID_DAB_S_DB_QUERYError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_DB_QUERYError >& /*error*/);
      virtual void onFID_DAB_S_DB_QUERYResult(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_DB_QUERYResult >& result);
      virtual void onFID_DAB_S_SETUPError(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPError >& /*error*/);
      virtual void onFID_DAB_S_SETUPResult(const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_EXT_DABTUNER_FI::FID_DAB_S_SETUPResult >& /*result*/);
      virtual void onFID_TUN_S_SET_TESTMODEError(const ::boost::shared_ptr< MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_TUNER_FI::FID_TUN_S_SET_TESTMODEError >& /*error*/);
      virtual void onFID_TUN_S_SET_TESTMODEResult(const ::boost::shared_ptr< MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const ::boost::shared_ptr< MIDW_TUNER_FI::FID_TUN_S_SET_TESTMODEResult >& /*result*/);
      void updateDabExpertID();
      ::std::string getLinkingMode(midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode mode);
      void onPressDabSettingList(uint8 rowId, uint8 colId);
      void toggleLinkingMode();
      void updateConcealmentValue(uint8& param, uint8 operation);
      void onSelectConcealmentValue(uint8 colId);
      void changeDabDBScene();
      void setActiveView(uint32 lActiveViewID);
      void setChannelInfoDataToTestMode(const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status);
      std::string getBitMask(::midw_ext_dabtuner_fi_types::T_b16_DAB_AnnouncementType type);
      void setDabDTMData(const boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::FID_DAB_G_CHANNEL_INFOStatus >& status);
      uint8 getscenestatus();
      bool onCourierMessage(const FMMonitorMessage& corfoMsg);
      bool onCourierMessage(const TunerBLMsg& corfoMsg);
      bool onCourierMessage(const DABIconVisibility& corfoMsg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(FMMonitorMessage)
      ON_COURIER_MESSAGE(TunerBLMsg)
      ON_COURIER_MESSAGE(DABIconVisibility)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
      enum DTMFields { ChannelNo = 1, ExpertAPI_ID, FIC, MSC, FM, FMQuality, ServiceID, SF, SyncFlag, FieldStrength, ShortLabel, BitRate, SamplingRate,
                       NoOfComponent, MuteFlag, SC, SCType, ACCFlag, TAStatus, TA_Source, TMID, TP, TSUFlag, PSFlag, FMPI, PL, AudioQuality, SignalQuality,
                       RS_FEC, EnsembleID, NoOFEnsebles, NoOfServices, NoOfChannels, ASU, ASW, BG_EnsFreq, ServiceLabel, EnsembleLabel, NetbitErroRate
                     };
      void sendStmScreenData(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus >& status);
      void sendQuadMonitorData(const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_GET_DATA_TESTMODE_DDADDSStatus >& status);
      void onQuadMonitorSelect(uint8 tunerIndex);
      void sendTestModeONOFFDAB();
      std::string getBand(uint8 band) const;
      void sendTestModeONOFF(uint8 screenState);
      void onDTMScreenEntry(uint8 screenState);
      void onScreenEntry();
      void onScreenExit();
      void onSelectMeasureMode();
      void onSelectRDSREG();
      void onSelectAFFollowing();
      void onToggleTA();
      void onSelectPhaseDiversity();
      virtual void setTAflag(bool tastatus);
      void vSetHiCutValue(uint8 value);
      void vSetSharxValue(uint8 value);
      uint8 decreaseRadioParam(uint8 paramValue, uint8 valueMin);
      uint8 increaseRadioParam(uint8 paramValue, uint8 valueMax);
      uint8 getActivePhysicalTuner();
      uint8 m_sceneStatus;
      //TestMode Functions
      void updateCalibrationData(std::string calibFMTun1, std::string calibFMTun2, std::string calibFMTun3, std::string calibFMTun4, std::string calibAMTun);
      void updateTun1QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun2QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun3QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);
      void updateTun4QuadData(std::string band, std::string freq, std::string PI, std::string psName, std::string FS_Q, std::string hCut, std::string sharx,
                              std::string PD, std::string TP, std::string TA, std::string RDS, std::string AFlength, std::string MP_NC, std::string deviation, std::string CS);

      void updateQuadMonitorStatus(bool tuner1Status, bool tuner2Status, bool tuner3Status, bool tuner4Status,
                                   bool band1Status, bool band2Status, bool band3Status, bool band4Status,
                                   bool isBand1Enabled, bool isBand2Enabled, bool isBand3Enabled, bool isBand4Enabled, bool isTuner1Enable, bool isTuner2Enable, bool isTuner3Enable, bool isTuner4Enable);

      void updateTMactiveTunerdata(uint8 activeBand);
      void updateEngineeringMenu(std::string freq, std::string psName, std::string PI, std::string FS_Q, std::string Quality, std::string hCut, std::string sharx,
                                 std::string deviation, std::string CS);

      void readKdsForRegion();

      DataBindingItem<Tuner1DataBindingSource> oTTMonitor1;
      DataBindingItem<Tuner2DataBindingSource> oTTMonitor2;
      DataBindingItem<Tuner3DataBindingSource> oTTMonitor3;
      DataBindingItem<Tuner4DataBindingSource> oTTMonitor4;
      DataBindingItem<TunerSource_BandDataBindingSource> oTTTunerSource_Band;
      DataBindingItem<EngineeringInfoDataBindingSource> oEngineeringMenuData;
      DataBindingItem<EngineeringInfo1DataBindingSource> oEngineeringMenuData1;
      DataBindingItem<EngineeringInfo2DataBindingSource> oEngineeringMenuData2;
      DataBindingItem<FMSetupMenuInfoDataBindingSource> oFMSetupMenuInfo;
      //to be removed
      uint8 _concealmentLevel;
      midw_ext_dabtuner_fi_types::T_e8_DAB_ServiceLinkingMode _linkingMode;
      std::map<DTMFields, std::string> _DTMFieldMap;
      DataBindingItem<DABGTestModeInfoDataBindingSource> oDABTestModeGTestmodeInfo;
      DataBindingItem<DAB_Test_ModeDataBindingSource> oDABTestModePointer;
      DataBindingItem<DAB_Setup_ScreenDataBindingSource> oDABSetupMonitor;
      DataBindingItem<DAB_Setup_Screen_ActiveTuner_InfoDataBindingSource> oDABTestModeActivertunerInfo;
      DataBindingItem<DABTestModeEnsembleInfoDataBindingSource> oDABTestModeActiveEnsembleInfo;
      DataBindingItem<DABGTestModeAnnoStatusInfoDataBindingSource> oDABTestModeAnnoStatusInfo;
      DataBindingItem<DABGTestModeActiveCompDataBindingSource> oDABTestModeActiveCompInfo;
      DataBindingItem<DABTestModeGAvailabiltyInfoDataBindingSource> oDABTestModeGAvailabiltyInfo;
      DataBindingItem<DABTestModeServiceFollowingInfoDataBindingSource> oDABTestServiceFollowingInfo;

      ::std::string _fieldStrength;
      ::std::string _signalQuality;
      ::std::string _audioMode;
      ::std::string _audioQuality;
      ::std::string _audioBitrate;
      ::std::string _audioSamplingRate;
      ::std::string _ensembleChannel;
      ::std::string _ensembleName;
      ::std::string _ensembleID;
      ::std::string _serviceName;
      ::std::string _serviceID;
      ::std::string _fMFrequency;
      ::std::string _fMPICode;
   private:
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      /** Instance of MIDW_TUNERMASTER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;

      /** Instance of MIDW_EXT_DABTUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_EXT_DABTUNER_FI::MIDW_EXT_DABTUNER_FIProxy > _dabFiProxy;

      ::std::string _antennaStatus;
      /** Member Variable to hold hiCut value */
      uint16 _hiCut;
      /** Member Variable to hold sharx Level value */
      uint8 _sharxLevel;

      /** Member Variable to hold active physical tuner */
      uint8 _physicalTuner;

      /** Member Variable to hold dtm secondary physical tuner value*/
      uint8 _secPhysicalTuner;

      /** Member Variable to hold phase Diversity value*/
      std::string _phaseDiversity;
      uint32 _phaseDiversityIndex;
      std::string _ddaState;
      /** Member Variable to hold audible tuner */
      uint8 _audibleTuner;
      /** Member Variable to hold current frequency */
      uint32 _frequency;
      /** Member Variable to hold active band */
      uint8 _band;

      uint8 _regionType;
      bool _feature_DDA;
      bool _afIndex;
      bool _taActive;
      bool _measureIndex;
      bool _isRegActive;
      /** Instance for the TTFIs Trace command. */
      static AMFMTestMode* _AMFMTestModeInst;
      std::string _measureMode;
      AMFMTestMode();
      struct DabExpertAPIInfo
      {
         std::string _expertID;
         std::string _expertIDLabel;
         std::string _expertIDValue;
         DabExpertAPIInfo() : _expertID("0"), _expertIDLabel(""), _expertIDValue("") {}
      };
      void calcMask(uint16& maskVal, uint16& finalMask, bool type);
      std::vector<DabExpertAPIInfo> _DabExpertAPIInfoList;
      /** Instance of TestModeDataBindingHandler */
      //TestModeDataBindingHandler* _testModeDataBinding;
      enum ExpertIDIndexInfo { EXPERTID_INDEX_1 = 5, EXPERTID_INDEX_2, EXPERTID_INDEX_3 };

      ExpertIDIndexInfo _expertIDIndex;
      uint8 _DabDTMDBsceneId;
      bool _DRCStatus;
      uint32 _ActiveViewListID;
      static const uint8 DAB_QUERY_MAX_COUNT;
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App


#endif
