/**************************************************************************************
* @file         : SystemSettingTestMode.h
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*21.09.17 Rev. 0.1 Prashant BG (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/
#ifndef SYSTEMSETTINGTESTMODE_H_
#define SYSTEMSETTINGTESTMODE_H_
#define TESTMODE_ENABLE 1

#include "CourierTunnelService/CourierMessageReceiverStub.h"
//#include "rvc_cca_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppBase/ServiceAvailableIF.h"
//#include "AppHmi_TestmodeStateMachine.h"
#include "AppHmi_TestmodeMessages.h"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "Common/DataModel/ListRegistry.h"
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
//#include "AppHmi_TestmodeStateMachineData.h"
#include "asf/core/Types.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#include "dp_generic_if.h"
#endif


namespace App {
namespace Core {

//using namespace ::rvc_cca_fi;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;

/* class SystemSettingTestMode : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ReverseSignalStatusCallbackIF */
class SystemSettingTestMode : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public Sig_ActivateContextCallbackIF
   , public ActiveRegionIdCallbackIF
{
   public:
      static SystemSettingTestMode* poGetInstance()
      {
         if (NULL == _SystemSettingTestMode)
         {
            _SystemSettingTestMode = new SystemSettingTestMode();
         }

         return _SystemSettingTestMode;
      }
      /* COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
       COURIER_DUMMY_CASE(0)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
       COURIER_MSG_MAP_DELEGATE_START()
       // COURIER_MSG_DELEGATE_TO_OBJ(_annoCourierMsgHandler)
       COURIER_MSG_MAP_DELEGATE_END()*/
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
      ON_COURIER_MESSAGE(ContextToMaster)
      COURIER_MSG_MAP_END()
      bool onCourierMessage(const GuiStartupFinishedUpdMsg& oMsg);
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      bool onCourierMessage(const ContextToMaster& /*oMsg*/);
      virtual ~SystemSettingTestMode();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void DisplayUpdateImage(int DisplayValue);
      void DisplaySystemSettingScene();
      void totest(int i);
      void ActivateTestScreen();
      // static void set(int i);
      // static void TraceCmd_onSwitchDisplayUpdateImageView(int u8TestNumber);
      //static void TraceCmd_onTriggerDisplayUpdateImageView();
      void reqContextSwitchSrcSelectionHome();
      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                         const ::boost::shared_ptr< ActiveRegionIdError >& error) ;

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy,
                                          const ::boost::shared_ptr< ActiveRegionIdUpdate >& update) ;

      void ExitTestScreen();
      DataBindingItem<SystemSettingTestModeDataBindingSource> mSystemSettingTestMode;
      DataBindingItem<Smart_InfoDataBindingSource> oSmart_Info;

      void testmode_Variantcheck();
      bool testmode;
      void readTestmode();
      uint8 getCurrentActiveRegion();
   private:
      SystemSettingTestMode();
      static SystemSettingTestMode* _SystemSettingTestMode;
      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchProxy;
      tU8 _testModeValue;
      uint8 getKdsVariantSelection();
      uint8 m_u8activeRegion;
      uint8 _isCCVariant;
      /* ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy; */
};


}
}


#endif
