/**************************************************************************************
* @file         : SxmTestMonitor.h
* @addtogroup   : AppHmi_Sxm
* @brief        : Functional class to handle business logic for Sxm Diagnosis application.
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef _SXMTESTMONITOR_H_
#define _SXMTESTMONITOR_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_TestmodeMessages.h"
#include "AppBase/ServiceAvailableIF.h"
#include "SxmAudioTypes.h"
#include "Common/DataModel/ListRegistry.h"
#include "Widgets/2D/List/Data/ListDataProviderBuilder.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "SxmAudioDataBindingUtils.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"

namespace sxm_audio_main_fi {
class Sxm_audio_main_fiProxy;
}


namespace App {
namespace Core {
/**
* Utility class which contains all the necessary business logic required to handle Diagnosis.
* @class : SxmTestMonitor
*/

class SxmTestMonitor
   : public ListImplementation
   , public ::sxm_audio_main_fi::SxmRadioIdCallbackIF
   , public ::sxm_audio_main_fi::SxmAudioSubInfoCallbackIF
   , public ::sxm_audio_main_fi::SxmDiagAntennaStateCallbackIF
   , public ::sxm_audio_main_fi::DiagTestModeDataCallbackIF
   , public ::sxm_audio_main_fi::DiagTestModeEnableCallbackIF
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::sxm_audio_main_fi::ChannelInformationCallbackIF
   , public ::sxm_audio_main_fi::SelectChannelCallbackIF
   , public ::sxm_audio_main_fi::SystemMessageCallbackIF
   , public ::sxm_audio_main_fi::GetChannelListCallbackIF
   , public ::sxm_audio_main_fi::PresetChannelUpdateCallbackIF
   , public ::sxm_audio_main_fi::AutoCompareCallbackIF
   , public ::sxm_audio_main_fi::SetAutoCompareParametersCallbackIF
   , public ::sxm_audio_main_fi::RecallPresetCallbackIF
   , public ::sxm_audio_main_fi::GetPresetListCallbackIF
   , public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceCallbackIF
   , public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceCallbackIF
   , public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListCallbackIF
//, public ::sxm_audio_main_fi::SxmDiagSignalQualityCallbackIF
{
   public:

      /**
      * SxmTestMonitor Class destructor
      */
      virtual ~SxmTestMonitor();
      /**
      * Utility function that registers for notifications updates from SXM Audio MIDW layer
      */
      //virtual bool OnMessage(const Courier::Message& Msg);

      static SxmTestMonitor* poGetInstance()
      {
         if (NULL == m_poSxmTestMonitor)
         {
            m_poSxmTestMonitor = new SxmTestMonitor();
         }

         return m_poSxmTestMonitor;
      }

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

      void onSxmRadioIdError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmRadioIdError >& error);

      void onSxmRadioIdStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                              const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmRadioIdStatus >& status);

      void onSxmAudioSubInfoError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmAudioSubInfoError >& error);

      void onSxmAudioSubInfoStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmAudioSubInfoStatus >& status);

      void onSxmDiagAntennaStateError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagAntennaStateError >& error);

      void onSxmDiagAntennaStateStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagAntennaStateStatus >& status);

      void onDiagTestModeDataError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                   const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeDataError >& error);

      void onDiagTestModeDataStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                    const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeDataStatus >& status);

      void onDiagTestModeEnableError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeEnableError >& error);

      void onDiagTestModeEnableResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::DiagTestModeEnableResult >& result);

      void onChannelInformationError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                     const boost::shared_ptr< ::sxm_audio_main_fi::ChannelInformationError >& error);

      void onChannelInformationStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const boost::shared_ptr< ::sxm_audio_main_fi::ChannelInformationStatus >& status);

      void onSelectChannelError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelError >& error);

      void onSelectChannelResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SelectChannelResult >& result);

      void onSystemMessageError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageError >& error);

      void onSystemMessageStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::SystemMessageStatus >& status);

      void onGetChannelListError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const boost::shared_ptr< ::sxm_audio_main_fi::GetChannelListError >& error);

      void onGetChannelListResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                  const boost::shared_ptr< ::sxm_audio_main_fi::GetChannelListResult >& result);

      void onGetPresetListError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const ::boost::shared_ptr< ::sxm_audio_main_fi::GetPresetListError >& error);

      void onGetPresetListResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi::GetPresetListResult >& result);

      void onAutoCompareError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                              const boost::shared_ptr< ::sxm_audio_main_fi::AutoCompareError >& /*error*/);

      void onAutoCompareStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                               const boost::shared_ptr< ::sxm_audio_main_fi::AutoCompareStatus >& /*status*/);

      void onPresetChannelUpdateError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::PresetChannelUpdateError >& error);

      void onPresetChannelUpdateStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi::PresetChannelUpdateStatus >& status);

      void onSetAutoCompareParametersError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                           const boost::shared_ptr< ::sxm_audio_main_fi::SetAutoCompareParametersError >& /*error*/);

      void onSetAutoCompareParametersResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                            const boost::shared_ptr< ::sxm_audio_main_fi::SetAutoCompareParametersResult >& /*result*/);

      void onRecallPresetError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                               const boost::shared_ptr< ::sxm_audio_main_fi::RecallPresetError >& /*error*/);

      void onRecallPresetResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                const boost::shared_ptr< ::sxm_audio_main_fi::RecallPresetResult >& result);

      virtual void onActivateSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                         const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceError >& /*error*/);
      virtual void onActivateSourceResponse(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceResponse >& /*response*/);

      virtual void onActiveSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceError >& /*error*/);

      virtual void onActiveSourceUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceUpdate >& update);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListError >& /*error*/);
      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListUpdate >& update);

      //void onSxmDiagSignalQualityError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
      //    const ::boost::shared_ptr< ::sxm_audio_main_fi::SxmDiagSignalQualityError >& error);

      //void onSxmDiagSignalQualityStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
      //    const ::boost::shared_ptr< ::sxm_audio_main_fi:: SxmDiagSignalQualityStatus >& status);

      void getPresetList();
      bool updatePresetItem(uint8 presetIdx, const ::sxm_audio_main_fi_types::T_PresetListEntry& presetElement);
      void setPresetList(const ::std::vector< ::sxm_audio_main_fi_types::T_PresetListEntry >& presetList);
      void setPresetListElement(uint8 presetIdx, const ::sxm_audio_main_fi_types::T_PresetListEntry& presetElement);
      //list related
      void setRadioData(std::string radioId);
      void setDiagAntennaStatus(uint32 antennastatus);
      void setDiagAudioSubInfo(uint32 audioSubInfo);
      void refreshSxmAudioList(unsigned int listId);
      void setDiagTestModeData(const ::sxm_audio_main_fi_types::T_SxmDiagTestModeData& testModeData);
      void setDiagSxmVersion();
      std::string safeGetCString(unsigned int textId);
      std::map<uint8, uint32> _diagnosisStmList;
      std::string _radioID;

      static std::map<uint8, std::string> _diagnosisMonitorList;

      tSharedPtrDataProvider getSxmTestModeMonitorSelection();
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      void updateList(const uint32& listID);
      std::map<uint8, uint32> _diagnosisInfoList;
      virtual tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      // virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      void SxmListSelectedIndex(uint32& selectedIndex);
      bool getBTStreamingAvailability();
      bool IsMediaSourceRange(int srcid);
      bool IsTunerSourceRange(int srcid);
   private:
      /**
      * SxmTestMonitor Class constructor
      */
      SxmTestMonitor();
      static SxmTestMonitor* m_poSxmTestMonitor;
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSrcChgProxy;

      /**********************************************************Courier Message callbacks*****************************************************/
      /**
      * Callback to handle Courier Message SxmDTMTestModeMonitorSelReqMsg Request
      */
      bool onCourierMessage(const SxmDTMTestModeMonitorSelReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioCustomizeListReqMsg Request
      */
      bool onCourierMessage(const SXMAudioCustomizeListReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioRecallorStoreReqMsg Request
      */
      bool onCourierMessage(const SXMAudioRecallorStoreReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SXMAudioAllocateReqMsg Request
      */
      bool onCourierMessage(const SXMAudioAllocateReqMsg& oMsg);

      /**
      * Callback to handle Courier Message SXMSettingsTestModeListReqMsg Request
      */
      //bool onCourierMessage(const SXMSettingsTestModeListReqMsg& oMsg);
      /**
      * Helper function to start External Diagnosis Mode.
      */
      void externalDiagSwitch(unsigned int, unsigned int);
      /**
      * Helper function to update the subscribe button.
      */
      void setSubscribeButton() const;
      /**
      * Courier Message Handler
      */
      void getCustomizeChannelList(uint16, uint16);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)

      ON_COURIER_MESSAGE(SxmDTMTestModeMonitorSelReqMsg)
      ON_COURIER_MESSAGE(SXMAudioCustomizeListReqMsg)
      ON_COURIER_MESSAGE(SXMAudioRecallorStoreReqMsg)
      ON_COURIER_MESSAGE(SXMAudioAllocateReqMsg)
      //ON_COURIER_MESSAGE(ButtonReactionMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _ptrSxmAudioFiProxy;
      bool _isExternalDiagmodeOn;
      bool _isDataServiceInfoSubscribeOn;
      bool _isAudioSubInfoSubscribeOn;
      bool _isClearAllDBandData;
      bool _isPresetListAvailable;
      const uint8 _cStepSizeOne;
      bool m_bBTSreamingAvailable;

      uint16 m_StartIndex_Channellist;
      uint16 m_WindowSize_Channellist;

      ::sxm_audio_main_fi_types::T_ChannelInformation _channelInfoStatus;
      ::std::vector< ::sxm_audio_main_fi_types::T_PresetListEntry > _presetList;
      ::std::vector<StructPrestList> aSXM_PresetChannelName;
   protected:
};


}  // namespace Core
}  // namespace App

#endif
