/**************************************************************************************
* @file         : SxmAudioDataBindingUtils.h
* @addtogroup   : AppHmi_Sxm
* @brief        : Utility class to handle databinding updates.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef _SXMAUDIODATABINDING_H_
#define _SXMAUDIODATABINDING_H_

#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TestmodeDatabinding.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "SxmAudioTypes.h"

//forward declaration
namespace sxm_audio_main_fi_types {
class T_ChannelInformation;
}


namespace App {
namespace Core {

/**
* Utility class to handle all processing for GUI requests
* @class : SxmAudioDataBindingUtils
*/
class SxmAudioDataBindingUtils
{
   public:
      /**
      * SxmAudioDataBindingUtils Class destructor
      */
      virtual ~SxmAudioDataBindingUtils();

      void setSxmChannelInfoData(const ::sxm_audio_main_fi_types::T_ChannelInformation& channelInfo);

      void clearSxmChannelInfoData(void);

      void setAdvisoryText(std::string advisoryMessage);

      void setAdvisoryText(Candera::String advisoryMessage);

      void setGadgetAdvisoryText(Candera::String advisoryMessage) const;

      void setSystemMessageStatus(uint8 u8status);

      void updateAdvisoryMessage();

      void SxmUpdateAntennaStatus(uint8 enAntennaStatus);

      std::string replaceInTranslationTextID(std::string TranslationStr, std::string StrForReplace, std::string strToSearch);

      std::string safeGetCString(unsigned int textId);

      //void updateSXMPresets(::std::vector<std::string>& rfoPresetList);
      //void updateSXMPresets(StructPrestList& rfoPresetList);
      void updateSXMPresets(std::vector<StructPrestList>& rfoPresetList);
      void setSxmChannelNumber(std::string channelNo);

      static SxmAudioDataBindingUtils* poGetInstance()
      {
         if (NULL == m_poSXMDataBinding)
         {
            m_poSXMDataBinding = new SxmAudioDataBindingUtils();
         }

         return m_poSXMDataBinding;
      }
   private:

      /**
      * SxmAudioDataBindingUtils Class constructor
      */
      SxmAudioDataBindingUtils();
      static SxmAudioDataBindingUtils* m_poSXMDataBinding;

      //Member Variables
      DataBindingItem<SxmChannelInfoDataBindingSource> _sxmChannelInfo;
      DataBindingItem<SxmTpopChannelInfoDataBindingSource> _sxmTpopChannelInfo;
      DataBindingItem<PresetInfoSXMDataBindingSource> _sxmPresetInfo;
      DataBindingItem<SXMAntennaInfoDataBindingSource> _sxmAntennaInfo;

      bool _isScanActive;
      bool _isAllChannelInfoAvail;
      bool _isPresetListAvail;
      bool _isTWNButtonEnabled;
      bool _isSFButtonEnabled;
      bool _isSFActive;
      bool _isTWNActive;
      uint8 _activeMode;
      uint8 _systemErrorCode;
      bool  _istuneToContentAlert;
      bool _isTransitionDone;
      const float DELETEPOSX;
      const float DELETEPOSY;
      Candera::String _sxmSceneName;
};


}  // namespace Core
}  // namespace App

#endif
