/**************************************************************************************
* @file         : SxmAudioDataBindingUtils.cpp
* @addtogroup   : AppHmi_Sxm
* @brief        : Utility class to handle databinding updates.
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "hall_std_if.h"   // Including HALL framework code
#include "SxmAudioDataBindingUtils.h"
#include "sxm_audio_main_fi_types.h"
#include "CgiExtensions/ImageLoader.h"


//#include "SxmAudioTypes.h"
//#include "App/Core/LanguageDefines.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX             App::Core::SxmAudioDataBindingUtils::
#include "trcGenProj/Header/SxmAudioDataBindingUtils.cpp.trc.h"
#endif


/* #define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_06_if.h" */
#define PRESET 0

#define SXM__AUDIO_CHANNELINFO_CHID 11111


namespace App {
namespace Core {

SxmAudioDataBindingUtils* SxmAudioDataBindingUtils::m_poSXMDataBinding = NULL;
/**
* SxmAudioDataBindingUtils Class constructor
*/
SxmAudioDataBindingUtils::SxmAudioDataBindingUtils()
   : _isScanActive(false)
   , _isAllChannelInfoAvail(false)
   , _isPresetListAvail(false)
   , _isTWNButtonEnabled(false)
   , _isSFButtonEnabled(false)
   , _isSFActive(false)
   , _isTWNActive(false)
   , _activeMode(PRESET)
   , _systemErrorCode(0)
   , _istuneToContentAlert(false)
   , _isTransitionDone(true)
   , DELETEPOSX(583.0)
   , DELETEPOSY(89.0)
   , _sxmSceneName("")
{
   (*_sxmAntennaInfo).mAntennaStatus = "no an";
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR4(("SxmAudioDataBindingUtils() Constructor"));
}


/**
* SxmAudioDataBindingUtils Class destructor
*/
SxmAudioDataBindingUtils::~SxmAudioDataBindingUtils()
{
   ETG_TRACE_USR4(("~SxmAudioDataBindingUtils() Destructor"));
   ETG_I_UNREGISTER_FILE();
   _isScanActive = false;
   _isAllChannelInfoAvail = false;
   _isPresetListAvail = false;
   _isTWNButtonEnabled = false;
   _isSFButtonEnabled = false;
   _isSFActive = false;
   _isTWNActive = false;
   _activeMode = PRESET;
   _systemErrorCode = 0;
   _istuneToContentAlert = false;
   _isTransitionDone = true;
   _sxmSceneName = "";
}


void SxmAudioDataBindingUtils::setSxmChannelInfoData(const ::sxm_audio_main_fi_types::T_ChannelInformation& channelInfo)
{
   std::ostringstream lChannelID;
   uint16 ServiceID = channelInfo.getSID();
   lChannelID << channelInfo.getChannelNumber();
   std::string strChannelID = lChannelID.str();
   ETG_TRACE_USR4(("strChannelID is %s", strChannelID.c_str()));
   ETG_TRACE_USR4(("SXMSongTitle is %s", channelInfo.getSongName()));
   std::string Channel = "Ch "; //safeGetCString(SXM__AUDIO_CHANNELINFO_CHID);
   std::string hifen = " - ";

   //char sQuadConcat[5] = "\0";
   //snprintf(sQuadConcat, sizeof sQuadConcat, "%s %s", Channel, strChannelID);
   //
   char presetString[20] = {'\0'};
   snprintf(presetString, sizeof(presetString), "Ch.%s", strChannelID.c_str());

   if (ServiceID == 0) //for channel 0
   {
      (*_sxmChannelInfo).mArtistName =  channelInfo.getChannelName().c_str();   //since channel name is not displayed in main screen
   }
   else
   {
      (*_sxmChannelInfo).mArtistName = channelInfo.getArtistName().c_str();
   }
   ETG_TRACE_USR4(("mChannelName is %s", channelInfo.getChannelName().c_str()));
   (*_sxmChannelInfo).mChannelName = channelInfo.getChannelName().c_str();
   (*_sxmChannelInfo).mChannelID =   presetString;
   //(*_sxmChannelInfo).mChannelID = replaceInTranslationTextID(Channel, strChannelID, "$(1:Number)").c_str();
   (*_sxmChannelInfo).mCategoryName = channelInfo.getCategoryName().c_str();
   (*_sxmChannelInfo).mSongTitle = channelInfo.getSongName().c_str();
   (*_sxmChannelInfo).mAdvisoryMessageVisibility = false;
   (*_sxmChannelInfo).mSxmInitialized = true;
   //Binding for PIVI Song - Artist
   (*_sxmChannelInfo).mSongTitleAndArtistName = (channelInfo.getSongName() + hifen + channelInfo.getArtistName()).data();
   (*_sxmTpopChannelInfo).mChannelName = channelInfo.getChannelName().c_str();
   (*_sxmTpopChannelInfo).mChannelID = replaceInTranslationTextID(Channel, strChannelID, "$(1:Number)").c_str();
   _sxmTpopChannelInfo.SendUpdate(true);

   _sxmChannelInfo.MarkAllItemsModified();
   _sxmChannelInfo.SendUpdate(true);
}


void SxmAudioDataBindingUtils::clearSxmChannelInfoData(void)
{
   (*_sxmChannelInfo).mChannelID = "";
   (*_sxmChannelInfo).mCategoryName = "";
   (*_sxmChannelInfo).mArtistName = "";
   (*_sxmChannelInfo).mSongTitle = "";
   (*_sxmChannelInfo).mChannelName = "";
   (*_sxmChannelInfo).mSxmCGVisibility = false;
   (*_sxmChannelInfo).mSxmAlbumartVisibility = false;
}


void SxmAudioDataBindingUtils::setAdvisoryText(std::string advisoryMessage)
{
   (*_sxmChannelInfo).mAdvisoryMessage = advisoryMessage.c_str();
   (*_sxmChannelInfo).mSxmInitialized = true;
   updateAdvisoryMessage();
}


void SxmAudioDataBindingUtils::setAdvisoryText(Candera::String advisoryMessage)
{
   ETG_TRACE_USR4(("SxmAudioDataBindingUtils::setAdvisoryText"));
   (*_sxmChannelInfo).mSxmInitialized = true;
   (*_sxmChannelInfo).mAdvisoryMessage = advisoryMessage;
   updateAdvisoryMessage();
}


void SxmAudioDataBindingUtils::setGadgetAdvisoryText(Candera::String advisoryMessage)const
{
}


//
//
///**
// * Helper function to update advisory message
// */
void SxmAudioDataBindingUtils::updateAdvisoryMessage()
{
   ETG_TRACE_USR4(("SxmAudioDataBindingUtils::updateAdvisoryMessage _isPresetListAvail:%d _isAllChannelInfoAvail:%d, (*_sxmChannelInfo).mSxmInitialized:%d", _isPresetListAvail, _isAllChannelInfoAvail, (*_sxmChannelInfo).mSxmInitialized));
}


void SxmAudioDataBindingUtils::setSystemMessageStatus(uint8 u8status)
{
   _systemErrorCode = u8status;
}


/**
* Helper Function to have synchronized access to FeatStd::String via GetCString interface
*
* param[in] : textId - text id of the string
* @return    : string after conversion
*/
std::string SxmAudioDataBindingUtils::safeGetCString(unsigned int textId)
{
   FeatStd::String safestring = Candera::String(textId);  //get a text via text id
   std::string formatedString;
   formatedString.clear();
   SECURE_FEATSTD_STRING_ACCESS_BEGIN(safestring);
   formatedString = safestring.GetCString();
   SECURE_FEATSTD_STRING_ACCESS_END()
   return formatedString;
}


std::string SxmAudioDataBindingUtils::replaceInTranslationTextID(std::string TranslationStr, std::string StrForReplace, std::string strToSearch)
{
   if (TranslationStr.find(strToSearch) != std::string::npos)
   {
      TranslationStr.replace(TranslationStr.find(strToSearch), strToSearch.size(), StrForReplace);
   }
   return TranslationStr;
}


//void SxmAudioDataBindingUtils::updateSXMPresets(StructPrestList&/*::std::vector<std::string>&*/ rfoPresetList)
void SxmAudioDataBindingUtils::updateSXMPresets(std::vector<StructPrestList>& rfoPresetList)
{
   ETG_TRACE_USR4(("SxmAudioDataBindingUtils::updateSXMPresets %d", rfoPresetList.size()));
   Candera::String* pTunerPresetState[20] =
   {
      &((*_sxmPresetInfo).mPSName1),
      &((*_sxmPresetInfo).mPSName2),
      &((*_sxmPresetInfo).mPSName3),
      &((*_sxmPresetInfo).mPSName4),
      &((*_sxmPresetInfo).mPSName5),
      &((*_sxmPresetInfo).mPSName6),
      &((*_sxmPresetInfo).mPSName7),
      &((*_sxmPresetInfo).mPSName8),
      &((*_sxmPresetInfo).mPSName9),
      &((*_sxmPresetInfo).mPSName10),
      &((*_sxmPresetInfo).mPSName11),
      &((*_sxmPresetInfo).mPSName12),
      &((*_sxmPresetInfo).mPSName13),
      &((*_sxmPresetInfo).mPSName14),
      &((*_sxmPresetInfo).mPSName15),
      &((*_sxmPresetInfo).mPSName16),
      &((*_sxmPresetInfo).mPSName17),
      &((*_sxmPresetInfo).mPSName18),
   };

   for (tU8 u8Index = 0; (u8Index < rfoPresetList.size()) && (u8Index < 20); ++u8Index)
   {
      ETG_TRACE_USR4(("SxmAudioDataBindingUtils::updateSXMPresets loop %d", u8Index));
      ETG_TRACE_USR4(("SxmAudioDataBindingUtils::updateSXMPresets idx %d value %s", rfoPresetList[u8Index].idx, rfoPresetList[u8Index].pName.c_str()));
      *pTunerPresetState[rfoPresetList[u8Index].idx] = (Candera::String)rfoPresetList[u8Index].pName.c_str();
      //*pTunerPresetState[u8Index] = (Candera::String)rfoPresetList[u8Index].pName.c_str();
      //*pTunerPresetState[rfoPresetList] = (Candera::String)rfoPresetList[rfoPresetList.pName].c_str();
      // ETG_TRACE_USR4(("SxmAudioDataBindingUtils::updateSXMPresets %s",rfoPresetList[u8Index].c_str() ));
   }

   _sxmPresetInfo.SendUpdate(true);
   _sxmPresetInfo.MarkAllItemsModified();
}


void SxmAudioDataBindingUtils::setSxmChannelNumber(std::string channelNo)
{
   /*  (*_sxmChannelInfo).mChannelID = channelNo;
    _sxmChannelInfo.SendUpdate(true);
    _sxmChannelInfo.MarkAllItemsModified();*/
}


void SxmAudioDataBindingUtils::SxmUpdateAntennaStatus(uint8 enAntennaStatus)
{
   char szStatusText[3] = { 0 };
   sprintf(szStatusText, "%%%d", enAntennaStatus);
   ETG_TRACE_USR3(("SxmAudioDataBindingUtils::Antenna Status == %d", enAntennaStatus));

   if (enAntennaStatus == 0)
   {
      (*_sxmAntennaInfo).mAntennaStatus = "";
   }
   else
   {
      (*_sxmAntennaInfo).mAntennaStatus = (Candera::String)szStatusText;
   }
   _sxmAntennaInfo.MarkAllItemsModified();
   _sxmAntennaInfo.SendUpdate(true);
}


}  // namespace Core
}  // namespace App
