/**************************************************************************************
* @file         : HealthcareUtility.h
* @author       : heena Mathew
* @brief        : Symbolic constants used across the healthcare application is defined.
* @copyright    : Copyright (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef HEALTHCAREUTILITY_HEADER
#define HEALTHCAREUTILITY_HEADER
#include "asf/core/Types.h"
#include <string>
#include "CanderaWidget/String/String.h"
#include "HealthCareTestMode.h"
#include "bosch/cm/ai/HealthcareMonServiceClientBase.h"
#include<sstream>

namespace App {
namespace Core {
class HealthcareUtility
{
   public:
      HealthcareUtility();
      virtual ~HealthcareUtility();

      static std::string u32ConversionTohexString(uint32 u32Value);
      static std::string u16TextidConversionTohexString(uint16 u16Value);
      static std::string u8ConversionTohexString(uint8 u8Value);
      static std::string enumConversionToString(::bosch::cm::ai::HealthcareMonService::enDevID _DevID);
};


}
}


#endif


/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
