/**************************************************************************************
* @file         : HealthCareTestMode.cpp
* @author       : RBEI/ECG5-INF4CV_Team
* @addtogroup   : AppHmi_TestMode
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
*17.06.21 Rev. 0.1 Sheena Mathew (RBEI/ECH2)
* 		  			Initial Revision.
**************************************************************************************/

#include "hall_std_if.h"
#include "HealthCareTestMode.h"
#include "AppBase/StartupSync/StartupSync.h"
#include "App/Core/HealthCareTestMode/HealthcareUtility.h"
#include "ProjectBaseMsgs.h"
#include "hmi_trace_if.h"

#include "App/Core/HmiTranslation_TextIds.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TESTMODE_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TESTMODE
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Testmode_"
#define ETG_I_FILE_PREFIX                 App::Core::HealthCareTestMode::
#include "trcGenProj/Header/HealthCareTestMode.cpp.trc.h"
#endif

using namespace ::bosch::cm::ai::HealthcareMonService;


namespace App {
namespace Core {

HealthCareTestMode* HealthCareTestMode::_HealthCareTestMode = NULL;

HealthCareTestMode::HealthCareTestMode():
   _HealthcareProxy(::HealthcareMonServiceProxy::createProxy("HealthcareMonServerPort", *this))

{
   ETG_I_REGISTER_FILE();
   if (_HealthcareProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _HealthcareProxy->getPortName());
      ETG_TRACE_USR4(("HealthCareTestMode Constructor after creating proxy"));
   }
}


HealthCareTestMode::~HealthCareTestMode()
{
   ETG_TRACE_USR4(("HealthCareTestMode destructor is called"));
}


void HealthCareTestMode::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (_HealthcareProxy && (proxy == _HealthcareProxy))
   {
      ETG_TRACE_USR4(("HealthCareTestMode registerProperties inside is called"));
      _HealthcareProxy->sendSig_ShowDTCPopupRegister(*this);
   }
}


void HealthCareTestMode::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   if (_HealthcareProxy && (proxy == _HealthcareProxy))
   {
      ETG_TRACE_USR4(("HealthCareTestMode deregisterProperties inside is called"));
      _HealthcareProxy->sendSig_ShowDTCPopupDeregisterAll();
   }
}


void HealthCareTestMode::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("HealthCareTestMode Service onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


void HealthCareTestMode::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("HealthCareTestMode Service onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


void HealthCareTestMode::onSendAcknowldgementError(const ::boost::shared_ptr< HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& /*proxy*/, const ::boost::shared_ptr< HEALTHCARE_CONTROL::SendAcknowldgementError >& /*error*/)
{
}


void HealthCareTestMode::onSendAcknowldgementResponse(const ::boost::shared_ptr< HEALTHCARE_CONTROL::HealthcareMonServiceProxy >& /*proxy*/, const ::boost::shared_ptr< HEALTHCARE_CONTROL::SendAcknowldgementResponse >& response)
{
   ETG_TRACE_USR4(("HealthCareTestMode onSendAcknowldgementResponse value %d ", response->getResponse()));
}


void HealthCareTestMode::onSig_ShowDTCPopupError(const ::boost::shared_ptr< HealthcareMonServiceProxy >&  proxy, const ::boost::shared_ptr< Sig_ShowDTCPopupError >& error)
{
}


void HealthCareTestMode::onSig_ShowDTCPopupSignal(const ::boost::shared_ptr< HealthcareMonServiceProxy >& proxy, const ::boost::shared_ptr< Sig_ShowDTCPopupSignal >& signal)
{
   ETG_TRACE_USR4(("HealthCareTestMode::onSig_ShowDTCPopupSignal Service is called _HealthcareProxy"));

   if (proxy == _HealthcareProxy)
   {
      _HCM.deviceNum = signal->getDev_Nr();
      _HCM.dtcCode = signal->getDtcCode();
      _HCM.textID  = signal->getText_ID();//text id is in 6912 has to be converted to hex i.e
      _DevID = signal->getDev_ID();
      _HCM.defaultText = signal->getDefault_Text();
      _HCM.textIDstr = HealthcareUtility::u16TextidConversionTohexString(signal->getText_ID()); //6912 -->converted to hex(I.E 1b00) and appended with Text_ID --> combined with TextId_0x1b00
      _HCM.deviceNumstr = HealthcareUtility::u8ConversionTohexString(_HCM.deviceNum);
      _HCM.devIDstr = HealthcareUtility::enumConversionToString(_DevID);
      _HCM.dtcCodestr = HealthcareUtility::u32ConversionTohexString(_HCM.dtcCode);
      ETG_TRACE_USR4(("HealthCareTestMode::onSig_ShowDTCPopupSignaldevice id ::%d\n,Text_ID::%d\n, dtcCode ::%d\n,  deviceNum :: %d\n", _DevID, _HCM.textID, _HCM.dtcCode, _HCM.deviceNum));
      ETG_TRACE_USR4(("HealthCareTestMode::onSig_ShowDTCPopupSignal defaulttext:: %s", _HCM.defaultText.c_str()));
      ETG_TRACE_USR4(("HealthCareTestMode::onSig_ShowDTCPopupSignal dtcCode string: %s ", _HCM.dtcCodestr.c_str()));
      UpdatePopupTextReqMsg(_HCM);
   }
}


void HealthCareTestMode::UpdatePopupTextReqMsg(stHealthCareData& _healthCareData)
{
   std::vector<std::string> list;

   if (!(list.empty()))
   {
      list.clear();
   }
   (*oHealthCareMonitorDTCinfo).mHCMDTCline1 = "";
   (*oHealthCareMonitorDTCinfo).mHCMDTCline2 = "";
   (*oHealthCareMonitorDTCinfo).mHCMDTCline3 = "";

   ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg _healthCareData.textID=%d ", _healthCareData.textID));

   if (_healthCareData.textID == 0)	//HEALTHCAREMONAPPHealthcaremon 1
   {
      if (!_healthCareData.defaultText.empty())
      {
         const Candera::String DATA_CONTEXT_DEFAULTTEXT_SECONDLINE = Candera::String(_healthCareData.defaultText.c_str());
         (*oHealthCareMonitorDTCinfo).mHCMDTCline1 = "";
         (*oHealthCareMonitorDTCinfo).mHCMDTCline2 = DATA_CONTEXT_DEFAULTTEXT_SECONDLINE;
         (*oHealthCareMonitorDTCinfo).mHCMDTCline3 = "";
         ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg defaulttext: %s", _healthCareData.defaultText.c_str()));
         ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg DATA_CONTEXT_DEFAULTTEXT_SECONDLINE: %s", DATA_CONTEXT_DEFAULTTEXT_SECONDLINE));
      }
      else //HEALTHCAREMONAPPHealthcaremon 3
      {
         list.push_back(_healthCareData.dtcCodestr);
         list.push_back(_healthCareData.devIDstr);
         std::string combinedTextstring = boost::algorithm::join(list, " :: ");
         const Candera::String DATA_CONTEXT_COMBINEDTEXT_SECONDLINE = Candera::String(combinedTextstring.c_str());
         (*oHealthCareMonitorDTCinfo).mHCMDTCline1 = "";
         (*oHealthCareMonitorDTCinfo).mHCMDTCline2 = DATA_CONTEXT_COMBINEDTEXT_SECONDLINE;
         (*oHealthCareMonitorDTCinfo).mHCMDTCline3 = "";
         ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg DtcCode: %s", _healthCareData.dtcCodestr.c_str()));
         ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg Dev_ID_str: %s", _healthCareData.devIDstr.c_str()));
         ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg combinedvalue: %s", combinedTextstring.c_str()));
      }
   }
   else //HEALTHCAREMONAPPHealthcaremon 2
   {
      ETG_TRACE_USR4(("HealthCareTestMode::UpdatePopupTextReqMsg _healthCareData.textIDstr.c_str() =%s", _healthCareData.textIDstr.c_str()));
      FeatStd::TextId languagestr(_healthCareData.textIDstr.c_str());
      (*oHealthCareMonitorDTCinfo).mHCMDTCline1 = "";
      (*oHealthCareMonitorDTCinfo).mHCMDTCline2 = Candera::String(languagestr);
      (*oHealthCareMonitorDTCinfo).mHCMDTCline3 = "";
   }

   oHealthCareMonitorDTCinfo.MarkAllItemsModified();
   oHealthCareMonitorDTCinfo.SendUpdate(true);
   POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("Testmode#Popup#Pfo_HealthCareMntr_DiagCtnrlTrouble"))));
}


bool HealthCareTestMode::onCourierMessage(const HealthCareMntrDTCMsg& oMsg)
{
   bool healthCareAckStatus = oMsg.GetHealthCareMntrDTCack();
   ETG_TRACE_USR4((" HealthCareTestMode::onCourierMessage(const HealthCareMntrDTCMsg& oMsg) healthCareAckStatus%d", healthCareAckStatus));
   if (HCMDTC_YES == healthCareAckStatus)
   {
      ETG_TRACE_USR4((" HealthCareTestMode::onCourierMessage(const HealthCareMntrDTCMsg& oMsg) HCMDTC_YES%d", HCMDTC_YES));
      POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Hide, Courier::ViewId("Testmode#Popup#Pfo_HealthCareMntr_DiagCtnrlTrouble"))));
      _HealthcareProxy->sendSendAcknowldgementRequest(*this, _DevID,  _HCM.deviceNum, _HCM.dtcCode, healthCareAckStatus);
   }
   return true;
}


}//namespace
}//App
