/**************************************************************************************
 * @file         :NACVdemo.h
 * @author       :ECV4-Sreelekshmi Gopakumar
 * @addtogroup   :VehicleSDSFocusHandler HALL
 * @brief        :
 * @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef NACVDEMO_H_
#define NACVDEMO_H_

/* #ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_01_if.h"
#include "dp_generic_if.h"
#endif */


#include "asf/core/Types.h"
#include "AppHmi_TestmodeStateMachine.h"
#include "Midw_Diagnostics_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "CgiExtensions/DataBindingItem.hpp"
//#include "AppHmi_MasterMessages.h"
#include "asf/core/Timer.h"
#include <AppUtils/Timer.h>
#include "SystemSettingTestMode.h"
#include "AppHmi_TestmodeTypes.h"

namespace App {
namespace Core {

/*enum TestScreen
{
   NoTestScreen = 0x00,
   PlainWhite = 0x01,
   PlainBlack = 0x02,
   PlainRed = 0x03,
   PlainGreen = 0x04,
   PlainBlue = 0x05,
   Coloured = 0x06,
   FlickerTest = 0x07,
   TestMark = 0x08,
   RGB_Nok = 0x10,
   RGB_Ok = 0x11,
   RGB_repDark = 0x12,
   DotDet_01 = 0x20,
   DotDet_02 = 0x21,
   DotDet_03 = 0x22,
   DotDet_04 = 0x23,
   DotDet_05 = 0x24,
   DotDet_06 = 0x25,
   DotDet_07 = 0x26,
   DotDet_08 = 0x27,
   DotDet_09 = 0x28,
   DotDet_10 = 0x29,
   DotDet_11 = 0x2A,
   DotDet_12 = 0x2B,
   DotDet_13 = 0x2C,
   DotDet_14 = 0x2D,
   DotDet_15 = 0x2E,
   DotDet_16 = 0x2F,
   DotDet_17 = 0x30,
   DotDet_18 = 0x31,
   DotDet_19 = 0x32,
   DotDet_20 = 0x33,
   DotDet_21 = 0x34,
   DotDet_22 = 0x35,
   DotDet_23 = 0x36,
   DotDet_24 = 0x37,
   DotDet_25 = 0x38,
   DotDet_26 = 0x39,
   DotDet_27 = 0x3A,
   DotDet_28 = 0x3B,
   FLIP_HDUV = 0x40,
   POINT1BMP = 0x5D,
   POINT2BMP = 0x5E,
   POINT3BMP = 0x5F,
   POINT4BMP = 0x60,
   POINT5BMP = 0x61,
   TEFSpecial1 = 0x92 //NAC Test Screens
};*/

class NACVdemo :
   public ::hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public Midw_Diagnostics_FI::SetDisplayCallbackIF
   , public Sig_ActivateContextCallbackIF

{
   protected:
      /*virtual bool onCourierMessage(const Start_Download& msg);
      virtual bool onCourierMessage(const TimerExpiredMsg& msg);*/
      //void vHandleTraceMessage(const tUChar* puchData) ;

   public:
      NACVdemo();
      static NACVdemo* getInstance();
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      SystemSettingTestMode* testmode;

      bool onCourierMessage(const NACTimerExpiryMsg&);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TESTMODE_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(NACTimerExpiryMsg)
      COURIER_MSG_MAP_DELEGATE_END()

      static void deleteInstance();

      virtual ~NACVdemo();
      // DataBindingItem<DownloadTextVisibityDataBindingSource> oDownloadTextVisibity;
      /**
       * This function is used to register for property updates from middleware layer
       * The status and error updates, the method results and method errors can be
       * received only if registration for corresponding updates is done using this function
       *
       * @param[in] - proxy       - shared pointer for client side representation of a service,
       * @param[in] - statechange - The proxy can only be used if the service state equals "ServiceState__Available".
       *                            When the state is "ServiceState Disconnected" and "ServiceState__Suspended",
       *                            the service is not usable
       * @param[out]- returns void
       */
      void registerProperties(const boost::shared_ptr< asf::core::Proxy >& proxy,	const asf::core::ServiceStateChange& stateChange);

      /**
       * This funtion is used to unregister for property updates from middleware layer
       *
       * @param[in] - proxy       - shared pointer for client side representation of a service,
       * @param[in] - statechange - The proxy can only be used if the service state equals "ServiceState__Available".
       *                            When the state is "ServiceState Disconnected" and "ServiceState__Suspended",
       *                            the service is not usable
       * @param[out]- returns void
       */
      void deregisterProperties(const boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      //DiagConfigCallbackIF call back functions
      virtual void onSetDisplayError(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::SetDisplayError >& error);

      virtual void onSetDisplayStatus(const ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< Midw_Diagnostics_FI::SetDisplayStatus >& status);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      /**
        * Getter function to read the Diagnostics DP value at startup
        * @return DPDatapool value
        */
      uint8 getDiagDpValue();
      void showStartupVideo();
      void showText();
      void startPresetTimer();

      void totest(int i);
      void setNACTimer();
      void stopNACTimer();
      void recallNACScreen();

      int updateReceived;
      bool _downloadStarted ;
   private:
      ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy> _diagProxy;
      void downloadTimer();
      unsigned int _nacScreenIndex;

      //Updating the Config Item to Diag
      static NACVdemo* _mNACVdemo;
      ::Util::Timer _NACTimer;
      ::Util::Timer* _screenTimer;
      ::Util::Timer* _screenDownloadTimer;
      inline ::Util::Timer* getTimer()
      {
         return _screenTimer;
      }
      void deleteTimer(::Util::Timer* ptr);
      //bool startTimer( int timeValue , ::Util::Timer* ptr);
      void startTimer(int timeValue , int whichTimer);

      asf::core::Timer m_oTimerSlider;
      DECLARE_CLASS_LOGGER();
};


}
}


#endif
