/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_SystemMessages.h"
// the views
#include "CGIAppViewController_System.h"

#include<iostream>
using namespace std;


SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_AS),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_AS_SpeedDepVol),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_AS_EqlPrst),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_AS_PrivateMode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_CS_Manual),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_CS_DateFmt),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_DTCInformation),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_ConfigurationVersion),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_SysSettings_CA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_GlassSettings_CA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_VideoMixSource_CA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_AudioSettings_CA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_SysSettings_CB),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_DS),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_BS),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_OSS),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_LS_EU),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SystemSettings),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SW_screen_1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_screen_3),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_screen_4),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_screen_5),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_screen_6),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Busy_screen),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SoftwareVersionFetchingError),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_two_line_single_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_two_line_two_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_three_line_single_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_three_line_three_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_three_line_two_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Popup_Four_line_single_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_five_line_double_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_six_line_two_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_PopUp_three_line_single_reboot_button),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_MIS_SystemUpdate_Progress),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Stage_1_MIS_SystemUpdate),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SysSetFactDefault),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_three_line_two_button_Swivel_GS_CA), ////GSpopup
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_three_line_Swivel_GS_CA), ////GSpopup
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SysSetFactReset),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SysSetSupplierReset),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_CabinAMonConnection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SpeedLock_CP),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SwivelCalibration),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SysInst_SubSys_Unavailable),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_SystemInstallation),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_SO_OEM_PIN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pin_Layout),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_S_Pfo_2LineAbortStage2),

                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   cout << "Courier::View* CGIAppViewFactory::Create" << sViewName << endl;
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   cout << "Courier::View* CGIAppViewFactory::Destroy" << pView << endl;
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   cout << "Courier::ViewController* CGIAppViewControllerFactory::Create" << sViewName << endl;
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   cout << "CGIAppViewControllerFactory::Destroy" << viewController << endl;
   COURIER_UNUSED(viewController);
}
