/* ***************************************************************************************
* FILE:          CGIAppController.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "AppHmi_SystemStateMachine.h"
#include "CGIAppController.h"
#include "CabinAGlassSettingListhandler.h"
#include "CabinASettingListhandler.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"
#include "App/Core/AppLogic/RVCSettingListHandler/RVCSettingListHandler.h"
#include "App/Core/AppLogic/OEM/OEMmenu.h"
#include "App/Core/ClientHandler/HmiState/HmiStateHandler.h"
#include "App/Core/ClientHandler/CabinInfoSrvClient/CabinInfoSrvClient.h"


#include "hmi_trace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_MAIN
#include "trcGenProj/Header/CGIAppController.cpp.trc.h"
#endif

#define HARDKEYSTATE_LONGPRESS 3
#define HARDKEYSTATE_RELEASE 2
#define HARDKEYSTATE_SHORTPRESS 1

using namespace ::spm_core_fi_types;

/********************************************
 NAME    : CGIAppController
 SYSFL    : SYSFL-4698, SYSFL-4699, SYSFL-4700
****************************************************/

bool CGIAppController::onCourierMessage(const HKStatusChangedUpdMsg& msg)
{
   bool retVal = false;
   int m_Hkcode = msg.GetHKCode();
   hmibase::HardKeyStateEnum hardkeyState = msg.GetHKState();
   bool inStageOneUpdate = App::Core::SWUpdate::GetInstance()->getStageOneUpdateOnGoingStatus();
   bool SystemInstallationActiveStatus = App::Core::OEMmenu::poGetInstance()->getSystemInstallationActiveStatus();
   bool RVCActivestatus = App::Core::RVCSettingListHandler::poGetInstance()->getRVCActivestatus();
   uint8 HMIState = App::Core::HmiStateHandler::poGetInstance()->GetHmiState();
   ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg when in stage one update: %d ", inStageOneUpdate));
   ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg RVCActivestatus: %d ", RVCActivestatus));
   if (inStageOneUpdate)
   {
      retVal = true;
      ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg msg is consumed:retVal %d ", retVal));
   }
   else if (SystemInstallationActiveStatus)
   {
      ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg return true SystemInstallationActiveStatus: %d ", SystemInstallationActiveStatus));
      retVal = true;
   }
   else if (RVCActivestatus)
   {
      ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg RVCActivestatus: %d ", RVCActivestatus));
      retVal = true;
      ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg retVal: %d ", retVal));
   }
   else
   {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      bool glasstatus = App::Core::CabinInfoSrvClient::poGetInstance()->getglassAvailablityInfoStatusCA();

      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg afterrrr glasstatus: %d ", glasstatus));
#endif

      POST_MSG((COURIER_MESSAGE_NEW(ClonedHKStatusMsg)(m_Hkcode, hardkeyState)));

      ETG_TRACE_USR4(("CGIAppController: HKStatusChangedUpdMsg HKCode: %d %d", m_Hkcode, hardkeyState));
      if (m_Hkcode == HARDKEYCODE_HK_MCP_MON_CABIN)
      {
         if (HMIState != T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE)
         {
            if (hardkeyState == HARDKEYSTATE_LONGPRESS || hardkeyState == HARDKEYSTATE_RELEASE || hardkeyState == HARDKEYSTATE_SHORTPRESS)
            {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
               ETG_TRACE_USR4(("CGIAppController: calling CheckPopupActive extSm_MonConnectionStatus=%d glasstatus=%d", extSm_MonConnectionStatus, glasstatus));

               if (glasstatus == false)
               {
                  if (extSm_MonConnectionStatus == 0)
                  {
                     ETG_TRACE_USR4(("CGIAppController: Popup monitor connecection INactive"));
                     POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_CabinAMonConnection"))));
                  }
               }
               else
               {
                  ETG_TRACE_USR4(("CGIAppController: Popup monitor connecection AUTO MANUAL "));
                  App::Core::CabinAGlassSettingListhandler::poGetInstance()->CheckPopupActive(hardkeyState);
                  POST_MSG((COURIER_MESSAGE_NEW(HKStatusChangedUpdMsg)()));
               }
               retVal = true;
#endif
            }
         }
      }
      else
      {
         retVal = CGIAppControllerProject::onCourierMessage(msg);
      }
   }
   ETG_TRACE_COMP(("CGIAppController: HKStatusChangedUpdMsg msg is outside consumed:retVal %d ", retVal));
   return retVal;
}


// ------------------------------------------------------------------------
bool CGIAppController::onCourierMessage(const EncoderStatusChangedUpdMsg& msg)
{
   bool retval = false;
   bool inStageOneUpdate = App::Core::SWUpdate::GetInstance()->getStageOneUpdateOnGoingStatus();
   if (inStageOneUpdate == true)
   {
      retval = true;
      ETG_TRACE_COMP(("EncoderStatusChangedUpdMsg& retval=%d", retval));
   }
   else
   {
      retval = CGIAppControllerProject::onCourierMessage(msg);
      ETG_TRACE_COMP(("EncoderStatusChangedUpdMsg& retval=%d", retval));
   }
   ETG_TRACE_COMP(("EncoderStatusChangedUpdMsg& retval=%d", retval));
   return retval;
}


bool CGIAppController::onCourierMessage(const RenderingCompleteMsg& msg)
{
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
   App::Core::CabinASettingListhandler::poGetInstance()->getActiveView(msg.GetViewName().GetCString());
#endif
   return false;
}
