/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        SystemDataPoolConfig.cpp
 * @brief       SystemDataPoolConfig is to handle logic implementation of datapool(system app) properties.
 * @author      Sathiya Jayanth - INF4CV
 * @copyright   (c) 2018-2018 Robert Bosch Car Multimedia GmbH
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#include "hall_std_if.h"
#include "SystemDataPoolConfig.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 SystemDataPoolConfig::
#include "trcGenProj/Header/SystemDataPoolConfig.cpp.trc.h"
#endif

namespace App {
namespace Core {
//namespace SystemDataPool {

static SystemDataPoolConfig* _mDpSystem = NULL;

/**
 * @Constructor
 */
SystemDataPoolConfig::SystemDataPoolConfig()
{
   ETG_TRACE_USR4(("IN SystemDataPoolConfig CTOR"));
   DP_vCreateDatapool();
   /*  _languageIndex = 0;
     _CurrentMeasurementUnit = 0;
     _BrightnesslevelDayMode = 5;
     _BrightnesslevelNightMode = 5;
     _Systemlockstatus = 1;
     _BeepStatus = 0;*/
}


/**
 * @Destructor
 */
SystemDataPoolConfig::~SystemDataPoolConfig()
{
   ETG_TRACE_USR4(("IN SystemDataPoolConfig DTOR"));
}


/**
 * @createInstance
 */
void SystemDataPoolConfig::createInstance()
{
   if (NULL == _mDpSystem)
   {
      _mDpSystem = new SystemDataPoolConfig();
      ETG_TRACE_USR4(("Create Instance for Data Pool"));
   }
}


void SystemDataPoolConfig::deleteInstance()
{
   SYS_DELETE_CLASS(_mDpSystem)
}


/**
 * readInitialSettings
 * @param[in] None
 * @return None
 */
/*
void SystemDataPoolConfig::readInitialSettings()
{
   ETG_TRACE_USR4(("In Reading InitialSettings"));
   _languageIndex = static_cast<uint8>(_mDpLanguageStatus.tGetData());
   _CurrentMeasurementUnit = static_cast<uint8>(_mSystemCurrentMeasUnit.tGetData());
   _BrightnesslevelDayMode = static_cast<uint8>(_mBrightnessLevelDayMode.tGetData());
   _BrightnesslevelNightMode = static_cast<uint8>(_mBrightnessLevelNightMode.tGetData());
   _Systemlockstatus = static_cast<uint8>(_mSystemSpeedLockStatus.tGetData());
   _BeepStatus = static_cast<bool>(_mDpBeepToneStatus.tGetData());
}*/


/**
 * @getInstance
 */
SystemDataPoolConfig* SystemDataPoolConfig::getInstance()
{
   ETG_TRACE_USR4(("In getInstance"));
   createInstance();
   return _mDpSystem;
}


/**
 * setDpLanguageValue - To set system language persistence value
 * @param[in]     : languageReceived
 * @param[out]    : None
 * @return        : None

void SystemDataPoolConfig::setDpLanguageValue(const uint8 languageReceived)
{
   ETG_TRACE_USR4(("IN setDpLanguageValue"));

   _languageIndex = languageReceived;
   _BeepStatus = languageReceived;
   _CurrentMeasurementUnit = languageReceived;
   _BrightnesslevelDayMode = languageReceived;
   _BrightnesslevelNightMode = languageReceived;
   _Systemlockstatus = languageReceived;

   _mDpLanguageStatus.vSetData(_languageIndex);
   _mSystemCurrentMeasUnit.vSetData(_CurrentMeasurementUnit);
   _mBrightnessLevelDayMode.vSetData(_BrightnesslevelDayMode);
   _mBrightnessLevelNightMode.vSetData(_BrightnesslevelNightMode);
   _mSystemSpeedLockStatus.vSetData(_languageIndex);
   _mDpBeepToneStatus.vSetData(_Systemlockstatus);
} */


/**
 * getDpLanguageValue - To get system language persistence value
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

uint8 SystemDataPoolConfig::getDpLanguageValue()
{
   ETG_TRACE_USR4(("Returning language index"));
   return _languageIndex;
}


*/

/**
 * getDpBeepToneStatus - To get system Beep Tone status persistence value
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

bool SystemDataPoolConfig::getDpBeepToneStatus()
{
   ETG_TRACE_USR4(("Returning Beep Status"));
   return _BeepStatus;
} */


/**
 * getDpSystemCurrentMeasurementUnit - To get system Current Measurement Unit
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

uint8 SystemDataPoolConfig::getDpSystemCurrentMeasurementUnit()
{
   return _CurrentMeasurementUnit;
} */


/**
 * getDpBrightnessLevelDayMode - To get system Brightnesslevel in Day Mode
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

uint8 SystemDataPoolConfig::getDpBrightnessLevelDayMode()
{
   return _BrightnesslevelDayMode;
} */


/**
 * getDpBrightnessLevelNightMode - To get system Brightnesslevel in Night Mode
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

uint8 SystemDataPoolConfig::getDpBrightnessLevelNightMode()
{
   return _BrightnesslevelNightMode;
} */


/**
 * getDpSpeedLockStatus - To get system Speed Lock Status
 * @param[in]     : None
 * @param[out]    : None
 * @return        : uint8

uint8 SystemDataPoolConfig::getDpSpeedLockStatus()
{
   return _Systemlockstatus;
} */


/* New Data POOL Concept */
/**
 * Description     : function called to get radio text on/off from datapool
 *
 * @param[in]      : none
 * @return         : bool
 */
uint8 SystemDataPoolConfig::getRVCBrightnessValue()
{
   dp_tclAppHmi_SystemRVC_BrightnessValue _mCurrentRVCBrightnessUnit;
   tU8 brightnessVal = 0;
   uint8 brightnessgetstat = 0;

   tS32 brightnessRetStatus = _mCurrentRVCBrightnessUnit.s32GetData(brightnessVal);
   brightnessgetstat = _mCurrentRVCBrightnessUnit.tGetData();
   ETG_TRACE_USR4(("SystemDataPoolConfig::getRVCBrightnessValue(brightnessRetStatus) %d", ((uint8)brightnessRetStatus)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::brightnessVal:%d", ((uint8)brightnessVal)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::brightnessgetstat%d", brightnessgetstat));

//return ((uint8)brightnessRetStatus);
//return ((uint8)brightnessVal);

   return brightnessgetstat;
}


/**
 * Description     : function called to set radio text on/off to datapool
 *
 * @param[in]      : rvcbrightnesvalue
 * @return         : void
 */
void SystemDataPoolConfig::setRVCBrightnessValue(uint8 rvcbrightnesvalue)
{
   ETG_TRACE_USR4(("SystemDataPoolConfig::setRadioTextStatus(setRVCBrightnessValue) %d", rvcbrightnesvalue));
   dp_tclAppHmi_SystemRVC_BrightnessValue _mCurrentRVCBrightnessUnit;
   tS32 s32rvcBritStatus = _mCurrentRVCBrightnessUnit.s32SetData((uint8)rvcbrightnesvalue);
   ETG_TRACE_USR3(("s32rvcBritStatus(%d)", (tU32)s32rvcBritStatus));
//  return s32rvcBritStatus;
}


/* New Data POOL Concept */
/**
 * Description     : function called to get radio text on/off from datapool
 *
 * @param[in]      : none
 * @return         : bool
 */

uint8 SystemDataPoolConfig::getRVCContrastValue()
{
   dp_tclAppHmi_SystemRVC_ContrastValue _mCurrentRVCContrastUnit;
   tU8 contrastVal = 0;
   uint8 contrastgetStat = 0;
   tS32 contrastRetStatus = _mCurrentRVCContrastUnit.s32GetData(contrastVal);

   contrastgetStat = _mCurrentRVCContrastUnit.tGetData();
   ETG_TRACE_USR4(("SystemDataPoolConfig::getRVCContrastValue(contrastRetStatus) %d", ((uint8)contrastRetStatus)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::contrastVal:%d", ((uint8)contrastVal)));

   ETG_TRACE_USR4(("SystemDataPoolConfig::contrastVal:%d", contrastgetStat));

//return ((uint8)contrastRetStatus);
// return ((uint8)contrastVal);

   return contrastgetStat;
}


/**
 * Description     : function called to set radio text on/off to datapool
 *
 * @param[in]      : rvcbrightnesvalue
 * @return         : void
 */
void SystemDataPoolConfig::setRVCContrastValue(uint8 rvccontrastvalue)
{
   ETG_TRACE_USR4(("SystemDataPoolConfig::setRVCContrastValue(setRVCContrastValue) %d", rvccontrastvalue));
   dp_tclAppHmi_SystemRVC_ContrastValue _mCurrentRVCContrastUnit;
   tS32 s32rvcContStatus = _mCurrentRVCContrastUnit.s32SetData((uint8)rvccontrastvalue);

   ETG_TRACE_USR3(("SystemDataPoolConfigs32rvcStatus s32rvcContStatus (%d)", (tU32)s32rvcContStatus));
   //return s32rvcContStatus;
}


uint16 SystemDataPoolConfig::getMICBeepVol()
{
   tU8 MicBeepVolVal = 0;
   uint8 DpMicBeepVolVal = 0;
   tS32 DpMicBeepVolValAckStatus = _MicBeepVolVal.s32GetData(MicBeepVolVal);
   DpMicBeepVolVal = _MicBeepVolVal.tGetData();
   ETG_TRACE_COMP(("SystemDataPoolConfig::getMICBeepVol DpMicBeepVolValAckStatus ((uint16)DpMicBeepVolVal):%d %d", ((uint8)DpMicBeepVolValAckStatus), ((uint16)DpMicBeepVolVal)));
   return ((uint16)DpMicBeepVolVal);
}


void SystemDataPoolConfig::setMICBeepVol(uint8 setMICBeepVol)
{
   tS32 DpMICBeepVolSetACKStatus = _MicBeepVolVal.s32SetData(setMICBeepVol);
   ETG_TRACE_COMP(("SystemDataPoolConfig::setMICBeepVol==>DpMICBeepVolSetACKStatus setMICBeepVol (%d) (%d)", (tU32)DpMICBeepVolSetACKStatus, setMICBeepVol));
}


/**
 * Description     : function called to get SWUpdate type value from datapool
 *
 * @param[in]      : none
 * @return         : bool
 */
uint8 SystemDataPoolConfig::getSWUpdateTypeValue()
{
   tU8 SWUpdateval = 0;
   uint8 SWUpdategetstatus = 0;
   tS32 SWUpdatevalRetStatus = _SWUpdateTypeValue.s32GetData(SWUpdateval);
   SWUpdategetstatus = _SWUpdateTypeValue.tGetData();
   ETG_TRACE_USR4(("SystemDataPoolConfig::getSWUpdateTypeValue(SWUpdatevalRetStatus) %d", ((uint8)SWUpdatevalRetStatus)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::SWUpdateval:%d", ((uint8)SWUpdateval)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::SWUpdategetstatus %d", SWUpdategetstatus));

   return SWUpdategetstatus;
}


/**
 * Description     : function called to set SWUpdate type value to datapool
 *
 * @param[in]      : swupdatetypevalue
 * @return         : void
 */
void SystemDataPoolConfig::setSWUpdateTypeValue(uint8 swupdatetypevalue)
{
   ETG_TRACE_USR4(("SystemDataPoolConfig::setRadioTextStatus(setSWUpdateTypeValue) %d", swupdatetypevalue));
   tS32 s32swupdatetypevalueStatus = _SWUpdateTypeValue.s32SetData((uint8)swupdatetypevalue);
   ETG_TRACE_USR3(("s32swupdatetypevalueStatus(%d)", (tU32)s32swupdatetypevalueStatus));
}


uint8 SystemDataPoolConfig::getETAStatus()
{
   tU8 ETAval = 0;
   uint8 ETAgetstatus = 0;
   tS32 ETAvalRetStatus = _etaStatus.s32GetData(ETAval);
   ETAgetstatus = _etaStatus.tGetData();
   ETG_TRACE_USR4(("SystemDataPoolConfig::getETAStatus(ETAvalRetStatus) %d", ((uint8)ETAvalRetStatus)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::ETAval:%d", ((uint8)ETAval)));
   ETG_TRACE_USR4(("SystemDataPoolConfig::ETAgetstatus %d", ETAgetstatus));

   return ETAgetstatus;
}


void SystemDataPoolConfig::setETAStatus(uint8 etaStatus)
{
   ETG_TRACE_USR4(("SystemDataPoolConfig::setETAStatus etaStatus=%d", etaStatus));
   tS32 s32etaStatus = _etaStatus.s32SetData((uint8)etaStatus);
   ETG_TRACE_USR3(("s32etaStatus(%d)", (tU32)s32etaStatus));
}


}
}


//}
