/**************************************************************************************
* @file         : <SWUpdateUtility.cpp>
* @author       : <Ramesh Kesavan> <ECV2> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "SWUpdateUtility.h"
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemStateMachine.h"
#include "CanderaWidget/String/String.h" //feat string
#ifndef GEN3X86
#ifndef DEBUG
#include "boost/date_time/posix_time/posix_time.hpp"
#endif
#endif
#endif
#include <time.h>
#include <stdio.h>
#include <cstdlib>
#include <math.h>

#include "utest/stubs/Middleware_Enum.h"

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
const uint8  TEXT_BUFFER_SIZE	= 10;
const uint64  LONG_TEXT_BUFFER_SIZE	= 64;
#endif
namespace App {
namespace Core {

/**
* @Constructor
*/
SWUpdateUtility::SWUpdateUtility()
{
}


/**
* @Destructor
*/
SWUpdateUtility::~SWUpdateUtility()
{
}


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
std::string SWUpdateUtility::getEstimatedTime(uint32 estimatedTime, uint8 item)
{
   uint32 hour = 0;
   uint32 min = 0;
   uint32 sec = 0;

   hour = estimatedTime / (60 * 60);
   estimatedTime -= (hour * 60 * 60);

   min = estimatedTime / 60;
   estimatedTime -= (min * 60);

   sec = estimatedTime;
   estimatedTime -= sec;

   std::string hours = ltoa(static_cast<uint64>(hour));
   std::string minutes = ltoa(static_cast<uint64>(min));
   std::string seconds = ltoa(static_cast<uint64>(sec));
   std::string estTime = hours + " hr " + minutes + " min " + seconds + " sec";
   std::string totaltime = "";

   switch (item)
   {
      case ESTIMATED_TOTAL_TIME:
      {
         totaltime = estTime;
      }
      break;
      case ESTIMATED_HOURS:
      {
         totaltime = hours;
      }
      break;
      case ESTIMATED_MINUTES:
      {
         totaltime = minutes;
      }
      break;
      default:
      {
         //to do nothing
      }
      break;
   }
   return totaltime;
}


/**
* itoa - Handle to convert from int16 to string
* @param[in] value
* @parm[out] none
* @return std::string
*/
std::string SWUpdateUtility::itoa(int16 value) const
{
   char itoa_txt[TEXT_BUFFER_SIZE];
   snprintf(itoa_txt, sizeof(itoa_txt), "%d", value);
   return (itoa_txt);
}


/**
* ltoa - Handle to convert from long long to string
* @param[in] value
* @parm[out] none
* @return std::string
*/
std::string SWUpdateUtility::ltoa(uint64 value) const
{
   char itoa_txt[LONG_TEXT_BUFFER_SIZE];
   snprintf(itoa_txt, sizeof(itoa_txt), "%llu", value);
   return (itoa_txt);
}


/**
* replaceInTranslationTextID - To find & replace text within a string
* @param[in] value
* @parm[out] none
* @return std::string
*/
std::string SWUpdateUtility::replaceInTranslationTextID(std::string TranslationStr, std::string StrForReplace, std::string strToSearch)
{
   if (TranslationStr.find(strToSearch) != std::string::npos)
   {
      TranslationStr.replace(TranslationStr.find(strToSearch), strToSearch.size(), StrForReplace);
   }
   return TranslationStr;
}


#endif


/**
* isSameVersion - To set isSameVersion's status depending upon the type of USB stick
* @param[in] value
* @parm[out] none
* @return bool
*/
bool SWUpdateUtility::isSameVersion(uint8 updateDirection)
{
   bool isSameVersion;
   isSameVersion = (updateDirection == Samegrade) ? true : false;
   return isSameVersion;
}


} // Namespace Core
} // Namespace App
