/**************************************************************************************
* @file         : <DisplayUtility.cpp>
* @author       : <Prashant Balaraj Ganappa> <ECH2> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "hmi_trace_if.h"
#endif

#include "../../AppLogic/DisplaySettings/DisplaySettings.h"
#include "DisplayUtility.h"

namespace App {
namespace Core {

/**
 * @Constructor
 */
DisplayUtility::DisplayUtility()
{
}


/**
 * @Destructor
 */
DisplayUtility::~DisplayUtility()
{
}


/**
*  getCurrentBrightnesValue- Handle to perform toggle on System Display Brightness Popup
* @param[in] int type, unsigned int value
* @parm[out] none
* @return unsigned int
*/
unsigned int DisplayUtility::getCurrentBrightnesValue(int type, unsigned int value)
{
   unsigned int brightnessValue = 0;
   if ((type == COLUMN_BUTTON_PLUS) && ((value < M_BRIGHTHIGHEST) && ((!value) || (value > 0))))
   {
      value++;
   }
   else if ((type == COLUMN_BUTTON_MINUS) && ((value > M_BRIGHTLOWEST) && (value <= 20)))
   {
      value--;
   }
   else
   {
#ifdef VARIANT_S_FTR_ENABLE_UNITTEST
      value = INVALID;
#endif
   }
   brightnessValue = value;
   return brightnessValue;
}


} // namespace Core
} // namespace App
