/************************************************************************
*FILE:			System_Types.h
*SW-COMPONENT: 	System_Types
*DESCRIPTION: 	Symbolic constants used across the settings application is defined.

*AUTHORS: 		Sheena Mathew

*COPYRIGHT: 	* Copyright (c) 2018-2020 Robert Bosch Car Multimedia GmbH
				* duplication and disclosure to third parties is prohibited.
*HISTORY:


************************************************************************/
#include "HmiTranslation_TextIds.h"

#ifndef SYSTEMTYPES_HEADER
#define SYSTEMTYPES_HEADER
//#define VARIANT_S_FTR_ENABLE_COACH_FEATURE
//#define VARIANT_S_FTR_ENABLE_AUX
//#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT
//#define VARIANT_S_FTR_ENABLE_NAVIGATION

namespace App {
namespace Core {
#define CLOCK_C_AM 1
#define CLOCK_C_PM 2
#define CLOCK_MODE12 1
#define CLOCK_MODE24 2
#define COCKPIT_REGION 2
#define CABIN_A_REGION 0
#define CABIN_B_REGION 1
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
const uint8  INVALID_FORMAT    			    = 0;
const uint8 MASK							= 0x77;

#define  STRING_NULL     '\0'
const uint8 MSP_SOUND_BASS					= 1;
const uint8 MSP_SOUND_TREBBLE				= 5;
const uint8 MSP_SOUND_BALANCE				= 9;
const uint8 MSP_SOUND_FADER					= 11;

const uint8 MSP_SOUND_MIN_VOLUME				= 93;
const uint8 MSP_SOUND_MAX_VOLUME				= 59;
const uint8 MSP_PRIVATE_MODE_MIX_VOLUME			= 95;

const uint8 MSP_SOUND_AUX 					= 20;
const uint8 MSP_SOUND_BEEPTONE			    = 21;

/** Bass setting with relative steps. Modifies property MSP_SOUND_BASS */
const uint8 MSP_SOUND_BASS_RELATIVE = 2;
/** Treble setting with relative steps. Modifies property MSP_SOUND_TREBLE */
const uint8 MSP_SOUND_TREBBLE_RELATIVE = 6;
/** Balance setting with relative steps. Modifies property MSP_SOUND_BALANCE */
const uint8 MSP_SOUND_BALANCE_RELATIVE = 10;
/** Fader setting with relative steps. Modifies property MSP_SOUND_FADER */
const uint8 MSP_SOUND_FADER_RELATIVE = 12;
const uint8 MSP_ENTSTARTUPMAXVOLUME_RELATIVE = 60; ////for max on vol
const uint8 MSP_ENTSTARTUPMINVOLUME_RELATIVE  = 94;  //for min on vol
#endif

const int INVALID            = 255;
// enum volumeupdate
// {
// BASS =0,
// TREBBLE,
// BALANCE,
// EQUILISERPRESET,
// SPDVOL,
// AUXLEVEL,
// BEEPTONES

// };

//define for Unused variables
#define HOME_UNUSED(_var_)     \
      (void)(_var_)

//Define for binding property all item update
#define DATA_BINDING_ALL_ITEM_UPDATE(_obj_, _flagname_)    \
      bool _flagname_ = false;                                 \
      _obj_.MarkAllItemsModified();                            \
      _flagname_ = _obj_.SendUpdate(true);                     \
      HOME_UNUSED(_flagname_); /*to avoid compiler warning: [-Wunused-but-set-variable] */

#if defined VARIANT_S_FTR_ENABLE_COACH_AUDIO
enum volumeupdate
{
   BASS = 0,
   TREBBLE,
   BALANCE,
   FADER,
   EQUILISERPRESET,
   SPDVOL,
   MINVOL,
   MAXVOL,
   PRIVATEMODMIXVOL,
   PRIVATEMODE,
   AUXLEVEL,
};


enum varianttype
{
   INF4CV_VARIANT = 0,
   CABIN_CONTORLLER_VARIANT,
};


enum cabinAGlassupdate
{
   CA_GAMMACORSET = 0,
   CA_CONTRAST,
   CA_BRIGHTNESS,
   CA_ASPECTRATIOMOD,
   CA_LCDPANELSET,
   CA_MONITORFLIPCNTRL,
   CA_SWIVELCALIB
};


#endif
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
enum cabinAvolumeupdate
{
   BASS_CA = 0,
   TREBBLE_CA,
   FADER_CA,
   MINVOL_CA,
   MAXVOL_CA,
   CABINMODMIXVOL_CA,
   MICBEEPVOL_CA
};


enum xmldtc
{
   dtc_availNotAvail = 0,
   dtc_codendstatus,
};


#endif
#if !defined VARIANT_S_FTR_ENABLE_COACH_AUDIO
enum volumeupdate
{
   BASS = 0,
   TREBBLE,
   BALANCE,
   FADER,
   EQUILISERPRESET,
   SPDVOL,
   MINVOL,
   MAXVOL,
   //PRIVATEMODMIXVOL,
   //PRIVATEMODE,
   AUXLEVEL,
   BEEPTONES = 13
};


enum cabinAGlassupdate
{
   CA_GAMMACORSET = 0,
   CA_CONTRAST,
   CA_BRIGHTNESS,
   CA_ASPECTRATIOMOD,
   CA_LCDPANELSET,
   CA_MONITORFLIPCNTRL,
   CA_SWIVELCALIB
};


#endif

enum clockupdate
{
   DateFormat = 0,
   TimeFormat,
   ClockSettingMode,
   Hour,
   Minute
};


enum gpsclockupdate
{
   GpsDateFormat = 0,
   GpsTimeFormat,
   GpsClockSettingMode,
   //Removed the DaylightSavingTime based on Bug 963829
   //GpsDayLightSavingTime,
   GpsTimeZone,
   GpsOffSetHours,
   GpsOffSetMinutes
};


enum MONkeystatus
{
   HARDKEYDOWN = 1,
   HARDKEYUP,
   HARDKEYLONGPRESS
};


#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
enum SystemMainUpdate
{
   SOUND_SETTING = 0,
   DISPLAY = 1,
   CLOCK = 2,
   LANGUAGE = 3,
   //SECURITYPIN = 5,
   OPENSOURCESOFTWARE = 6,
   RESETTOFACTORYSETTING,
   SOFTWAREVERSION,
   CONFIGURATION_VERSION,
   DATACARIERVERSION,
   SERIALNUMBER,
   STARTSOFTWAREUPDATE,
   SOFTWAREUPDATEHISTORY,
   BLUETOOTHSETTING,
   OEM_SETTING
};


enum SystemMainsubupdate
{
   SOUNDSETTING = 0,
   MEASUREMENTUNIT = 4,
   SPEEDLOCK = 5
};


#endif

#if !defined VARIANT_S_FTR_ENABLE_NAVIGATION
enum SystemMainUpdate
{
   SOUND_SETTING = 0,
   DISPLAY = 1,
   CLOCK = 2,
   LANGUAGE = 3,
   // SECURITYPIN = 6,
   OPENSOURCESOFTWARE = 4,
   RESETTOFACTORYSETTING,
   SOFTWAREVERSION,
   //DATACARIERVERSION,
   SERIALNUMBER,
   //STARTSOFTWAREUPDATE,
   SOFTWAREUPDATEHISTORY
};


enum SystemMainsubupdate
{
   SOUNDSETTING = 0,
   // MEASUREMENTUNIT = 4,
   //SPEEDLOCK = 5
};


#endif


enum Displayupdate
{
   e_BRIGHTNESS = 0,
   e_MODE
};


enum LanguageUpdate
{
   SNO = 0,
   LanguageStr,
   ServiceCode,
   TranStr,
   CultureReqCodeStr,
   Toggle
};


enum NaftaLanguageUpdate
{
   NaftaLang_SNO = 0,
   NaftaLang_LanguageStr,
   NaftaLang_ServiceCode,
   NaftaLang_TranStr,
   NaftaLang_CultureReqCodeStr,
   NaftaLang_Toggle
};


enum SystemmainUpdate
{
   Icon_normal = 0,
   Icon_pressed,
   SystemMain_text
};


enum CabinMainUpdate
{
   SOUNDSETTINGCA = 0,
   GLASSSETTINGCA,
   OPENSOURCESOFTWARECA,
   RESETTOFACTORYSETTINGCA
};


enum CabinAmainUpdate
{
   Icon_normal_ca = 0,
   Icon_pressed_ca,
   Icon_disbale_ca,
   CabinAMain_text,
   CabinAEnDisb_textimageflag
};


enum CabinBmainUpdate
{
   Icon_normal_cb = 0,
   Icon_pressed_cb,
   CabinBMain_text
};


enum clocksetting
{
   ClockModeString = 0,
   ClockMode,
   EnableStatus,
   PositionStatus
};


enum GpsClkclocksetting
{
   GpsClkClockModeString = 0,
   GpsClkClockMode,
   GpsClkEnableStatus,
   GpsClkPositionStatus
};


enum RVCsetting
{
   BRIGHTNESS = 0,
   CONTRAST,
   GUIDELINES
};


enum SWVersion
{
   OVERALL_SWVERSION = 0,
   CMC_SWVERSION,
   SUBSYSTEM_INDEX
};


enum MICsetting
{
   MIC_BASS = 0,
   MIC_TREBBLE
};


enum OEM_Menu
{
   RESET_TO_FACTORY = 0,
   SYSTEM_INSTALLATION,
   MONITOR_FLIP_CALIBRATION
};


enum Variant_Type
{
   NAVI = 0,
   NON_NAVI
};


enum Region
{
   EUR = 0,
   NAM,
   TUR,
   ISR,
   GCC,
   RES, //5 to 14
   SNA = 15
};


struct UpdateHistoryInfo
{
   std::string versionName;
   bool status;
   std::string date;
};


#ifndef VARIANT_S_FTR_ENABLE_UNITTEST

struct Auto_TimeZonePropertyInfo
{
   int8 minutes;
   int8 hour;
   uint8 mode;
   //uint8 propertytype;
};


struct TimeZoneListItemInfo
{
   Candera::String TimeZoneText;
   uint16 index;
   bool enable;
};


struct TimeZoneList
{
   std::vector< std::string > TimeZoneTextList;
   std::vector< uint16 > Index;
};


#endif
}


}


#endif

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
