/* ***************************************************************************************
* FILE:          SystemHall.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SystemHall.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hall_std_if.h"
#include "App/Core/SystemHall.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "App/Core/AppLogic/CabinA/CabinASettingListhandler/CabinAAudioSettingListHandler/CabinAAudioSettingListHandler.h"
#include "Common/VariantHandling/VariantHandling.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::SystemHall::
#include "trcGenProj/Header/SystemHall.cpp.trc.h"
#endif
#define PLUGIN_NAME_SETTINGS "Settings"
#define CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES  "CabinAGlasses"


using namespace ::App::Core;
using namespace ::CourierTunnelService::CourierMessageReceiver;
//using namespace ::SystemDataPool;


namespace App {
namespace Core {


#define OBJDEST(x) if(x!=NULL){delete x; x=NULL;}
#define EN_ACTIVITY_IDS bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs

//HmiDataServiceClientHandler* dataserviceclient = NULL;

//DiagnosisSrvClient* diagnosisclientotest = NULL;
//DisplaySrvClient* displaytotest = NULL;
//AudioServiceClient* audiototest = NULL;

#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT

CabinASettingListhandler* _cabinasettinglist = NULL;
#endif
DEFINE_CLASS_LOGGER_AND_LEVEL("App/Core", SystemHall, Info);

SystemHall::SystemHall()
   : HallComponentBase("", "App.Core.AppHmi_System", "/org/genivi/NodeStateManager/LifeCycleConsumer/AppHmi_System"),
     m_poApplicationSwitchProxy(ApplicationSwitchProxy::createProxy("applicationSwitchPort", *this)),
     _applicationSwitchClient(NULL),
     _displayclient(NULL),
     _DisplaySettings(NULL),
     _HmiStateHandler(NULL),
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
     _SrvClientBT(NULL),
     _navigationSrvClient(NULL),
#endif
     _systemdatapoolconfig(NULL),
     _RVCSettingListHandler(NULL),
     _RVCBrightnessHandler(NULL),
     _RVCContrastHandler(NULL),
     _audioserviceclient(NULL),
     _languageSettingListHandler(NULL),

     _NaftaLanguageSettingListHandler(NULL),
     _configurationVersion(NULL),
     _vehicleserviceClient(NULL),
     _systemSettingsListHandler(NULL),
     _micsetting(NULL),
     _OEMmenu(NULL),
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
     _dtcInfoCodeStatus4AllSubSM(NULL),
     _cabinAsettingListhandler(NULL),
     _cabinAglassSettingListhandler(NULL),
     _cabinASwivelCalibration(NULL),
     _cabinAAudioSettingListHandler(NULL),
     _cabinAVideoMixSourceListHandler(NULL),
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
     _cabinBsettingListhandler(NULL),
#endif
     _audioSettingListHandler(NULL),
     _cabinInfoSrvClient(NULL),
     _diagnosisserviceclnthandler(NULL),
     _diagnosisclient(NULL),
     _rearviewhandler(NULL),
     _clockSettings(NULL),
     _clockSrvClient(NULL),
     _midwDiagnosis(NULL),
     _GpsClockListHandler(NULL),
     _popupTimer(NULL),
     _swupdateclient(NULL),
     _swupdate(NULL),
     _swupdatelisthandler(NULL),
     _spmSrvClient(NULL),
     _AudioPrivateModeRBtn(NULL),
     _AudioSpdDepdentVolCntrlRBtn(NULL),
     _AudioEquilizerPresetRBtn(NULL),
     _ClockDateFormatRadioBtn(NULL),
     _hmidatasrvhandler(NULL),
     _hmidatastubhandler(NULL)
{
   ETG_I_REGISTER_FILE();

   // ETG_TRACE_FATAL(("Settings Hmi Hall Component"));
   ETG_TRACE_USR4(("SystemHall_AppHmi_SystemSetting"));
   _systemSettingsListHandler = SystemSettingsListHandler::poGetInstance();
   _micsetting = MicSetting::poGetInstance();
   _OEMmenu = OEMmenu::poGetInstance();
   _pluginClientHandler = PluginClientHandler::getInstance();
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
   _dtcInfoCodeStatus4AllSubSM = DTCInfoCodeStatus4AllSubSM::poGetInstance();
   _cabinAsettingListhandler = CabinASettingListhandler::poGetInstance();
   _cabinAglassSettingListhandler = CabinAGlassSettingListhandler::poGetInstance();
   _cabinASwivelCalibration = CabinASwivelCalibration::poGetInstance();
   _cabinAAudioSettingListHandler = CabinAAudioSettingListHandler::poGetInstance();
   _cabinAVideoMixSourceListHandler = CabinAVideoMixSourceListHandler::poGetInstance();
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
   _cabinBsettingListhandler = CabinBSettingListhandler::poGetInstance();
#endif
   _systemdatapoolconfig = SystemDataPoolConfig::getInstance();			//datapool
   _diagnosisserviceclnthandler = DiagnosisServiceClientHandler::GetInstance();

   _audioserviceclient = AudioServiceClient::poGetInstance();
   _cabinInfoSrvClient = CabinInfoSrvClient::poGetInstance();
   _audioSettingListHandler = AudioSettingListHandler::poGetInstance();
   _languageSettingListHandler = LanguageSettingListHandler::poGetInstance();
   _NaftaLanguageSettingListHandler = NaftaLanguageSettingListHandler::poGetInstance();
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   _configurationVersion = ConfigurationVersion::poGetInstance();
#endif
   _vehicleserviceClient = VehicleSrvClient::poGetInstance();
   //  _systemcouriermessagehandler = new SystemCourierMsgHandler(_displayclient);
   _clockSettings = ClockSettings::poGetInstance();
   _GpsClockListHandler = GpsClockListHandler::poGetInstance();
   _ClockDateFormatRadioBtn = ClockDateFormatRadioBtn::poGetInstance();
   // _systemSettingsListHandler = SystemSettingsListHandler::poGetInstance();
   _clockSrvClient = ClockSrvClient::poGetInstance();
   _midwDiagnosis = MIDWDiagnosis::poGetInstance();
   _applicationSwitchClient = ApplicationSwitchClientComponent::poGetInstance();
   _rearviewhandler = RearViewCamera::poGetInstance();
   _swupdateclient = SWUpdateClient::GetInstance();
   _swupdate = SWUpdate::GetInstance();
   _swupdatelisthandler = new SoftwareUpdateListHandler();
   _popupTimer = new PopupTimer();
   _spmSrvClient = SpmSrvClient::GetInstance();
   CurrentActiveRegion = COCKPIT_REGION;
   (void)NavigationModeDBHandler::getInstance();

   /*added for testing*/
   _DisplaySettings =  DisplaySettings::poGetInstance();
   //_BluetoothSetting =  BluetoothSetting::poGetInstance();
   _diagnosisclient = 	DiagnosisSrvClient::poGetInstance();
   _displayclient = DisplaySrvClient::poGetInstance();
   _HmiStateHandler = HmiStateHandler::poGetInstance();
   _AudioSpdDepdentVolCntrlRBtn =  AudioSpdDepdentVolCntrlRBtn::poGetInstance();
   _AudioEquilizerPresetRBtn =  AudioEquilizerPresetRBtn::poGetInstance();

   _AudioPrivateModeRBtn = AudioPrivateModeRBtn::poGetInstance();

   _hmidatasrvhandler = HmiDataServiceClientHandler::poGetInstance();
   _hmidatastubhandler = HmiDataStubHandler::poGetInstance();

   _RVCSettingListHandler = RVCSettingListHandler::poGetInstance();
   _RVCBrightnessHandler = RVCBrightnessHandler::poGetInstance();
   _RVCContrastHandler = RVCContrastHandler::poGetInstance();
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   _SrvClientBT = ServiceBT::poGetInstance();
   _navigationSrvClient = NavigationServiceClient::poGetInstance();
   //_BluetoothSetting =  BluetoothSetting::poGetInstance();
#endif
   // displaytotest = _displayclient;
   // audiototest = _audioserviceclient;

   //diagnosisclientotest = _diagnosisclient;
   //dataserviceclient = _hmidatasrvhandler;
   if (VariantHandling::getInstance() != NULL)
   {
      uint8 varianttype = VariantHandling::getInstance()->getVariantType();
      m_u8activeRegion  = (varianttype == VARIANTTYPE_CC) ? CABIN_A_REGION : COCKPIT_REGION;
      ETG_TRACE_USR2(("SystemHall Constructor varianttype=%d, m_u8activeRegion=%d", varianttype, m_u8activeRegion));
   }
   sm_mt_audio_flag = 0;
   sm_mot_flag = 0;

   if (NULL != _pluginClientHandler)
   {
      std::vector<std::string> settingsCtrlBlockNames;
      settingsCtrlBlockNames.push_back(CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES);
      std::map<std::string, std::vector<std::string> > pluginCtrlBlockMap;
      pluginCtrlBlockMap.insert(std::pair<std::string, std::vector<std::string> >(PLUGIN_NAME_SETTINGS, settingsCtrlBlockNames));

      _pluginClientHandler->registerPluginSignals(pluginCtrlBlockMap);
   }

   uint8 dummy = 0;
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   if (NULL != pluginData.get())
   {
      pluginData->addEventData(dummy);
      POST_MSG((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_SETTINGS, CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES, pluginData)));
      //ETG_TRACE_USR4(("CabinASwivelCalibration::onCourierMessage(SendPluginReq) : PluginCommandReqMsg sent"));
   }
}


SystemHall::~SystemHall()
{
   ETG_TRACE_USR4(("SystemHall : Destructor"));
   OBJDEST(_audioSettingListHandler);
   OBJDEST(_cabinInfoSrvClient);
   OBJDEST(_systemSettingsListHandler);
   OBJDEST(_micsetting);
   OBJDEST(_OEMmenu);
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
   OBJDEST(_cabinAsettingListhandler);
   OBJDEST(_dtcInfoCodeStatus4AllSubSM);
   OBJDEST(_cabinAglassSettingListhandler);
   OBJDEST(_cabinASwivelCalibration);
   OBJDEST(_cabinAAudioSettingListHandler);
   OBJDEST(_cabinAVideoMixSourceListHandler);
#endif
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
   OBJDEST(_cabinBsettingListhandler);
#endif
   OBJDEST(_systemdatapoolconfig)	;				//DATA POOL
   OBJDEST(_languageSettingListHandler);
   OBJDEST(_NaftaLanguageSettingListHandler);
   OBJDEST(_configurationVersion);
   OBJDEST(_DisplaySettings);
   //OBJDEST(_BluetoothSetting);
   OBJDEST(_rearviewhandler);
   OBJDEST(_vehicleserviceClient);
   OBJDEST(_ClockDateFormatRadioBtn);
   OBJDEST(_clockSettings);
   OBJDEST(_clockSrvClient);
   OBJDEST(_midwDiagnosis);
   OBJDEST(_GpsClockListHandler);
   OBJDEST(_AudioSpdDepdentVolCntrlRBtn);
   OBJDEST(_AudioEquilizerPresetRBtn);
   OBJDEST(_AudioPrivateModeRBtn);
   OBJDEST(_swupdatelisthandler);
   OBJDEST(_swupdate);
   OBJDEST(_swupdateclient);
   OBJDEST(_popupTimer);
   OBJDEST(_spmSrvClient);

   OBJDEST(_RVCSettingListHandler);
   OBJDEST(_RVCBrightnessHandler);
   OBJDEST(_RVCContrastHandler);
   //OBJDEST(_systemcouriermessagehandler);
   OBJDEST(_applicationSwitchClient);
   OBJDEST(_hmidatasrvhandler);
   OBJDEST(_hmidatastubhandler);
   OBJDEST(_diagnosisserviceclnthandler);
   OBJDEST(_diagnosisclient);
   OBJDEST(_HmiStateHandler);
   OBJDEST(_audioserviceclient);
   // OBJDEST(displaytotest);
   OBJDEST(_displayclient);
#if defined VARIANT_S_FTR_ENABLE_NAVIGATION
   OBJDEST(_SrvClientBT);
   OBJDEST(_navigationSrvClient);
   //OBJDEST(_BluetoothSetting);
#endif
   // OBJDEST(audiototest);

   if (NULL != _pluginClientHandler)
   {
      delete _pluginClientHandler;
      _pluginClientHandler = NULL;
   }
}


void SystemHall::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_I_REGISTER_FILE();
   ETG_TRACE_USR3(("SystemHall::onAvailable"));
   if (m_poApplicationSwitchProxy && m_poApplicationSwitchProxy == proxy)
   {
      m_poApplicationSwitchProxy->sendActiveRegionIdRegister(*this);
      m_poApplicationSwitchProxy->sendActiveRegionIdGet(*this);
      m_poApplicationSwitchProxy->sendSig_ActivateContextRegister(*this);
   }
}


void SystemHall::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   if (m_poApplicationSwitchProxy && m_poApplicationSwitchProxy == proxy)
   {
      m_poApplicationSwitchProxy->sendActiveRegionIdDeregisterAll();
      m_poApplicationSwitchProxy->sendSig_ActivateContextDeregisterAll();
   }
}


void SystemHall::onExpired(asf::core::Timer& /*timer*/, boost::shared_ptr<asf::core::TimerPayload> /*data*/)
{
//   ETG_TRACE_USR4(("SYSTEMAPP : Received Timer expired\n"));
//   if (timer.getAct()  == Manualtune_timer.getAct())
//   {
//      if (data->getReason() == asf::core::TimerPayload_Reason__Completed)
//      {
//      }
//   }
//   else
//   {
//   }
}


bool SystemHall::onCourierMessage(const GuiStartupFinishedUpdMsg& Msg)
{
   bool isMsgConsumed = false;
   ETG_TRACE_USR4(("GuiStartupFinishedUpdMsg Recieved"));
   isMsgConsumed = HallComponentBase::onCourierMessage(Msg);
   ETG_TRACE_USR4(("GuiStartupFinishedUpdMsg Recieved isMsgConsumed %d", isMsgConsumed));
   //BluetoothSetting::poGetInstance()->UpdateBluetoothTglStatus(1);
   /*    int32_t MaxvalueDef = 5;
      int32_t MinvalueDef = 20;
       AudioSettingListHandler::poGetInstance()->onUpdateMenu1( 6, &MaxvalueDef);
   	AudioSettingListHandler::poGetInstance()->onUpdateMenu1( 7,&MinvalueDef); */

   /*Fix added for resolving the Bug-1354816. Update Mic Beep Volume to Plugin after we receive the startup Finished Upd Msg*/
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   CabinAAudioSettingListHandler::poGetInstance()->NotifyMicBeepVolumeAfterGuiStartUp();
#endif

   return false;
}


ETG_I_CMD_DEFINE((TraceCmd_SystemSettingsTrigger, "SystemTrigger %d", bool))
void SystemHall::TraceCmd_SystemSettingsTrigger(bool state)
{
   //ETG_TRACE_COMP(("SystemHall_AppHmi_SystemSetting  TraceCmd_SystemSettingsTrigger"));
//   ETG_TRACE_COMP(("SystemHall_AppHmi_SystemSetting  TraceCmd_SystemSettingsTrigger 456"));

#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
   ETG_TRACE_COMP(("SystemHall::TraceCmd_SystemSettingsTrigge run state %d", state));

   /*Below Line is used for the testing purpose only*/
//	CabinASettingListhandler::poGetInstance()->setCurrentGlassAvailablityStatusData(state);
#endif
   // diagnosisclientotest->FactoryReset();
   //dataserviceclient->totest(i);
   //displaytotest->test();
   //->totestaudio(i)
   /*ETG_TRACE_COMP(("SystemHall::getDpLanguageValue %d",SystemDataPoolConfig::getInstance()->getDpLanguageValue()));
   ETG_TRACE_COMP(("SystemHall::getDpBeepToneStatus %d",SystemDataPoolConfig::getInstance()->getDpBeepToneStatus()));
   ETG_TRACE_COMP(("SystemHall::getDpSystemCurrentMeasurementUnit %d",SystemDataPoolConfig::getInstance()->getDpSystemCurrentMeasurementUnit()));
   ETG_TRACE_COMP(("SystemHall::getDpBrightnessLevelDayMode %d",SystemDataPoolConfig::getInstance()->getDpBrightnessLevelDayMode()));
   ETG_TRACE_COMP(("SystemHall::getDpBrightnessLevelNightMode %d",SystemDataPoolConfig::getInstance()->getDpBrightnessLevelNightMode()));
   ETG_TRACE_COMP(("SystemHall::getDpSpeedLockStatus %d",SystemDataPoolConfig::getInstance()->getDpSpeedLockStatus()));*/
   //vehsrvclient->setdistanceunit(i);
}


/*ETG_I_CMD_DEFINE((TraceCmd_IlluminationControl, "IlluminationControl %d", int))
void SystemHall::TraceCmd_IlluminationControl(int i)
{
   ETG_TRACE_COMP(("SystemHall_AppHmi_SystemSetting  Illumination Control"));
   if ((i > 0) && (i < 8))
   {
      displaytotest->Inc_Dec_Brightness_Service(i);
   }
}


ETG_I_CMD_DEFINE((TraceCmd_SpeedVolumeControl, "SpeedVolumeControl %d", int))
void SystemHall::TraceCmd_SpeedVolumeControl(int i)
{
   ETG_TRACE_COMP(("SystemHall_AppHmi_SystemSetting  Speed Volume Control"));
   if ((i >= 0) && (i < 4))
   {
      ETG_TRACE_COMP(("SystemHall_AppHmi_SystemSetting  Speed Volume Control"));
      audiototest->performMainSinkSoundPropertyUserChange(15, i);
   }
}*/


/* else // Go to System Setting(180) from Audio Setting (181)
} */


bool SystemHall::onCourierMessage(const SwitchApplicationReq& /*oMsg*/)
{
   ETG_TRACE_USR3(("SystemHall->onCourierMessage:SwitchApplicationReq()"));
   CurrentActiveRegion = getActiveRegion();
   ETG_TRACE_USR4(("SystemHall::onCourierMessage:SwitchApplicationReq CurrentActiveRegion: %d g_sm_Context=%d", CurrentActiveRegion, g_sm_Context));
   if (_applicationSwitchClient != NULL)
   {
      if (g_sm_Context == enActivityIDs__eActivityID_MIC_SETTINGS)
      {
         _applicationSwitchClient->requestContextSwitchApplication(CurrentActiveRegion, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_MIC_SETTINGS,
               0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
      }
      else
      {
         _applicationSwitchClient->requestContextSwitchApplication(CurrentActiveRegion, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS,
               APPID_APPHMI_MASTER, enActivityIDs__eActivityID_HOME);
      }
   }
   else
   {
      ETG_TRACE_USR3(("SystemHall->Null pointer"));
   }
   return true;
}


#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
bool SystemHall::onCourierMessage(const SwitchCabin_B_ApplicationReq& /*oMsg*/)
{
   ETG_TRACE_USR3(("SystemHall->onCourierMessage:SwitchCabin_B_ApplicationReq()"));

   CurrentActiveRegion = getActiveRegion();

   //uint8 RxdCurrentActiveRegion=ReturnActiveRegionStatus();

   ETG_TRACE_USR4(("SystemHall::onCourierMessage, SwitchCabin_B_ApplicationReq CurrentActiveRegion: %d", CurrentActiveRegion));

//  ETG_TRACE_USR4(("SystemHall::onCourierMessage, RxdCurrentActiveRegion: %d", RxdCurrentActiveRegion));

   if (_applicationSwitchClient != NULL)
   {
      ETG_TRACE_USR3(("go to home screen"));
      //_applicationSwitchClient->requestSwitchApplication(APPID_APPHMI_MASTER);//2

      _applicationSwitchClient->requestContextSwitchApplication(CurrentActiveRegion, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS,
            APPID_APPHMI_MASTER, enActivityIDs__eActivityID_HOME);
      return true;
   }
   else
   {
      return false;
   }
}


#endif

#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
bool SystemHall::onCourierMessage(const SwitchCabin_A_ApplicationReq& /*oMsg*/)
{
   ETG_TRACE_USR3(("SystemHall->onCourierMessage:SwitchCabin_A_ApplicationReq()"));

   CurrentActiveRegion = getActiveRegion();

   //uint8 RxdCurrentActiveRegion=ReturnActiveRegionStatus();

   ETG_TRACE_USR4(("SystemHall::onCourierMessage, SwitchCabin_A_ApplicationReq CurrentActiveRegion: %d", CurrentActiveRegion));

//  ETG_TRACE_USR4(("SystemHall::onCourierMessage, RxdCurrentActiveRegion: %d", RxdCurrentActiveRegion));

   if (_applicationSwitchClient != NULL)
   {
      ETG_TRACE_USR3(("go to home screen"));
      //_applicationSwitchClient->requestSwitchApplication(APPID_APPHMI_MASTER);//2

      _applicationSwitchClient->requestContextSwitchApplication(CurrentActiveRegion, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS,
            APPID_APPHMI_MASTER, enActivityIDs__eActivityID_HOME);
      return true;
   }
   else
   {
      return false;
   }
}


#endif

/**
* Description     : Virtual function implemented to get update of onSig_ActivateContextError Error
*
* @param[in]      : proxy: the client side representation of the ContextSwitch IF
* @param[in]      : error : The error message of 'onSig_ActivateContextError'
* @return         : void
*/

void SystemHall::onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/, const ::boost::shared_ptr< Sig_ActivateContextError >& /*error*/)
{
   ETG_TRACE_USR4(("SystemHall::onSig_ActivateContextError"));
}


bool SystemHall::onCourierMessage(const VideoMixedSourceBack4mCabinHome& Msg)
{
   ETG_TRACE_USR3(("SystemHall-onCourierMessage-VideoMixedSourceBack4mCabinHome VideoMixedSourceBack4mCabinHome =( %d)", sm_contextid));
   ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();

   if ((enActivityIDs__eActivityID_SETTINGS == sm_contextid) && (m_u8activeRegion == CABIN_A_REGION)) //128 - Go to Media Setting(128) from Audio Setting (181)
   {
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-VideoMixedSourceBack4mCabinHome VideoMixedSourceBack4mCabinHome sm_contextid ==>%d ", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A, APPID_APPHMI_SYSTEM, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_SETTINGS);
   }

   else if ((enActivityIDs__eActivityID_CABINA_HOME == sm_contextid) && (m_u8activeRegion == CABIN_A_REGION)) // Go to Cabin Setting Main scene or  HomeScrene (193)
   {
      sm_contextid = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-VideoMixedSourceBack4mCabinHome VideoMixedSourceBack4mCabinHome sm_contextid ==>%d ", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A, APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_CABINA_HOME);
   }
   return true;
}


/*This Courier is called on click on back Button */
bool SystemHall::onCourierMessage(const MediaRadioBack4mAudio& /*Msg*/)
{
   ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio MediaRadioBack4mAudio =( %d)", sm_contextid));
   ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();

   if ((enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW == sm_contextid) && (sm_mt_audio_flag == 1) && ((m_u8activeRegion == COCKPIT_REGION))) //128 - Go to Media Setting(128) from Audio Setting (181)
   {
      sm_contextid = 0;
      sm_mt_audio_flag = 0;
      sm_mot_flag = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio Media SETTINGS SCREEN %d %d %d", sm_contextid, sm_mt_audio_flag, sm_mot_flag));
      _applicationSwitchClientComponent->requestContextSwitchApplication(COCKPIT_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME, APPID_APPHMI_MEDIA, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW);
   }
   else if ((enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW == sm_contextid) && (sm_mt_audio_flag == 1) && (m_u8activeRegion == COCKPIT_REGION)) // Go to Tuner Setting(111) from Audio Setting (181)
   {
      sm_contextid = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio TUNER SETTINGS SCREEN %d", sm_contextid));
      sm_mt_audio_flag = 0;
      sm_mot_flag = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio TUNER SETTINGS SCREEN %d %d %d", sm_contextid, sm_mt_audio_flag, sm_mot_flag));
      _applicationSwitchClientComponent->requestContextSwitchApplication(COCKPIT_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME, APPID_APPHMI_TUNER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW);
   }

   //////////////
   else if ((enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW == sm_contextid) && (m_u8activeRegion == CABIN_A_REGION)) //128 - Go to Media Setting(128) from Audio Setting (181)
   {
      sm_contextid = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio Media SETTINGS SCREEN %d ", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A, APPID_APPHMI_MEDIA, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW);
   }
   else if ((enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW == sm_contextid) && (m_u8activeRegion == CABIN_A_REGION)) // Go to Tuner Setting(111) from Audio Setting (181)
   {
      sm_contextid = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio TUNER SETTINGS SCREEN %d ", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A, APPID_APPHMI_TUNER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW);
   }

   ////////////////////

   else if (enActivityIDs__eActivityID_RVC_SETTINGS == sm_contextid) // Go to Tuner Setting(111) from Audio Setting (181)
   {
      sm_contextid = 0;
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio RVC SYSTEM SETTINGS MAIN SCREEN %d", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(COCKPIT_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_RVC_SETTINGS, 0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
   }
   /*   else if(enActivityIDs__eActivityID_SETTINGS== sm_contextid)// Go to System Setting(180) from Audio Setting (181)
     {
        ETG_TRACE_USR3(("SYSTEM SETTINGS MAIN SCREEN %d", sm_contextid));
        //_applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME, APPID_APPHMI_SYSTEM, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_SETTINGS);
        POST_MSG((COURIER_MESSAGE_NEW(GotoMainSoundSettings)()));
     } */
   else if (enActivityIDs__eActivityID_SETTINGS == sm_contextid) // Go to System Setting(180) from Audio Setting (181)
   {
      ETG_TRACE_USR3(("SystemHall-onCourierMessage-MediaRadioBack4mAudio SYSTEM SETTINGS MAIN SCREEN %d", sm_contextid));
      _applicationSwitchClientComponent->requestContextSwitchApplication(COCKPIT_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_VOLUME, APPID_APPHMI_SYSTEM, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)enActivityIDs__eActivityID_SETTINGS);
   }

   else
   {
      //NOTHING DOING
   }

   return true;

   // Format of requestContextSwitchApplication (Region,From AppID, From Activitiy ID, To AppID,To Activitiy ID )
}


// SWDL forward context switch request from Any Scene to SWDL inProgress, on trigger from SWDL middleware,or marker file presence
bool SystemHall::onCourierMessage(const RequestMISupdateContextSwitchMsg& /*oMsg*/)
{
   ETG_TRACE_USR3(("SystemHall::onCourierMessage (RequestMISupdateContextSwitchMsg) - Forward request to Master"));
   ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();

   // As this trigger is based on trigger, we mostly will be in Home Scree, but there is possiblity, if use enter Cabin
   _applicationSwitchClientComponent->requestContextSwitchApplication(CurrentActiveRegion, (EN_ACTIVITY_IDS)0, (EN_ACTIVITY_IDS)0, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS);

   return true;
}


/**
* Description     : Virtual function implemented to get update of onSig_ActivateContextSignal
*
* @param[in]      : proxy: the client side representation of the ContextSwitch IF
* @param[in]      : response : The response message of 'onSig_ActivateContextSignal'
* @return         : void
This is called on Switching Context Happens --

ie
	from Media Setting to Audio Setting/
	from System Setting to Audio Setting/
	from Tuner Setting to Audio Setting
    from Home to SWDL MIS progress - on resuming interrrupted download
*/

void SystemHall::onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onSig_ActivateContextSignal %d", signal->getTargetactivityId()));
//  ETG_TRACE_USR4(("SrcChangeHandler::sm_activityID =%d", sm_activityID));

   if (m_poApplicationSwitchProxy == proxy)
   {
      uint16 activityID = signal->getTargetactivityId();

      ActiveRegion_Selection = m_u8activeRegion;
      ETG_TRACE_USR4(("SystemHall::onActiveRegionIdUpdate, m_u8activeRegion: %d", m_u8activeRegion));
      ETG_TRACE_USR4(("SystemHall::onActiveRegionIdUpdate, ActiveRegion_Selection: %d", ActiveRegion_Selection));
      SWUpdate::GetInstance()->CurrentActiveRegion(m_u8activeRegion);

      //ETG_TRACE_USR4(("SrcChangeHandler::sm_activityID after  =%d", sm_activityID));

      if ((activityID == enActivityIDs__eActivityID_SETTINGS_VOLUME) && (sm_mot_flag == 1))
      {
         sm_mt_audio_flag = 1; //check audio is entered after media /tuner entrie
         ETG_TRACE_USR4(("SrcChangeHandler::entered sm_mt_audio_flag=%d", sm_mot_flag));
      }
      else
      {
         sm_mt_audio_flag = 0;
         //  sm_mot_flag=0;		//checks weather 1st time entered is Media /tuner
         ETG_TRACE_USR4(("SrcChangeHandler::entered sm_mt_audio_flag sm_mot_flag=%d %d", sm_mt_audio_flag, sm_mot_flag));
      }
      switch (activityID)
      {
         case enActivityIDs__eActivityID_SETTINGS: // 180
            //sm_contextid = 0;
            sm_contextid = 180;
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS =%d", enActivityIDs__eActivityID_SETTINGS));
            // This Condition is for Direct Entry from System Setting to Audio Setting , if we remove this system setting to audio will work for 1st time only , 2nd time it will enter either media or tuner .
            if (m_u8activeRegion == COCKPIT_REGION)
            {
               POST_MSG((COURIER_MESSAGE_NEW(GotoMainSoundSettings)())); //
               ETG_TRACE_USR4(("SrcChangeHandler::GotoMainSoundSettings"));
            }
            else if (m_u8activeRegion == CABIN_A_REGION)
            {
               POST_MSG((COURIER_MESSAGE_NEW(GotoMainCabinASettings)()));
               ETG_TRACE_USR4(("SrcChangeHandler::GotoMainCabinASettings"));
            }
            else
            {
               //Do Nothing
            }
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS; //180;
            break;
         case enActivityIDs__eActivityID_SETTINGS_VOLUME:     // request from SystemSettings, MediaSettings , TunerSettings --181
            // POST_MSG((COURIER_MESSAGE_NEW(MediaEntry2AudioSetting_1)()));
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS_VOLUME;//181;
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_VOLUME =%d", enActivityIDs__eActivityID_SETTINGS_VOLUME));
            break;
         case enActivityIDs__eActivityID_MIC_SETTINGS :   // request to MIC Settings--198
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_MIC_SETTINGS =%d", enActivityIDs__eActivityID_MIC_SETTINGS));
            g_sm_Context = enActivityIDs__eActivityID_MIC_SETTINGS; //198;
            POST_MSG((COURIER_MESSAGE_NEW(GotoMicSettings)())); //
            ETG_TRACE_USR4(("SrcChangeHandler::GotoMicSettings"));
            break;
         case enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW:  		//128
            if (m_u8activeRegion == COCKPIT_REGION)
            {
               sm_contextid = enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW; // request from MediaSettings
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW =%d", enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW));
               g_sm_Context = enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW; //128;
               sm_mot_flag = 1; //checks weather media is entered or not
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW sm_mot_flag=%d", sm_mot_flag));
            }
            else if (m_u8activeRegion == CABIN_A_REGION)
            {
               sm_contextid = enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW; // request from MediaSettings
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW =%d", enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW));
               g_sm_Context = enActivityIDs__eActivityID_MEDIA_SETTINGS_VIEW; //128;
            }
            else
            {
               // Do Nothing
            }
            break;
         case enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW :   // request from TunerSettings--111
            if (m_u8activeRegion == COCKPIT_REGION)
            {
               sm_contextid = enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW;
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW =%d", enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW));
               g_sm_Context = enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW; //111;
               sm_mot_flag = 1;
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_Tuner_SETTINGS_VIEW sm_mot_flag=%d", sm_mot_flag));
            }
            else if (m_u8activeRegion == CABIN_A_REGION)
            {
               sm_contextid = enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW; // request from MediaSettings
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW =%d", enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW));
               g_sm_Context = enActivityIDs__eActivityID_TUNER_SETTINGS_VIEW; //128;
            }
            else
            {
               // Do Nothing
            }
            break;
         case enActivityIDs__eActivityID_RVC_SETTINGS :   // request from RVC Settings--241
            // sm_contextid = enActivityIDs__eActivityID_RVC_SETTINGS;
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_RVC_SETTINGS =%d", enActivityIDs__eActivityID_RVC_SETTINGS));
            g_sm_Context = enActivityIDs__eActivityID_RVC_SETTINGS; //241;
            break;
         case enActivityIDs__eActivityID_SETTINGS_COCKPIT :   // request from Cockpit Settings--184
            // sm_contextid = enActivityIDs__eActivityID_SETTINGS_COCKPIT;
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_COCKPIT =%d", enActivityIDs__eActivityID_SETTINGS_COCKPIT));
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS_COCKPIT; //241;
            break;

         case enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A	:	//186
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A =%d", enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A));
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A; //186;
            break;

         case enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A		:	//187
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A =%d", enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A));
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A; //187;
            break;
         case enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS :   // request from SWDL InProgress--600
            // sm_contextid = enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS;
            ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS =%d", enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS));
            g_sm_Context = enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS; //600;
            break;

         case enActivityIDs__eActivityID_CABINA_HOME : //80
            if (m_u8activeRegion == CABIN_A_REGION)
            {
               sm_contextid = enActivityIDs__eActivityID_CABINA_HOME; // request from MediaSettings
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_HOME =%d", enActivityIDs__eActivityID_CABINA_HOME));
               g_sm_Context = enActivityIDs__eActivityID_CABINA_HOME;
            }
            break;
         case enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A :	//193
            if (m_u8activeRegion == CABIN_A_REGION)
            {
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A =%d", enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A));
               g_sm_Context = enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A;
            }
            break;
         case enActivityIDs__eActivityID_MONITOR_SETTINGS		:	//194
            if (m_u8activeRegion == CABIN_A_REGION)
            {
               ETG_TRACE_USR4(("SrcChangeHandler::enActivityIDs__eActivityID_MONITOR_SETTINGS =%d", enActivityIDs__eActivityID_MONITOR_SETTINGS));
               g_sm_Context = enActivityIDs__eActivityID_MONITOR_SETTINGS; //194;
               if ((SystemSettingsListHandler::poGetInstance()->getSettingsAppState()) == true)
               {
                  POST_MSG((COURIER_MESSAGE_NEW(GotoMonitorSettings)()));
               }
            }
            break;

         default :

            break;
      }
   }
}


bool SystemHall::onCourierMessage(const SettingSceneMsg& oMsg)
{
   ETG_TRACE_USR4(("ApplicationSwitchClientHandler::SettingSceneMsg: %d", oMsg.GetSettingType()));
   uint16 requestedsettingtype = oMsg.GetSettingType();
   uint16 activityID = 0;
   uint16 CurrentActiveRegion = getActiveRegion();

   ETG_TRACE_USR4(("ApplicationSwitchClientHandler::CurrentActiveRegion: %d", CurrentActiveRegion));
   switch (requestedsettingtype)
   {
      case enActivityIDs__eActivityID_SETTINGS  :				//180- System Setting
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS"));
         activityID = enActivityIDs__eActivityID_SETTINGS;
         break;

      case enActivityIDs__eActivityID_SETTINGS_VOLUME  :				//181- Audio Setting
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_VOLUME"));
         if (CurrentActiveRegion == 2)
         {
            activityID = enActivityIDs__eActivityID_SETTINGS_VOLUME;
            ETG_TRACE_USR4(("COCKPIT SETTINGS_VOLUME %d", enActivityIDs__eActivityID_SETTINGS_VOLUME));
         }
         else
         {
            //do nothing
         }
         break;

      case enActivityIDs__eActivityID_SETTINGS_COCKPIT :		//184- Cockpit Rest
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_COCKPIT"));
         activityID = enActivityIDs__eActivityID_SETTINGS_COCKPIT;
         break;

      case enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A :		//186- Cabin Audio Setting
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A"));
         activityID = enActivityIDs__eActivityID_SETTINGS_VOLUME_CABIN_A;
         break;

      case enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A :		//187- Cabin Setting Rest
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A"));
         activityID = enActivityIDs__eActivityID_SETTINGS_REST_CABIN_A;
         break;

      case enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS :		//600- SWDL_MIS_STAGE1_PROGRESS
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS"));
         activityID = enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_PROGRESS;
         break;

      case enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_RESULT :		//601- SWDL_MIS_STAGE1_RESULT
         ETG_TRACE_USR4(("enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_RESULT"));
         activityID = enActivityIDs__eActivityID_SETTINGS_SWDL_MIS_STAGE1_RESULT;
         break;

      case enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A : // 193- eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A
         if (CurrentActiveRegion == CABIN_A_REGION)
         {
            ETG_TRACE_USR4(("eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A"));
            activityID = enActivityIDs__eActivityID_SETTINGS_VIDEO_MIX_SOURCE_CABIN_A;
         }
         break;
      case enActivityIDs__eActivityID_MONITOR_SETTINGS : // 194-
         if (CurrentActiveRegion == CABIN_A_REGION)
         {
            ETG_TRACE_USR4(("enActivityIDs__eActivityID_MONITOR_SETTINGS"));
            activityID = enActivityIDs__eActivityID_MONITOR_SETTINGS;
         }
         break;
      default:
         break;
   }
   m_poApplicationSwitchProxy->sendSendContextRequest(*this, CurrentActiveRegion, APPID_APPHMI_SYSTEM, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)activityID);
   return true;
}


bool SystemHall::onCourierMessage(const NavigationCarModeInfo& oMsg)
{
   ETG_TRACE_USR4(("SystemHall::onCourierMessage carMode :%d coachMode :%d", oMsg.GetCarMode(),  oMsg.GetCoachMode()));

   (*_carModeVisibilityStatus).mVisibleStatus = oMsg.GetCarMode();
   _carModeVisibilityStatus.MarkItemModified(ItemKey::CarModeVisibility::VisibleStatusItem);
   _carModeVisibilityStatus.SendUpdate(true);
   return true;
}


void SystemHall::onRequestContextSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/, const ::boost::shared_ptr< RequestContextSwitchError >& /*error*/)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onRequestContextSwitchError "));
}


void SystemHall::onRequestContextSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/, const ::boost::shared_ptr< RequestContextSwitchResponse >& /*response*/)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onRequestContextSwitchResponse "));
}


void SystemHall::onSendContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/, const ::boost::shared_ptr< SendContextError >& /*error*/)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onSendContextError "));
}


void SystemHall::onSendContextResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/, const ::boost::shared_ptr< SendContextResponse >& /*response*/)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onSendContextResponse "));
}


void SystemHall::onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< ActiveRegionIdUpdate >& update)
{
   ETG_TRACE_COMP(("SystemHall::onActiveRegionIdUpdate"));
   if (update->hasActiveRegionId())
   {
      m_u8activeRegion = update->getActiveRegionId();
      ETG_TRACE_USR4(("SystemHall::onActiveRegionIdUpdate=%d", m_u8activeRegion));
   }
}


void SystemHall::onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< ActiveRegionIdError >& /*error*/)
{
   ETG_TRACE_USR4(("SrcChangeHandler::onActiveRegionIdError "));
}


uint8 SystemHall::ReturnActiveRegionStatus()
{
   return ActiveRegion_Selection;
}


uint8 SystemHall::getActiveRegion()
{
   ETG_TRACE_USR4(("SystemHall::getActiveRegion=%d", m_u8activeRegion));
   return m_u8activeRegion;
}


} // namespace Core
} // namespace App
