/* ***************************************************************************************
* FILE:          SystemGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  SystemGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "hall_std_if.h"
#include "SystemGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::SystemGui::
#include "trcGenProj/Header/SystemGui.cpp.trc.h"
#endif


//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_SYSTEM), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_SYSTEM), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_SYSTEM))
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_SYSTEM,SURFACEID_NONE,SURFACEID_TOP_POPUP_SURFACE_SYSTEM,SURFACEID_CENTER_POPUP_SURFACE_SYSTEM)
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_SYSTEM),
//
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_SYSTEM),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_SYSTEM),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE)

                            APPSETTINGS_END()
                            using namespace ::hmi;

namespace App {
namespace Core {


//SystemGui::SystemGui() : GuiComponentBase(hmi::apps::appHmi_System, appSettings)

SystemGui::SystemGui() : GuiComponentBase(hmi::apps::reference::appHmi_System, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_SYSTEM_APPCTRL_PROXY);
   SYNC_BLOCK_CONNECTION(765, CLOCK_GADGET);
   ETG_TRACE_USR4(("SystemGui_AppHmi_SystemSetting"));
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_SYSTEM, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_SYSTEM, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_SYSTEM, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_SYSTEMINSTALLATION_POPUP_SURFACE, DisplayID_D1);
}


SystemGui::~SystemGui()
{
}


unsigned int SystemGui::getDefaultTraceClass()
{
   ETG_TRACE_USR4(("SystemGui_8_AppHmi_SystemSetting"));
   return TR_CLASS_APPHMI_SYSTEM_MAIN;
}


void SystemGui::setupCgiInstance()
{
   ETG_TRACE_FATAL(("SystemGui::setupCgiInstance"));
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void SystemGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
   ETG_TRACE_USR4(("SystemGui_3_AppHmi_SystemSetting"));
}


void SystemGui::postRun()
{
   PersistentValuesWrite();
   ETG_TRACE_USR4(("SystemGui_4_AppHmi_SystemSetting"));
}


void SystemGui::PersistentValuesRead()
{
//   dp_tclhmiAppSystemPersMemVarsSystem dp;
//   _mvar = dp.tGetData();
}


void SystemGui::PersistentValuesWrite()
{
//   dp_tclhmiAppSystemPersMemVarsSystem dp;
//   dp.s32SetData(_mvar);
   ETG_TRACE_USR4(("SystemGui_5_AppHmi_SystemSetting"));
}


/**
 *sink for not processed ttfis input messages
 */
void SystemGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
