/**************************************************************************************
* @file         : SoftwareUpdateListHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef SOFTWARE_UPDATE_LIST_HANDLER_H
#define SOFTWARE_UPDATE_LIST_HANDLER_H

#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/DataModel/ListRegistry.h"

namespace App {
namespace Core {
class SoftwareUpdateListHandler : public ListImplementation
{
   public:
      SoftwareUpdateListHandler();
      virtual ~SoftwareUpdateListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming courier messages from HMI

      // Incomming events ...
      COURIER_MSG_MAP_BEGIN(0)
      //   ON_COURIER_MESSAGE(Courier::StartupMsg)
      //   ON_COURIER_MESSAGE(Courier::ShutdownMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);

   private:
      unsigned int _listId;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(SoftwareUpdateListHandler);
};


}
}


#endif // SOFTWARE_UPDATE_LIST_HANDLER_H
