/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_System>
 */

#ifndef LANGUAGE_CLIENT_H
#define LANGUAGE_CLIENT_H


#include "AppHmi_SystemStateMachine.h"

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "datacollector_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#include "dp_generic_if.h"

#define LANGUAGE_EUROPE_SELECT 0X06
#define LANGUAGE_NAFTAS_SELECT 0X00


namespace App {
namespace Core {

class VehicleSrvClient : public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::DistanceUnitCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::SwivMonAutoOpenCallbackIF,
   public ::VEHICLE_MAIN_FI::PrivacyResetAckCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceInfoSWversionCallbackIF,
   public ::VEHICLE_MAIN_FI::Req_DeviceInfoCallbackIF,
   public ::VEHICLE_MAIN_FI::DriverDoorOpenCallbackIF

{
   public :

      static VehicleSrvClient* poGetInstance()
      {
         if (NULL == _VehicleSrvClient)
         {
            _VehicleSrvClient = new VehicleSrvClient();
         }

         return _VehicleSrvClient;
      }

      virtual ~VehicleSrvClient();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onDistanceUnitError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >&  proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DistanceUnitError >&  error);

      void onDistanceUnitStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >&  proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DistanceUnitStatus >&  status);
      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);

      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);

      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}
      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}
      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);

      void onSwivMonAutoOpenError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SwivMonAutoOpenError >& error);
      void onSwivMonAutoOpenStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SwivMonAutoOpenStatus >& status);

      void onPrivacyResetAckError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PrivacyResetAckError >& error);
      void onPrivacyResetAckResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::PrivacyResetAckResult >& result);
      void onDeviceInfoSWversionError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceInfoSWversionError >& error);
      void onDeviceInfoSWversionStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceInfoSWversionStatus >& status);
      void onReq_DeviceInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Req_DeviceInfoError >& error);
      void onReq_DeviceInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::Req_DeviceInfoResult >& result);
      void onDriverDoorOpenError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DriverDoorOpenError >& error);
      void onDriverDoorOpenStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DriverDoorOpenStatus >& status);
      void sendPrivacyResetAck();
      void setdistanceunit(uint i);
      void setHMILanguage(uint32 langcode);
      void destroy();
      void  setdeviceinfo(uint8 reqdeviceinfo);
      uint32 getCurrentLanguageStatusData();
   private:
      VehicleSrvClient();
      static VehicleSrvClient* _VehicleSrvClient;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      tU8 _vregionType4SystemSetting;
      uint32 _currentLanguageStatus;
};


}
}


#endif
