/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        HmiDataServiceClient.h
 * @brief       HmiDataServiceClient is to handle ServiceClient impl of HMIData Service.
 * @author      Sathiya Jayanth - ECG
 * @copyright   (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */

#ifndef HMIDATA_SERVICE_CLIENT_H
#define HMIDATA_SERVICE_CLIENT_H
#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppBase/ServiceAvailableIF.h"
#include "util/StrUtf8.h"
#include "bosch/cm/ai/nissan/hmi/hmidataservice/HmiDataProxy.h"
#endif
#include<iostream>
#include <string>
#include <cstdlib>

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
#include "AppHmi_SystemStateMachine.h"
#endif
#include "App/Core/ClientHandler/Diagnosis/DiagnosisServiceClientHandler.h"


namespace App {
namespace Core {

/**
 * Classes declaration
 */

#ifndef VARIANT_S_FTR_ENABLE_UNITTEST
class HmiDataServiceClientHandler
   : public ::asf::core::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SpeedLockStatusCallbackIF
   , public ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeCallbackIF
   , public IResetFactorySettings
//, public ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SetSpeedLockStatusCallbackIF
{
   public :
      virtual ~HmiDataServiceClientHandler();
      HmiDataServiceClientHandler();
      //void init();
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& /*proxy*/, const ::asf::core::ServiceStateChange& /*stateChange*/);
      //void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      //void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onSpeedLockStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SpeedLockStatusError >& error);
      void onSpeedLockStatusUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SpeedLockStatusUpdate >& update);
      void onDimmingModeError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeError >& error);
      void onDimmingModeUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::DimmingModeUpdate >& update);
      // void onSetSpeedLockStatusError(const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SetSpeedLockStatusError >& error);
      //  void onSetSpeedLockStatusResponse(const ::boost::shared_ptr<  ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy >& proxy, const ::boost::shared_ptr<  ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::SetSpeedLockStatusResponse >& response);

      void SetSpeedlock(bool status);
      int getSpeedlock();
      void SetDimmingMode(int mode);
      virtual void updateResetFactorySettingsInfo();
      static void destroy();
      ::boost::shared_ptr< ::bosch::cm::ai::nissan::hmi::hmidataservice::HmiData::HmiDataProxy> _hmiDataProxyClient;
      static HmiDataServiceClientHandler*  _hmidatasrvclient;
      uint8 speedlockstatus;
      static HmiDataServiceClientHandler* poGetInstance()
      {
         if (NULL == _hmidatasrvclient)
         {
            _hmidatasrvclient = new HmiDataServiceClientHandler();
         }

         return _hmidatasrvclient;
      }
};


#endif
} // namespace Core
} // namespace App

#endif
