/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   :
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef REARVIEWCAMERA_H_
#define REARVIEWCAMERA_H_


#include "rvc_cca_fiProxy.h"
#include "rvc_cca_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppBase/ServiceAvailableIF.h"
#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemDatabinding.h"
#include "AppHmi_SystemStateMachine.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
//#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include<map>

#define VIDEOPROPERTY_BRIGHT 0
#define VIDEOPROPERTY_CNTRST 1
namespace App {
namespace Core {

using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;

class RearViewCamera : public StartupSync::PropertyRegistrationIF
   , public hmibase::ServiceAvailableIF
   , public ReverseSignalStatusCallbackIF
   , public SetupVideoControlsCallbackIF
   , public SetupLanguageCallbackIF

{
   public:
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      static RearViewCamera* poGetInstance()
      {
         if (NULL == _RearViewClient)
         {
            _RearViewClient = new RearViewCamera();
         }

         return _RearViewClient;
      }

      virtual ~RearViewCamera();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusError >& error);
      void onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status);
      void onSetupLanguageError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupLanguageError >& error);
      void onSetupLanguageResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& proxy, const ::boost::shared_ptr< SetupLanguageResult >& status);
      void SetLanguage_RVC(uint32 languagecode);
      void sendSetupVideo(rvc_cca_fi_types::T_e8_RVC_VideoParameterType cameraSettingType, int value);
      /**
            * The result message of the method "SetupVideoControls"
            * This method is to inform the vd_rvc component about the Brightness, Contrast, Color Hue/Tint
            * and Black Level setup for the video signal done by the user.
            * This method has to be called by HMI once after system startup and in case of a change of the
            * setup done by the user.
            * <p>FUNCID = RVC_CCAFI_C_U16_SETUPVIDEOCONTROLS</p>
            * @param[in] - proxy - shared pointer for client side representation of a service,
            * @param[in] - status - gives the value of MIDW status
            * @param[out]- returns void
            */
      virtual void onSetupVideoControlsResult(
         const ::boost::shared_ptr<rvc_cca_fi::Rvc_cca_fiProxy>&,
         const ::boost::shared_ptr<rvc_cca_fi::SetupVideoControlsResult>& result);

      /**
       * The error message of 'SetupGuideLine'
       * @param[in] - proxy - shared pointer for client side representation of a service,
       * @param[in] - error - gives the error code and error info
       * @param[out]- returns void
       */
      virtual void onSetupVideoControlsError(const ::boost::shared_ptr<rvc_cca_fi::Rvc_cca_fiProxy>&,
                                             const ::boost::shared_ptr<rvc_cca_fi::SetupVideoControlsError>&);

      static void destroy();

      bool _currentrvcbrightnessStatus;
   private:

      RearViewCamera();
      static RearViewCamera* _RearViewClient;
      void CreateMapVehLangtoRVCLang();
      std::map<vehicle_main_fi_types::T_e8_Language_Code, rvc_cca_fi_types::T_e8_RVC_Language> LanguageValue;
      RearViewCamera(const RearViewCamera&);
      RearViewCamera& operator =(const RearViewCamera&);
      ::boost::shared_ptr< ::rvc_cca_fi::Rvc_cca_fiProxy > m_poRvcFiProxy;

      uint8 getCurrentRVCBringhtnessMWStatus();
      //Fix for Coverity warning - Removing below unused member variable
      //rvc_cca_fi_types::T_e8_RVC_StatusGuideLine _mGuidelineStatus;
      uint8 videoproperty;
};


}
}


#endif
